{           ͻ
                                                                           
                                                                           
                       lorenz = PROGRAM TO PLOT LORENZ ATTRACTOR           
                                                                           
            ͼ
}

program lorenz;

uses CRT,Graph;

const
     maxcol = 639;
     maxrow = 349;
     rad_per_degree=0.0174533;
     third=0.333333333;
var
    x,y,z,d0_x,d0_y,d0_z,d1_x,d1_y,d1_z,d2_x,d2_y,d2_z,
	d3_x,d3_y,d3_z,xt,yt,zt,dt,dt2,x_angle,y_angle,z_angle,
	sx,sy,sz,cx,cy,cz,temp_x,temp_y,old_y: real;
    dummy,GraphDriver,GraphMode,i, j, row, color,col, old_row, old_col: integer;
    ch: char;

function radians_to_degrees(degrees:real):real;

    begin
    	while degrees >= 360 do
		degrees := degrees - 360;
	while degrees < 0 do
		degrees := degrees + 360;
	radians_to_degrees := rad_per_degree*degrees;
    end;


begin

        color := 15;
        x_angle := 45;
        y_angle := 0;
        z_angle := 90;
	x_angle := radians_to_degrees(x_angle);
	sx := sin(x_angle);
	cx := cos(x_angle);
	y_angle := radians_to_degrees(y_angle);
	sy := sin(y_angle);
	cy := cos(y_angle);
	z_angle := radians_to_degrees(z_angle);
	sz := sin(z_angle);
	cz := cos(z_angle);
	for j:=0 to 2 do
        begin
		color := 4;
                GraphDriver := 4;
                GraphMode := EGAHi;
		InitGraph(GraphDriver,GraphMode,'');
		SetLineStyle(0,$FFFF,3);
                SetColor(15);
		x := 0;
		y := 1;
		z := 0;
		if j = 0 then
		begin
			old_col := Round(y*9+320);
			old_row := Round(350 - 6.56*z);
			Line(0,348,639,348);
			Line(320,2,320,348);
			OutTextXY(628,330,'Y');
			OutTextXY(330,12,'Z');
		end;
		if j = 1 then
		begin
			old_col := Round(y*10+320);
			old_row := Round(175 - 7.29*x);
			Line(0,175,639,175);
			Line(320,2,320,348);
			OutTextXY(628,160,'Y');
			OutTextXY(330,12,'X');
		end;
                if j = 2 then
                begin
			old_col := Round(y*9);
			old_row := Round(350 - 6.56*z);
			Line(0,348,638,348);
			Line(320,2,320,348);
			Line(320,348,648,140);
			OutTextXY(628,330,'Y');
			OutTextXY(330,12,'Z');
			OutTextXY(628,112,'X');
                end;
		SetLineStyle(0,$FFFF,1);
		dt := 0.01;
		dt2 := dt/2;
		for i:=0 to 8000 do
                begin
			d0_x := 10*(y-x)*dt2;
			d0_y := (-x*z + 28*x - y)*dt2;
			d0_z  := (x*y - 8*z/3)*dt2;
			xt := x + d0_x;
			yt := y + d0_y;
			zt := z + d0_z;
			d1_x := (10*(yt-xt))*dt2;
			d1_y := (-xt*zt + 28*xt - yt)*dt2;
			d1_z  :=(xt*yt - 8*zt/3)*dt2;
			xt := x + d1_x;
			yt := y + d1_y;
			zt := z + d1_z;
			d2_x := (10*(yt-xt))*dt;
			d2_y := (-xt*zt + 28*xt - yt)*dt;
			d2_z  :=(xt*yt - 8*zt/3)*dt;
			xt := x + d2_x;
			yt := y + d2_y;
			zt := z + d2_z;
			d3_x := (10*(yt - xt))*dt2;
			d3_y := (-xt*zt + 28*xt - yt)*dt2;
			d3_z := (xt*yt - 8*zt/3)*dt2;
                        old_y := y;
			x := x + (d0_x + d1_x + d1_x + d2_x + d3_x) * third;
			y := y + (d0_y + d1_y + d1_y + d2_y + d3_y) * third;
			z := z +  (d0_z + d1_z + d1_z + d2_z + d3_z) * third;
			if j = 0 then
                        begin
				col := Round(y*9+320);
				row := Round(350 - 6.56*z);
                                if col < 320 then
                                   if old_col >= 320 then
                                      inc(color);
                                if col > 320 then
                                   if old_col <= 320 then
                                      inc (color);
                        end;
			if j = 1 then
                        begin
				col := Round(y*10.0+320);
				row := Round(175-7.29*x);
                                if col < 320 then
                                   if old_col >= 320 then
                                      inc(color);
                                if col > 320 then
                                   if old_col <= 320 then
                                      inc (color);
                        end;
                         if j = 2 then
                         begin
				temp_x := x*cx + y*cy + z*cz;
				temp_y := x*sx + y*sy + z*sz;
				col := Round(temp_x*8 + 320);
				row := Round(350 - temp_y*5);
                                if col < 320 then
                                   if old_col >= 320 then
                                      inc(color);
                                if col > 320 then
                                   if old_col <= 320 then
                                      inc (color);
                        end;

                SetColor(color);
                Line(old_col,old_row,col,row);
		old_row := row;
		old_col := col;
                end;
        ch := ReadKey;
        end;
end.
