program newton3;

uses CRT,Graph,Fractal;

const
	maxcol: integer = 639;
	maxrow: integer = 349;
	max_colors: integer = 16;
	max_iterations: integer = 64;
	max_size: integer = 4;
	file_name: string[15] = 'newton00.pcx';
var
	flag,GraphDriver,GraphMode,color,col,row,i: integer;
	deltaX, deltaY, X, Y, Xsquare,Xold,Yold,
		Ysquare,Ytemp,temp1,temp2,denom,theta: double;
	ch1: char;
	strings: array[0..80] of char;
	file_no: string[3];

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	setEGApalette(0,1);
	setEGApalette(1,9);
	setEGApalette(2,25);
	setEGApalette(3,15);
	setEGApalette(4,27);
	setEGApalette(5,48);
	setEGApalette(6,2);
	setEGApalette(7,18);
	setEGApalette(8,62);
	setEGApalette(9,63);
	setEGApalette(10,4);
	setEGApalette(11,37);
	setEGApalette(12,60);
	setEGApalette(13,46);
	setEGApalette(14,45);
	setEGApalette(15,47);
	XMax := 3.5;
	XMin := -3.5;
	YMax := 2.50;
	YMin := -2.50;
	deltaX := (XMax - XMin)/(maxcol);
	deltaY := (YMax - YMin)/(maxrow);
	for col:=0 to maxcol do
	begin
		if KeyPressed then
			exit;
		for row:=0 to maxrow do
		begin
			X := XMin + col * deltaX;
			Y := YMax - row * deltaY;
			Xsquare := 0;
			Ysquare := 0;
			Xold := 42;
			Yold := 42;
			i := 0;
			flag := 0;
			while (i <= max_iterations) and (flag = 0) do
			begin
				Xsquare := X*X;
				Ysquare := Y*Y;
				denom := 3*((Xsquare - Ysquare)*(Xsquare -
					Ysquare) + 4*Xsquare*Ysquare);
				if denom = 0 then
					denom := 0.00000001;
				X := 0.6666667*X + (Xsquare - Ysquare)/denom;

				Y := 0.6666667*Y - 2*X*Y/denom;
				if (Xold = X) and (Yold = Y) then
					flag := 1;
				Xold := X;
				Yold := Y;
				inc(i);
			end;
			if X>0 then
				color := i mod 5
			else
			begin
				if (X<-0.3) and (Y>0) then
					color := (i mod 5) + 5
				else
					color := (i mod 6) + 10;
			end;
			PutPixel(col, row, color);
		end;
	end;
	file_no := save_screen(0,0,639,349, file_name);
	ch1 := ReadKey;
end.
