program newton3i;

uses CRT,Graph,Fractal;

const
	maxcol: integer = 639;
	maxrow: integer = 349;
	max_colors: integer = 16;
	max_iterations: integer = 64;
	max_size: integer = 4;
	color_set: array[0..15] of integer =(1,8,25,27,11,4,36,52,61,45,2,
		16,23,35,62,63);
	file_name: string[15] = 'newton00.pcx';
var
	flag,GraphDriver,GraphMode,color,col,row,i: integer;
	deltaX, deltaY, X, Y, Xsquare,Ysquare,
		Ytemp,temp1,temp2,temp3,denom,theta: double;
	ch1: char;
	file_no: string[3];
	Xnew,Ynew,Xold,Yold: real;

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	for i:= 0 to 15 do
		setEGApalette(i,color_set[i]);
	XMax := 3.5;
	XMin := -3.5;
	YMax := 2.50;
	YMin := -2.50;
	deltaX := (XMax - XMin)/(maxcol);
	deltaY := (YMax - YMin)/(maxrow);
	for col:=0 to maxcol do
	begin
		if KeyPressed then
			exit;
		for row:=0 to maxrow do
		begin
			X := XMin + col * deltaX;
			Y := YMax - row * deltaY;
			Xsquare := 0;
			Ysquare := 0;
			Xold := 42;
			Yold := 42;
			i := 0;
			flag := 0;
			while (i <= max_iterations) and (flag = 0) do
			begin
				Xsquare := X*X;
				Ysquare := Y*Y;
				denom := (3*Xsquare - 3*Ysquare - 2);
				denom := denom*denom + 36*Xsquare*Ysquare;
				if denom = 0 then
					denom := 0.00000001;
				temp1 := X*Xsquare - 3*X*Ysquare - 2*X -5;
				temp2 := 3*Xsquare - 3*Ysquare - 2;
				temp3 := 3*Xsquare*Y - Ysquare*Y - 2*Y;
				X := X - (temp1 * temp2 - 6*X*Y*temp3)/denom;
				Y := Y - (temp1 * (-6*X*Y) + temp3 * temp2)
					/denom;
				Xnew := X;
				Ynew := Y;
				if (Xold = Xnew) and (Yold = Ynew) then
					flag := 1;
				Xold := X;
				Yold := Y;
				inc(i);
			end;
			if X>1 then
				color := i mod 5
			else
			begin
				if Y>0 then
					color := (i mod 5) + 5
				else
					color := (i mod 6) + 10;
			end;
			PutPixel(col, row, color);
		end;
	end;
	file_no := save_screen(0,0,639,349, file_name);
	ch1 := ReadKey;
end.
