program pharaoh;

uses CRT,Graph,Fractal;

var
	graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	ch: char;
	a_line,b_line,x_o,y_o,radius,r_sq,height: double;
	xbig,ybig,rbig,xtan,ytan,rtan: real;


procedure inverseOval(x: real; y: real; b: real; color: integer; aspect: real);

	var
		i, bnew,new_col, new_row: integer;
		length,new_length: real;
		a,a_square, b_square, two_a_square, two_b_square, four_a_square,
		four_b_square,d,row,col: longint;

	begin
		a := Round(b/aspect);

		b_square := Round(b*b);
		a_square := (a*a);
		row := Round(b);
		col := 0;
		two_a_square := a_square shl 1;
		four_a_square := a_square shl 2;
		four_b_square := b_square shl 2;
		two_b_square := b_square shl 1;
		d := two_a_square * ((row  -1)*(row )) + a_square +
		    two_b_square*(1-a_square);
		while a_square*row  > b_square * col do
		begin
			length := sqrt((x_o - col - x)*(x_o - col - x) +
				(y_o - row - y)*(y_o - row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o - col - x)*new_length/length);
			new_row := Round(-y_o + (y_o - row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o + col - x)*(x_o + col - x) +
				(y_o - row - y)*(y_o - row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o + col - x)*new_length/length);
			new_row := Round(-y_o + (y_o - row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o - col - x)*(x_o - col - x) +
				(y_o + row - y)*(y_o + row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o - col - x)*new_length/length);
			new_row := Round(-y_o + (y_o + row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o + col - x)*(x_o + col - x) +
				(y_o + row - y)*(y_o + row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o + col - x)*new_length/length);
			new_row := Round(-y_o + (y_o + row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			if d >= 0 then
			begin
				dec(row);
				d := d - four_a_square*(row);
			end;
			d := d + two_b_square*(3 + (col shl 1));
			inc(col);
		end;

		d := two_b_square * (col + 1)*col + two_a_square*(row *
        	        (row  -2) +1) + (1-two_a_square)*b_square;
		while row + 1 <> 0 do
		begin
			length := sqrt((x_o - col - x)*(x_o - col - x) +
				(y_o - row - y)*(y_o - row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o - col - x)*new_length/length);
			new_row := Round(-y_o + (y_o - row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o + col - x)*(x_o + col - x) +
				(y_o - row - y)*(y_o - row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o + col - x)*new_length/length);
			new_row := Round(-y_o + (y_o - row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o - col - x)*(x_o - col - x) +
				(y_o + row - y)*(y_o + row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o - col - x)*new_length/length);
			new_row := Round(-y_o + (y_o + row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			length := sqrt((x_o + col - x)*(x_o + col - x) +
				(y_o + row - y)*(y_o + row - y));
			new_length := r_sq/length;
			new_col := Round(x_o - (x_o + col - x)*new_length/length);
			new_row := Round(-y_o + (y_o + row - y)*new_length/length);
			PutPixel(new_col+320,175 - Round(new_row*0.729),color);
			if d <= 0 then
			begin
				inc(col);
				d := d + four_b_square*col;
			end;
			dec(row);
			d := d + two_a_square * (3 - (row shl 1));
		end;
		b := b + 1;
	end;

procedure gen_circle(x: real; y: real; radius: real);
	begin
		inverseOval(x,y,radius,15,1.0);
		inverseOval(-x,y,radius,15,1.0);
	end;

begin
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	r_sq := 400000;
	xbig := 0;
	ybig := 0;
	rbig := 220;
	rtan := 140;
	xtan := 0;
	ytan := ybig + rbig - rtan;
	y_o := ybig - rbig;
	x_o := xbig;
	Ellipse(Round(xbig+320),175 - Round(ybig*0.729),0,360,Round(rbig),
		Round(0.729*rbig));
	Ellipse(Round(xtan+320),175 - Round(ytan*0.729),0,360,Round(rtan),
		Round(0.729*rtan));
	a_line := r_sq/(2*rbig);
	b_line := r_sq/(2*rtan);
	height := (b_line - a_line);
	radius := height/2;
	height := radius*sqrt(2.0);
	for i:=0 to 15 do
	begin
		gen_circle(x_o + height*i,y_o + a_line + radius,radius);
		gen_circle(x_o + height*i,y_o + a_line + radius/2,radius/2);
		gen_circle(x_o + height*i,y_o + b_line - radius/2,radius/2);
		gen_circle(x_o + height*i + height/2,y_o + a_line +
			3*radius/4,radius/4);
		gen_circle(x_o + height*i + height/2,y_o + b_line -
			3*radius/4,radius/4);
		gen_circle(x_o + height*i + height/2,y_o + a_line + radius/8,
			radius/8);
		gen_circle(x_o + height*i + height/2,y_o + b_line - radius/8,
			radius/8);
		gen_circle(x_o + height*i + height/2,y_o + a_line +
			5*radius/12,radius/12);
		gen_circle(x_o + height*i + height/2,y_o + b_line -
			5*radius/12,radius/12);
		gen_circle(x_o + height*i + 0.4*height,y_o + a_line +
			0.3*radius,radius/10);
		gen_circle(x_o + height*i + 0.6*height,y_o + a_line +
			0.3*radius,radius/10);
		gen_circle(x_o + height*i + 0.4*height,y_o + b_line -
			0.3*radius,radius/10);
		gen_circle(x_o + height*i + 0.6*height,y_o + b_line -
			0.3*radius,radius/10);
	end;
	ch := ReadKey;
end.
