program phoenix;

uses CRT,Graph,Fractal;

const
	maxcol: integer = 639;
	maxrow: integer = 349;
	max_size: real = 4;
	file_string: array[0..3] of string[7] = (('pheset'),('phenix'),
		('phenix'),('phepal'));
	file2: string[5] = '.pcx';
	file3: string[5] = '.pal';
	file_name2: string[20] = 'phenix00.pcx';
	rect: array[1..4] of PointType = ((x: 0; y: 0),
							    (x: 639; y: 0),
							    (x: 639; y: 349),
							    (x: 0; y: 349));

var
	graphDriver,GraphMode,i,j,key,generator_size,level,init_size,
		file_no,color,row,col,error,start_col,end_mask,
		m,color_option,max_iterations: integer;
	deltaX,deltaXi,X,Y,Xi,Yi,Xisquare,Xsquare,Xtemp,Xitemp,P,Q: real;
	ch1: char;
	colors: array[0..14,0..2] of integer;
	file1: string[3];
	file_name: string[12];
	f: file of byte;
	f_pal: file of integer;

function menu(types: integer): integer;

const
	TextData: array[0..3] of string[48] =
		(('Select Phoenix Curve location from "PHESET" file'),
		('Expand a Section of an Existing Phoenix Curve'),
		('Complete an Unfinished Phoenix Curve'),
		('Quit'));
	TextData2: array[0..1] of string[45] =
		(('Select colors and ranges'),
		('Cycle through colors in order'));

var
	i,k: integer;
	ch1: char;
begin
	k := 0;
	Window(1,1,80,25);
	TextBackground(0);
	clrscr;
	if types = 0 then
	begin
		Window(8,6,62,13);
		m := 3;
	end
	else
	begin
		Window(10,6,59,11);
		m := 1;
	end;
	TextBackground(1);
	clrscr;
	GotoXY(3,2);
	TextColor(10);
	write('Make your choice with the up and down arrows:');
	repeat
		for i:=0 to m do
		begin
			if i = k then
			begin
				TextColor(1);
				TextBackground(15);
			end
			else
			begin
				TextColor(15);
				TextBackground(1);
			end;
			GotoXY(3,i+4);
			if types = 0 then
				write(TextData[i])
			else
				write(TextData2[i]);
		end;
		ch1:= ReadKey;
		if ch1 = char($00) then
		begin
			ch1 := ReadKey;
			case ch1 of
				 'P': begin
						if k = 3 then
							k := 0
						else
							inc(k);
					 end;
				 'H': begin
						if k = 0 then
							k := 3
						else
							dec(k);
					 end;
			end;
		end;
	until ch1 = char($0D);
	window(1,1,80,25);
	menu := k;
end;

function set_colors: integer;

const
	color_set: array[0..1] of integer = (1,1);

var
	i,k: integer;
	ch1: char;
begin
	TextBackground(4);
	clrscr;
     	k := 0;
	Window(10,4,70,22);
	TextBackground(0);
	clrscr;
	GotoXY(3,1);
	TextColor(10);
	writeln('Enter Upper Limit Number and use Arrows to Set Colors:');
	writeln;
	TextColor(14);
	write('  Start Iters   End Iters   Color #1  Color #2');
	writeln;
	i := 0;
	colors[0,0] := 0;
	colors[1,0] := 0;
	while colors[i,0] < max_iterations do
	begin
		inc(i);
		TextColor(15);
		GotoXY(6,i+5);
		write(colors[i-1,0]);
		GotoXY(20,i+5);
		Read(colors[i,0]);
		if colors[i,0] <= colors[i-1,0] then
		begin
			colors[i,0] := colors[i-1,0] + 1;
			GotoXY(20,i+5);
			write(colors[i,0]);
		end;
		if (i = 13) or (colors[i,0] > max_iterations) then
		begin
			colors[i,0] := max_iterations;
			GotoXY(20,i+5);
			write(colors[i,0]);
		end;
		GotoXY(30,i+5);
		TextColor(color_set[0]);
		write(char($DB),char($DB),char($DB),char($DB),char($DB),char($DB));
		TextColor(color_set[1]);
		GotoXY(40,i+5);
		write(char($DB),char($DB),char($DB),char($DB),char($DB),char($DB));
		for k:= 0 to 1 do
		begin
			GotoXY(36+ 10*k,i+5);
			repeat
				ch1:= ReadKey;
				if ch1 = char($00) then
				begin
					ch1 := ReadKey;
					case ch1 of
						 'P': begin
							if color_set[k] = 15 then
								color_set[k] := 0
							else
								inc(color_set[k]);
							 end;
						 'H': begin
								if color_set[k] = 0 then
									color_set[k] := 15
								else
									dec(color_set[k]);
							 end;
					end;
				end;
				GotoXY(30+10*k,i+5);
				TextColor(color_set[k]);
				write(char($DB),char($DB),char($DB),char($DB),char($DB),
					char($DB));
			until ch1 = char($0D);
		end;
		colors[i,1] := color_set[0];
		colors[i,2] := color_set[1];
		set_colors := i;
	end;
	Window(1,1,80,25);
	clrscr;
	TextColor(15);
end;

begin
	repeat
		key := menu(0);
		if key = 3 then
			exit;
		if key < 2 then
		begin
			TextBackground(0);
			clrscr;
			Window(15,8,66,11);
			TextBackground(4);
			clrscr;
			GotoXY(3,2);
			TextColor(15);
			write('Enter number of iterations desired (16-512): ');
			readln(max_iterations);
			if max_iterations < 16 then
				max_iterations := 16;
			if max_iterations > 512 then
				max_iterations := 512;
		end;
		color_option := menu(1);
		if (key < 2) and (color_option = 0) then
			end_mask :=  set_colors;
		TextBackground(0);
		clrscr;
		Window(15,8,66,11);
		TextBackground(2);
		clrscr;
		GotoXY(3,2);
		TextColor(15);
		if key = 0 then
			write('Enter "PHESET file number (00 - 99): ')
		else
			write('Enter Phoenix curve number (00 - 99); ');
		readln(file_no);
		Str(file_no,file1);
		Window(1,1,80,25);
		if file_no < 10 then
			file_name := Concat(file_string[key],'0',file1,file2)
		else
			file_name := Concat(file_string[key],file1,file2);
		error := restore_screen(file_name);
		if error = 0 then
			exit
		else
		begin
			CURSOR_X := 0;
			CURSOR_Y := 0;
			case key of
			0: begin
				start_col := 0;
				move_cursor(2,15,0,0);
				XMax := 1.5;
				XMin := -1.5;
				YMax := 1.2;
				YMin := -1.2;
				P := Pval;
				Q := Qval;
				if color_option = 1 then
				begin
					setEGApalette(0,1);
					setEGApalette(1,57);
					setEGApalette(2,2);
					setEGApalette(3,62);
				end;
				SetFillStyle(1,7);
				FillPoly(4,rect);
			   end;
			2: begin
				if (error = 639) or (error = 0) then
					exit;
				start_col := 8 * (error div 8);
				file_name2 := Copy(file_name,0,length(file_name));
				Assign(f,file_name);
				Erase(f);
				P := Pval;
				Q := Qval;
				if color_option = 0 then
				begin
					if file_no < 10 then
						file_name := Concat(file_string[3],'0',file1,
							file3)
					else
						file_name := Concat(file_string[3],file1,file3);
					Assign(f_pal,file_name);
					Reset(f_pal);
					for i:= 0 to 14 do
						for j:= 0 to 2 do
							read(f_pal,colors[i,j]);
					read(f_pal,max_iterations);
					read(f_pal,end_mask);
					Close(f_pal);
				end;
			   end;
			1: begin
				move_cursor(0,15,0,0);
				move_cursor(1,15,CURSOR_X,CURSOR_Y);
				XMax := TXMax;
				XMin := TXMin;
				YMax := TYMax;
				YMin := TYMin;
				P := Pval;
				Q := Qval;
				start_col := 0;
				SetFillStyle(1,7);
				FillPoly(4,rect);
			   end;
			end;
			deltaX := (YMax - YMin)/(maxrow - 1);
			deltaXi := (XMax - XMin)/(maxcol - 1);
			for col:=start_col to maxcol do
			begin
				if KeyPressed then
				begin
					Pval := P;
					Qval := Q;
					file1 := save_screen(0,0,col,349,file_name2);
					gotoxy(1,24);
					file_name := ConCat(file_string[2],file1,file2);
					write('File name is: ',file_name);
					if color_option = 0 then
					begin
						file_name := ConCat(file_string[3],file1,file3);
						Assign(f_pal,file_name);
						Rewrite(f_pal);
						for i:= 0 to 14 do
							for j:= 0 to 2 do
								write(f_pal,colors[i,j]);
						write(f_pal,max_iterations);
						write(f_pal,end_mask);
						Close(f_pal);
					end;
					exit;
				end;
				for row:=0 to maxrow do
				begin
					Y := 0;
					Yi := 0;
					X := YMax - row * deltaX;
					Xi := XMin + col * deltaXi;
					Xsquare := 0;
					Xisquare := 0;
					color := 0;
					while (color<max_iterations) and
						((Xsquare + Xisquare) < max_size) do
					begin
						Xsquare := X*X;
						Xisquare := Xi*Xi;
						Xtemp := Xsquare - Xisquare + P + Q*Y;
						Xitemp := 2*X*Xi + Q*Yi;
						Y := X;
						Yi := Xi;
						X := Xtemp;
						Xi := Xitemp;
						inc(color);
					end;
					if color_option = 0 then
					begin
						i:=0;
						while (color > colors[i,0]) do
							inc(i);
						if color mod 2= 0 then
							PutPixel(col,row,colors[i][2])
						else
							PutPixel(col,row,colors[i][1]);
					end
					else
					begin
						if color >= max_iterations then
							color := 0
						else
							color := color mod 14 + 1;
						PutPixel(col,row,color);
					end;
				end;
			end;
			Pval := P;
			Qval := Q;
			file1 := save_screen(0,0,639,349,file_name2);
			gotoxy(1,24);
			file_name := ConCat(file_string[2],file1,file2);
			write('File name is: ',file_name);
			ch1 := ReadKey;
			CloseGraph;
		end;
	until key = 3;
end.
