program pikespk;

uses Graph,CRT,Fractal;

const
	color_set: array[0..15] of integer =(27,1,2,11,10,10,34,31,47,50,18,
		2,6,27,62,63);
	color_value: integer = 2;
	file_name: array[0..11] of char = 'pikspk00.pcx';

var
	Triangle: array[1..3] of PointType;
	GraphDriver,GraphMode,interim,i,j,row,col: integer;
	y_max,x,y,xz,yz,xp,yp: real;
	ch1: char;
	file_no: string[3];

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer); forward;


procedure midpoint(x: real; y: real);

var
	r,w: real;
	seed: longint;

begin
	seed := Round(350*y + x);
	RandSeed := seed;
	r := 0.33333 + Random/3.0;
	w := 0.015 + Random/50.0;
	if Random < 0.5 then
		w := -w;
	xz := r*x - (w+0.05)*y;
	yz := r*y + (w +0.05)*x;
end;

procedure node(x1: integer; y1: integer; x2: integer; y2:integer;
	x3: integer; y3: integer; x4: integer; y4: integer; x5: integer;
	y5: integer; x6: integer; y6: integer; level: integer;
	color1: integer; color2: integer);

var
	x_ret1, y_ret1, x_ret2, y_ret2, x_ret3, y_ret3: integer;

begin
	if level <> 0 then
	begin
		generate (x1,y1,x6,y6,x4,y4,level-1,color1,color2);
		generate (x2,y2,x4,y4,x5,y5,level-1,color1,color2);
		generate (x3,y3,x5,y5,x6,y6,level-1,color1,color2);
		generate (x4,y4,x5,y5,x6,y6,level-1,color1,color2);
	end;
end;

procedure plot_triangle(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; color1: integer; color2: integer);

var
	color,temp: integer;
	zt,ytt: real;

begin
	if y1 > y2 then
		ytt := y1
	else
		ytt := y2;
	if ytt < y3 then
		ytt := y3;
	zt := 1 - ((ytt+240)*(ytt+240))/((y_max+240)*(y_max+240));
	if Random <= zt then
		color := color1
	else
		color := color2;
	if ytt + 240 <  ((y_max + 240)/4) then
		color := color1;
	if ytt+240 > (0.98 * (y_max+240)) then
		color := color2;
	Triangle[1].x := x1 + 320;
	Triangle[1].y := 175 - (longint(93*y1) div 128);
	Triangle[2].x := x2 + 320;
	Triangle[2].y := 175 - (longint(93*y2) div 128);
	Triangle[3].x := x3 + 320;
	Triangle[3].y := 175 - (longint(93*y3) div 128);
	SetColor(color);
	SetFillStyle(1,color);
	FillPoly(3,Triangle);
end;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer);

var
	x4,x5,x6,y4,y5,y6: integer;

begin

	x := x2 - x1;
	y := y2 - y1;
	midpoint(x,y);
	x4 := x1 + Round(xz);
	y4 := y1 + Round(yz);
	x := x1 - x3;
	y := y1 - y3;
	midpoint(x,y);
	x6 := x3 + Round(xz);
	y6 := y3 + Round(yz);
	x := x3 - x2;
	y := y3 - y2;
	midpoint(x,y);
	x5 := x2 + Round(xz);
	y5 := y2 + Round(yz);
	if level = 0 then
	begin
		plot_triangle(x1,y1,x6,y6,x4,y4,color1,color2);
		plot_triangle(x2,y2,x4,y4,x5,y5,color1,color2);
		plot_triangle(x3,y3,x5,y5,x6,y6,color1,color2);
		plot_triangle(x4,y4,x5,y5,x6,y6,color1,color2);
	end
	else
		node(x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,color1,
				color2);
end;

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	for i:=0 to 15 do
		setEGApalette(i,color_set[i]);
	y_max := 180;
	generate(-220,-240,120,100,500,-40,6,3,7);
	y_max := 160;
	generate(-780,-200,30,130,480,-150,6,4,8);
	y_max := 180;
	generate(-480,0,-240,60,0,-60,5,5,9);
	generate(-100,-260,240,40,500,-180,5,6,10);
	Triangle[1].x := 0;
	Triangle[1].y := 320;
	Triangle[2].x := 0;
	Triangle[2].y := 225;
	Triangle[3].x := 639;
	Triangle[3].y := 225;
	SetColor(1);
	SetFillStyle(1,1);
	FillPoly(3,Triangle);
	Triangle[1].x := 639;
	Triangle[1].y := 225;
	Triangle[2].x := 639;
	Triangle[2].y := 320;
	Triangle[3].x := 0;
	Triangle[3].y := 320;
	FillPoly(3,Triangle);
	y_max := -100;
	generate(-770,-300,-250,-110,600,-300,5,11,12);
	generate(-550,-280,-60,-140,400,-300,5,11,12);
	generate(-220,-280,80,-130,340,-300,4,11,12);
	generate(-200,-280,230,-120,580,-300,4,11,12);
	file_no := save_screen(0,0,639,350,file_name);
	ch1 := ReadKey;
end.

