
program planet;

uses Graph,CRT,Fractal;

const
	color_set: array[0..15] of integer =(0,57,2,20,8,49,60,40,24,40,0,49,60,
		61,62,63);
	file_name: array[0..11] of char = 'planet00.pcx';
	xa: array[0..32] of integer = (-82,-80,-90,-70,-50,-30,-25,25,40,42,
		20,35,40,50,60,60,-28,70, -25,70,108,81,60,45,48,96,45,38,-8,0,
		-20,-28,55);
	xb: array[0..32] of integer = (-70,-70,-80,-50,-30,25,-25,40,65,65,
		40,38,40,60,60,70,-28,90, -20,105,92,70,56,48,54,100,38,46,12,
		14,14,8,62);
	xc: array[0..32] of integer = (-70,-70,-80,-50,-50,20,30,40,40,58,
		40,37,50,50,70,75,20,90, -40,95,83,70,45,60,60,54,106,65,12,
		40,14,-8,95);
	xd: array[0..32] of integer = (-90,-80,-90,-70,-30,20,20,25,50,50,
		20,40,50,60,70,75,20,70, -40,90,81,108,45,56,96,45,100,106,8,
		44,0,-30,55);
	ya: array[0..32] of integer = (52,52,76,80,76,38,10,80,90,55,50,3,
		60,60,52,55,80,115, 38,109,76,80,-130,-124,-90,-70,-60,-50,0,
		-10,10,90,-100);
	yb: array[0..32] of integer = (52,52,76,80,80,30,30,80,70,70,40,5,
		8,52,38,38,20,120, 78,104,58,95,-124,-90,-65,-60,-50,-25,0,
		-10,10,80,-100);
	yc: array[0..32] of integer = (60,80,80,55,56,38,10,90,80,70,3,-5,
		60,20,38,40,20,106, 78,76,60,110,-124,-100,-100,-65,-50,-25,
		-18,-30,-18,75,-50);
	yd: array[0..32] of integer= (60,80,77,55,38,30,30,90,60,60,3,-4,
		20,27,38,40,74,109, 43,76,80,76,-124,-124,-70,-60,-60,-50,
		-18,-30,-18,85,-50);
	color_value: integer = 2;
	level1: integer = 4;

var
	Triangle: array[1..3] of PointType;
	GraphDriver,GraphMode,interim,i,j,row,col,c_type: integer;
	y_max,x,y,xz,yz,xp,yp: real;
	ch1: char;
	file_no: string[3];
	x_center, y_center, radius: longint;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer); forward;

procedure ranFillOval(x: integer; y:integer; b: integer; color: integer;
	aspect: real);

var
	col,row,dummy,mask,end_x,end_y,kx,radius: integer;
	a,aspect_square: real;
	a_square,b_square,b_test,offset: longint;

begin

	a := b/aspect;
	a_square := Round(a*a);
	radius := b;
	b := (93*b) div 128;
	b_square := b*b;
	x := x + 320;
	y := 175 - (93*y) div 128;
	end_x := x + Round(a);
	end_y := y + Round(b);
	for col:=x - Round(a) to end_x do
	begin
		b_test := b_square - (b_square*(col-x)*(col-x)) div a_square;
		mask := $80 shr (col mod 8);
		Port[$3CE] := 8;
		Port[$3CF] := mask;
		Port[$3C4] := 2;
		Port[$3C5] := $0F;
		for row:=y-b to end_y do
		begin
			kx := Random(25205 div radius);
			if ((row-y)*(row-y) <= b_test) and (kx < (col-x+20)) then
			begin
				offset := row*80 + (col div 8);
				dummy := byte(Mem[$A000:offset]);
				Mem[$A000:offset] := 0;
				Port[$3C4] := 2;
				Port[$3C5] := color;
				Mem[$A000:offset] := $FF;
				Port[$3C4] := 2;
				Port[$3C5] := $0F;
			end;
		end;
	end;
	Port[$3CE] := 3;
	Port[$3CF] := 0;
	Port[$3CE] := 8;
	Port[$3CF] := $FF;
end;

procedure midpoint(x: real; y: real);

var
	r,w: real;
	seed: longint;

begin
	seed := Round(350*y + x);
	RandSeed := seed;
	r := 0.33333 + Random/3.0;
	w := 0.015 + Random/50.0;
	if Random < 0.5 then
		w := -w;
	xz := r*x - (w+0.05)*y;
	yz := r*y + (w +0.05)*x;
end;

procedure node(x1: integer; y1: integer; x2: integer; y2:integer;
	x3: integer; y3: integer; x4: integer; y4: integer; x5: integer;
	y5: integer; x6: integer; y6: integer; level: integer;
	color1: integer; color2: integer);

var
	x_ret1, y_ret1, x_ret2, y_ret2, x_ret3, y_ret3: integer;

begin
	if level <> 0 then
	begin
		generate (x1,y1,x6,y6,x4,y4,level-1,color1,color2);
		generate (x2,y2,x4,y4,x5,y5,level-1,color1,color2);
		generate (x3,y3,x5,y5,x6,y6,level-1,color1,color2);
		generate (x4,y4,x5,y5,x6,y6,level-1,color1,color2);
	end;
end;

procedure plot_triangle(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; color1: integer; color2: integer);

var
	color,temp: integer;
	zt,ytt: real;

begin
	if y1 > y2 then
		ytt := y1
	else
		ytt := y2;
	if ytt < y3 then
		ytt := y3;
	zt := 1 - ((ytt+240)*(ytt+240))/((y_max+240)*(y_max+240));
	if c_type = 0 then
	begin
		if Random <= zt then
			color := color1
		else
			color := color2;
		if ytt + 240 <  ((y_max + 240)/4) then
			color := color1;
		if ytt+240 > (0.98 * (y_max+240)) then
			color := color2;
	end
	else
	begin
		if Random < 0.75 then
			color := color1
		else
			color := color2;
	end;
	Triangle[1].x := x1 + 320;
	Triangle[1].y := 175 - (longint(93*y1) div 128);
	Triangle[2].x := x2 + 320;
	Triangle[2].y := 175 - (longint(93*y2) div 128);
	Triangle[3].x := x3 + 320;
	Triangle[3].y := 175 - (longint(93*y3) div 128);
	SetColor(color);
	SetFillStyle(1,color);
	FillPoly(3,Triangle);
end;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer);

var
	x4,x5,x6,y4,y5,y6: integer;

begin

	x := x2 - x1;
	y := y2 - y1;
	midpoint(x,y);
	x4 := x1 + Round(xz);
	y4 := y1 + Round(yz);
	x := x1 - x3;
	y := y1 - y3;
	midpoint(x,y);
	x6 := x3 + Round(xz);
	y6 := y3 + Round(yz);
	x := x3 - x2;
	y := y3 - y2;
	midpoint(x,y);
	x5 := x2 + Round(xz);
	y5 := y2 + Round(yz);
	if level = 0 then
	begin
		plot_triangle(x1,y1,x6,y6,x4,y4,color1,color2);
		plot_triangle(x2,y2,x4,y4,x5,y5,color1,color2);
		plot_triangle(x3,y3,x5,y5,x6,y6,color1,color2);
		plot_triangle(x4,y4,x5,y5,x6,y6,color1,color2);
	end
	else
		node(x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,color1,
				color2);
end;

procedure gen_quad (x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;level: integer;
	color1: integer; color2: integer);
begin
	generate(x1,y1,x2,y2,x3,y3,level,color1,color2);
	generate(x1,y1,x4,y4,x3,y3,level,color1,color2);
end;


begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	for i:=0 to 15 do
		setEGApalette(i,color_set[i]);
	x_center := -100;
	y_center := 0;
	radius := 150;
	for i:=0 to 2000 do
	begin
		row := Random(349);
		col := Random(639);
		PutPixel(col,row,15);
	end;
	SetFillStyle(1,1);
	SetColor(1);
	FillEllipse(220,175,152,106);
	y_max := 280;
	c_type := 1;
	for i:=0 to 32 do
		gen_quad(xa[i]+x_center,ya[i]+y_center,xb[i]+x_center,
			yb[i]+y_center,xc[i]+x_center,yc[i]+y_center,xd[i]+
			x_center,yd[i]+y_center,level1,2,3);
	ranFillOval(-100,0,154,0,1.0);
	c_type := 0;
	y_max := -80;
	generate(-470,-300,-250,-100,300,-300,4,14,6);
	generate(-350,-280,-60,-120,300,-300,4,14,6);
	generate(-220,-280,80,-110,340,-300,4,14,6);
	generate(-200,-280,230,-100,580,-300,4,14,6);
	SetFillStyle(1,6);
	SetColor(6);
	FillEllipse(140,320,20,7);
	FillEllipse(290,310,20,7);
	FillEllipse(360,334,48,10);
	FillEllipse(420,300,12,4);
	FillEllipse(520,313,22,9);
	FillEllipse(100,270,16,5);
	FillEllipse(600,284,16,5);
	file_no := save_screen(0,0,639,349,file_name);
	ch1 := ReadKey;
end.
