program polya;

uses CRT,Graph,Fractal;

var
	sign1,graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	Xpoints, Ypoints: array[0..24] of real;
	initiator_x1,initiator_x2,initiator_y1,initiator_y2: array[0..9]
		of real;
	ch: char;
	sign: array[0..16] of integer;

procedure generate (X1: real; Y1: real; X2: real; Y2: real;
	level: integer);
	var
		j,k: integer;
		a, b: real;
		Xpoints, Ypoints: array[0..24] of real;

	begin
		turtle_r := (sqrt((X2 - X1)*(X2 - X1) + (Y2 - Y1)*(Y2 - Y1)))/1.41421;
		Xpoints[0] := X1;
		Ypoints[0] := Y1;
		Xpoints[2] := X2;
		Ypoints[2] := Y2;
		turtle_theta := point(X1,Y1,X2,Y2);
		turtle_x := X1;
		turtle_y := Y1;
		turn(sign[level]*45);
		step;
		Xpoints[1] := turtle_x;
		Ypoints[1] := turtle_y;
		dec(level);
		if level > 0 then
		begin
			for j:=0 to generator_size - 2 do
			begin
				X1 := Xpoints[j];
          		X2 := Xpoints[j+1];
          		Y1 := Ypoints[j];
          		Y2 := Ypoints[j+1];
				generate (X1,Y1,X2,Y2,level);
				sign[level] := -sign[level];
			end;
		end
		else
		begin
			for k:=0 to generator_size - 2 do
				Line(Round(Xpoints[k]+320),Round(175 - Ypoints[k]*0.729)
				,Round(Xpoints[k+1]+320),Round(175 - Ypoints[k+1]*
				0.729));
		end;
	end;

begin

	sign1 := 1;
	generator_size := 3;
	init_size := 2;
	initiator_x1[0] := -150;
	initiator_x2[0] := 150;
	initiator_y1[0] := -75;
	initiator_y2[0] := -75;
	write('Enter level (1 - 16): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
     	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	for i:=level downto 0  do
	begin
		sign[i] := sign1;
		sign1 := -sign1;
	end;
	for i:=0 to init_size - 2 do
	begin
		generate(initiator_x1[i], initiator_y1[i], initiator_x2[i],
			initiator_y2[i], level);
	end;
	ch := ReadKey;
end.
