program sandia;

uses Graph,CRT,Fractal;

const
	color_set: array[0..15] of integer =(0,1,2,3,8,49,33,40,24,40,0,49,60,
		61,62,63);
	color_value: integer = 2;
	file_name: array[0..11] of char = 'sandia00.pcx';

var
	Triangle: array[1..3] of PointType;
	GraphDriver,GraphMode,interim,i,j,row,col: integer;
	y_max,x,y,xz,yz,xp,yp: real;
	ch1: char;
	file_no: string[3];

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer); forward;

procedure ranFillOval(x: integer; y:integer; b: integer; color: integer;
	aspect: real);

var
	col,row,dummy,mask,end_x,end_y,kx,radius: integer;
	a,aspect_square: real;
	a_square,b_square,b_test,offset: longint;

begin

	a := b/aspect;
	a_square := Round(a*a);
	radius := b;
	b := (93*b) div 128;
	b_square := b*b;
	x := x + 320;
	y := 175 - (93*y) div 128;
	end_x := x + Round(a);
	end_y := y + Round(b);
	for col:=x - Round(a) to end_x do
	begin
		b_test := b_square - (b_square*(col-x)*(col-x)) div a_square;
		mask := $80 shr (col mod 8);
		Port[$3CE] := 8;
		Port[$3CF] := mask;
		Port[$3C4] := 2;
		Port[$3C5] := $0F;
		for row:=y-b to end_y do
		begin
			kx := Random(25205 div radius);
			if ((row-y)*(row-y) <= b_test) and (kx < (col-x+20)) then
			begin
				offset := row*80 + (col div 8);
				dummy := byte(Mem[$A000:offset]);
				Mem[$A000:offset] := 0;
				Port[$3C4] := 2;
				Port[$3C5] := color;
				Mem[$A000:offset] := $FF;
				Port[$3C4] := 2;
				Port[$3C5] := $0F;
			end;
		end;
	end;
	Port[$3CE] := 3;
	Port[$3CF] := 0;
	Port[$3CE] := 8;
	Port[$3CF] := $FF;
end;

procedure midpoint(x: real; y: real);

var
	r,w: real;
	seed: longint;

begin
	seed := Round(350*y + x);
	RandSeed := seed;
	r := 0.33333 + Random/3.0;
	w := 0.015 + Random/50.0;
	if Random < 0.5 then
		w := -w;
	xz := r*x - (w+0.05)*y;
	yz := r*y + (w +0.05)*x;
end;

procedure node(x1: integer; y1: integer; x2: integer; y2:integer;
	x3: integer; y3: integer; x4: integer; y4: integer; x5: integer;
	y5: integer; x6: integer; y6: integer; level: integer;
	color1: integer; color2: integer);

var
	x_ret1, y_ret1, x_ret2, y_ret2, x_ret3, y_ret3: integer;

begin
	if level <> 0 then
	begin
		generate (x1,y1,x6,y6,x4,y4,level-1,color1,color2);
		generate (x2,y2,x4,y4,x5,y5,level-1,color1,color2);
		generate (x3,y3,x5,y5,x6,y6,level-1,color1,color2);
		generate (x4,y4,x5,y5,x6,y6,level-1,color1,color2);
	end;
end;

procedure plot_triangle(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; color1: integer; color2: integer);

var
	color,temp: integer;
	zt,ytt: real;

begin
	if y1 > y2 then
		ytt := y1
	else
		ytt := y2;
	if ytt < y3 then
		ytt := y3;
	zt := 1 - ((ytt+240)*(ytt+240))/((y_max+240)*(y_max+240));
	if Random <= zt then
		color := color1
	else
		color := color2;
	if ytt + 240 <  ((y_max + 240)/4) then
		color := color1;
	if ytt+240 > (0.98 * (y_max+240)) then
		color := color2;
	Triangle[1].x := x1 + 320;
	Triangle[1].y := 175 - (longint(93*y1) div 128);
	Triangle[2].x := x2 + 320;
	Triangle[2].y := 175 - (longint(93*y2) div 128);
	Triangle[3].x := x3 + 320;
	Triangle[3].y := 175 - (longint(93*y3) div 128);
	SetColor(color);
	SetFillStyle(1,color);
	FillPoly(3,Triangle);
end;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer);

var
	x4,x5,x6,y4,y5,y6: integer;

begin

	x := x2 - x1;
	y := y2 - y1;
	midpoint(x,y);
	x4 := x1 + Round(xz);
	y4 := y1 + Round(yz);
	x := x1 - x3;
	y := y1 - y3;
	midpoint(x,y);
	x6 := x3 + Round(xz);
	y6 := y3 + Round(yz);
	x := x3 - x2;
	y := y3 - y2;
	midpoint(x,y);
	x5 := x2 + Round(xz);
	y5 := y2 + Round(yz);
	if level = 0 then
	begin
		plot_triangle(x1,y1,x6,y6,x4,y4,color1,color2);
		plot_triangle(x2,y2,x4,y4,x5,y5,color1,color2);
		plot_triangle(x3,y3,x5,y5,x6,y6,color1,color2);
		plot_triangle(x4,y4,x5,y5,x6,y6,color1,color2);
	end
	else
		node(x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,color1,
				color2);
end;

procedure gen_quad (x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;level: integer;
	color1: integer; color2: integer);
begin
	generate(x1,y1,x2,y2,x3,y3,level,color1,color2);
	generate(x1,y1,x4,y4,x3,y3,level,color1,color2);
end;


begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	for i:=0 to 15 do
		setEGApalette(i,color_set[i]);
	for i:=0 to 750 do
	begin
		row := Random(349);
		col := Random(639);
		PutPixel(col,row,15);
	end;
	SetFillStyle(1,14);
	SetColor(14);
	FillEllipse(220,90,80,56);
	ranFillOval(-100,117,80,0,1.0);
	y_max := 160;
	generate(-480,0,-260,140,0,-60,6,5,9);
	gen_quad (-980,-200,40,110,210,120,420,-120,6, 4,8);
	y_max := 180;
	generate(-100,-260,280,110,500,-180,5,7,11);
	Triangle[1].x := 0;
	Triangle[1].y := 365;
	Triangle[2].x := 0;
	Triangle[2].y := 220;
	Triangle[3].x := 639;
	Triangle[3].y := 220;
	SetColor(0);
	SetFillStyle(1,0);
	FillPoly(3,Triangle);
	Triangle[1].x := 639;
	Triangle[1].y := 220;
	Triangle[2].x := 639;
	Triangle[2].y := 365;
	Triangle[3].x := 0;
	Triangle[3].y := 365;
	FillPoly(3,Triangle);
	y_max := -100;
	SetColor(14);
	SetLineStyle(4,$0101,1);
	Line(320,220,320,349);
	Line(360,220,440,349);
	Line(400,220,560,349);
	Line(440,220,639,335);
	Line(480,220,639,290);
	Line(520,220,639,262);
	Line(290,220,230,349);
	Line(260,220,140,349);
	Line(230,220,50,349);
	Line(200,220,0,335);
	Line(170,220,0,305);
	Line(140,220,0,277);
	Line(0,255,639,255);
	Line(0,285,639,284);
	SetLineStyle(4,$0003,3);
	Line(0,316,639,313);
	Line(0,342,639,342);
	for i:=0 to 500 do
	begin
		row := random(80) + 220;
		col := random(640);
		PutPixel(col,row,14);
	end;
	for i:=0 to 75 do
	begin
		row := random(20) + 329;
		col := random(640);
		PutPixel(col,row,14);
		PutPixel(col,row,14);
		PutPixel(col-1,row,14);
		PutPixel(col+1,row,14);
		PutPixel(col,row-1,14);
		PutPixel(col,row+1,14);
	end;
	for i:=0 to 100 do
	begin
		row := random(100) + 249;
		col := random(640);
		PutPixel(col,row,14);
		PutPixel(col,row,14);
		PutPixel(col-1,row,14);
		PutPixel(col+1,row,14);
		PutPixel(col,row-1,14);
		PutPixel(col,row+1,14);
	end;
	file_no := save_screen(0,0,639,349,file_name);
	ch1 := ReadKey;
end.

