program san_marcos_dragon;

uses CRT,Graph,Fractal;

const
	maxcol: integer = 639;
	maxrow: integer = 349;
	max_size: real = 4;
	file_string: array[0..3] of string[7] = (('drgset'),('dragon'),
		('dragon'),('drgpal'));
	file2: string[5] = '.pcx';
	file3: string[5] = '.pal';
	file_name2: string[20] = 'dragon00.pcx';
	rect: array[1..4] of PointType = ((x: 0; y: 0),
							    (x: 639; y: 0),
							    (x: 639; y: 349),
							    (x: 0; y: 349));

var
	graphDriver,GraphMode,i,j,key,generator_size,level,init_size,
		file_no,color,row,col,error,start_col,end_mask,
		m,max_iterations,color_option: integer;
	temp_sq, temp_xy, Ytemp,deltaX,deltaY,X,Y,Xsquare,Ysquare,P,Q: real;
	ch1: char;
	colors: array[0..14,0..2] of integer;
	file1: string[3];
	file_name: string[12];
	f: file of byte;
	f_pal: file of integer;

begin
        GraphDriver := 4;
        GraphMode := EGAHi;
        InitGraph(GraphDriver,GraphMode,'');
        max_iterations := 64;
        start_col := 0;
        XMax := 1.2;
        XMin := -0.3;
        YMax := 0.6;
        YMin := -0.6;
        P := 2.998122;
        Q := 0.004298;
        SetFillStyle(1,7);
        FillPoly(4,rect);
	deltaX := (XMax - XMin)/(maxcol);
	deltaY := (YMax - YMin)/(maxrow);
        setEGApalette(0,57);
        setEGApalette(6,46);
        setEGApalette(8,43);
	for col:=start_col to maxcol do
       	begin
	        if KeyPressed then
		   begin
                   		Pval := P;
                                Qval := Q;
                                file1 := save_screen(0,0,col,349,file_name2);
                                gotoxy(1,24);
                                file_name := ConCat(file_string[2],file1,file2);
                                write('File name is: ',file_name);
                                if color_option = 0 then
                                begin
                                     file_name := ConCat(file_string[3],file1,file3);
                                     Assign(f_pal,file_name);
			             Rewrite(f_pal);
			             for i:= 0 to 14 do
				         for j:= 0 to 2 do
					     write(f_pal,colors[i,j]);
                                        write(f_pal,max_iterations);
					write(f_pal,end_mask);
					Close(f_pal);
                       		end;
                                exit;
                   end;
                   for row:=0 to maxrow do
                   begin
                        X := XMin + col * deltaX;
                        Y := YMax - row * deltaY;
                        Xsquare := 0;
                        Ysquare := 0;
                        color := 0;
                        while (color<max_iterations) and
			      ((Xsquare + Ysquare) < max_size) do
                        begin
			     Xsquare := X*X;
                             Ysquare := Y*Y;
                              temp_sq := Ysquare - Xsquare;
                             temp_xy := X*Y;
                             temp_xy := temp_xy + temp_xy;
                             Ytemp := Q*(temp_sq + X)-P*(temp_xy - Y);
                             X := P*(temp_sq + X) + Q*(temp_xy - Y);
                             Y := Ytemp;
                             inc(color);
                        end;
                        if color >= max_iterations then
                           color := (Round((Xsquare + Ysquare)*100)
                                 mod 6) + 1
                        else
                        color := 0;
                        if row < 175 then
                           color := color + 8;
                        PutPixel(col,row,color);
                end;
        end;
        Pval := P;
        Qval := Q;
        file1 := save_screen(0,0,639,349,file_name2);
        gotoxy(1,24);
        file_name := ConCat(file_string[2],file1,file2);
        write('File name is: ',file_name);
        ch1 := ReadKey;
        CloseGraph;
end.
