program sedona;

uses Graph,CRT,Fractal;

const
	color_set: array[0..15] of integer =(43,1,2,3,4,49,28,40,24,40,18,49,46,
		61,62,63);
	color_value: integer = 2;
	file_name: array[0..11] of char = 'sedona00.pcx';

var
	Triangle: array[1..3] of PointType;
	GraphDriver,GraphMode,interim,i,j,row,col: integer;
	y_max,x,y,xz,yz,xp,yp: real;
	ch1: char;
	file_no: string[3];

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer); forward;

procedure midpoint(x: real; y: real);

var
	r,w: real;
	seed: longint;

begin
	seed := Round(350*y + x);
	RandSeed := seed;
	r := 0.33333 + Random/3.0;
	w := 0.015 + Random/50.0;
	if Random < 0.5 then
		w := -w;
	xz := r*x - (w+0.05)*y;
	yz := r*y + (w +0.05)*x;
end;

procedure node(x1: integer; y1: integer; x2: integer; y2:integer;
	x3: integer; y3: integer; x4: integer; y4: integer; x5: integer;
	y5: integer; x6: integer; y6: integer; level: integer;
	color1: integer; color2: integer);

var
	x_ret1, y_ret1, x_ret2, y_ret2, x_ret3, y_ret3: integer;

begin
	if level <> 0 then
	begin
		generate (x1,y1,x6,y6,x4,y4,level-1,color1,color2);
		generate (x2,y2,x4,y4,x5,y5,level-1,color1,color2);
		generate (x3,y3,x5,y5,x6,y6,level-1,color1,color2);
		generate (x4,y4,x5,y5,x6,y6,level-1,color1,color2);
	end;
end;

procedure plot_triangle(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; color1: integer; color2: integer);

var
	color,temp: integer;
	zt,ytt: real;

begin
	if y1 > y2 then
		ytt := y1
	else
		ytt := y2;
	if ytt < y3 then
		ytt := y3;
	zt := 1 - ((ytt+240)*(ytt+240))/((y_max+240)*(y_max+240));
	if Random <= zt then
		color := color1
	else
		color := color2;
	if ytt + 240 <  ((y_max + 240)/4) then
		color := color1;
	if ytt+240 > (0.98 * (y_max+240)) then
		color := color2;
	Triangle[1].x := x1 + 320;
	Triangle[1].y := 175 - (longint(93*y1) div 128);
	Triangle[2].x := x2 + 320;
	Triangle[2].y := 175 - (longint(93*y2) div 128);
	Triangle[3].x := x3 + 320;
	Triangle[3].y := 175 - (longint(93*y3) div 128);
	SetColor(color);
	SetFillStyle(1,color);
	FillPoly(3,Triangle);
end;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer;level: integer; color1: integer;
	color2: integer);

var
	x4,x5,x6,y4,y5,y6: integer;

begin

	x := x2 - x1;
	y := y2 - y1;
	midpoint(x,y);
	x4 := x1 + Round(xz);
	y4 := y1 + Round(yz);
	x := x1 - x3;
	y := y1 - y3;
	midpoint(x,y);
	x6 := x3 + Round(xz);
	y6 := y3 + Round(yz);
	x := x3 - x2;
	y := y3 - y2;
	midpoint(x,y);
	x5 := x2 + Round(xz);
	y5 := y2 + Round(yz);
	if level = 0 then
	begin
		plot_triangle(x1,y1,x6,y6,x4,y4,color1,color2);
		plot_triangle(x2,y2,x4,y4,x5,y5,color1,color2);
		plot_triangle(x3,y3,x5,y5,x6,y6,color1,color2);
		plot_triangle(x4,y4,x5,y5,x6,y6,color1,color2);
	end
	else
		node(x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,color1,
				color2);
end;

procedure gen_quad (x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;level: integer;
	color1: integer; color2: integer);
begin
	generate(x1,y1,x2,y2,x3,y3,level,color1,color2);
	generate(x1,y1,x4,y4,x3,y3,level,color1,color2);
end;

procedure cactus (x1: integer; y1: integer; scale: integer; level: integer;
	color1: integer; color2: integer);

begin
	gen_quad(x1,y1,x1,y1+21*scale,x1+Round(1.6*scale),y1+22*scale,x1+
		Round(1.6*scale),y1,level,color1,color2);
	gen_quad(x1+Round(1.4*scale),y1,x1+Round(1.4*scale),y1+22*scale,x1+3*scale,
		y1+21*scale,x1+3*scale,y1,level,color1,color2);
	gen_quad(x1,y1+9*scale,x1+7*scale,y1+9*scale,x1+7*scale,y1+12*scale,
		x1,y1+12*scale,0,color1,color2);
	gen_quad(x1,y1+9*scale,x1+6*scale,y1+9*scale,x1+7*scale,y1+12*scale,
		x1,y1+12*scale,level,color1,color2);
	gen_quad(x1+7*scale,y1+9*scale,x1+7*scale,y1+16*scale,
		x1+Round(8.5*scale),y1+17*scale,x1+Round(8.5*scale),y1+9*scale,
		level,color1,color2);
	gen_quad(x1+Round(8.4*scale),y1+9*scale,x1+Round(8.4*scale),y1+16*scale,
		x1+10*scale,y1+17*scale,x1+10*scale,y1+10*scale,
		level,color1,color2);
	gen_quad(x1,y1+7*scale,x1-6*scale,y1+7*scale,x1-6*scale,y1+10*scale,
		x1,y1+10*scale,0,color1,color2);
	gen_quad(x1,y1+7*scale,x1-6*scale,y1+7*scale,x1-6*scale,y1+10*scale,
		x1,y1+10*scale,level,color1,color2);
	gen_quad(x1-7*scale,y1+8*scale,x1-7*scale,y1+12*scale,x1-Round(5.4*scale),
		y1+13*scale,x1-Round(5.4*scale),y1+7*scale,level,color1,color2);
	gen_quad(x1-Round(5.6*scale),y1+7*scale,x1-Round(5.6*scale),y1+13*scale,x1-4*scale,
		y1+12*scale,x1-4*scale,y1+7*scale,level,color1,color2);
end;

begin
	DirectVideo := false;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	for i:=0 to 15 do
		setEGApalette(i,color_set[i]);
	y_max := 280;
	gen_quad (-330,-150,-160,0,0,0,120,-130,4,4,12);
	gen_quad (-90,-110,85,50,200,50,440,-180,4,4,12);
	gen_quad (-160,-10,-160,220,-120,220,-120,-10,4,4,12);
	gen_quad (-120,-10,-120,190,-80,200,-80,-10,4,4,12);
	gen_quad (-80,-15,-80,230,-50,235,-50,-15,4,4,12);
	gen_quad (-50,-10,-50,100,0,180,0,-10,4,4,12);
	gen_quad (80,45,100,180,104,200,104,45,4,4,12);
	gen_quad (100,45,100,200,128,210,128,45,4,4,12);
	gen_quad (125,50,125,215,152,220,152,50,4,4,12);
	gen_quad (150,50,150,160,200,140,200,50,4,4,12);
	y_max := -100;
	gen_quad (-330,-300,-330,-110,330,-100,330,-300,4,6,14);
	y_max := 0;
	cactus(-110,-130,3,4,2,10);
	cactus(-200,-120,2,4,2,10);
	cactus(0,-160,4,4,2,10);
	cactus(210,-200,6,4,2,10);
	file_no := save_screen(0,0,640,350,file_name);
	ch1 := ReadKey;
end.


