program sierbox;

uses CRT,Graph,Fractal;

const
	Square: array[1..4] of PointType =   ((x: 50;   y: 100),
								   (x: 100;  y: 100),
								   (x: 100;  y: 100),
								   (x: 150;  y: 150));

var
	graphDriver,GraphMode,i,level,L_length,x1,y1,x2,y2,x3,y3: integer;
	ch: char;

procedure node(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;
	level: integer; l_length: integer); forward;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	level: integer; l_length: integer);

var
	line_length,x3,y3,x4,y4: integer;

begin
	line_length := l_length div 3;
	x3 := x1 + line_length;
	y3 := y1 - (35*line_length) div 48;
	x4 := x2 - line_length;
	y4 := y2 + (35*line_length) div 48;
	node (x1,y1,x2,y2,x3,y3,x4,y4,level,line_length);
end;

procedure node(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;
	level: integer; l_length: integer);

begin
	Square[1].x := x3;
	Square[1].y := y3;
	Square[2].x := x4;
	Square[2].y := y3;
	Square[3].x := x4;
	Square[3].y := y4;
	Square[4].x := x3;
	Square[4].y := y4;
	FillPoly(4,Square);
	if level <> 0 then
	begin
		generate (x1,y1,x3,y3,level-1,l_length);
		generate (x3,y1,x4,y3,level-1,l_length);
		generate (x4,y1,x2,y3,level-1,l_length);
		generate (x1,y3,x3,y4,level-1,l_length);
		generate (x4,y3,x2,y4,level-1,l_length);
		generate (x1,y4,x3,y2,level-1,l_length);
		generate (x3,y4,x4,y2,level-1,l_length);
		generate (x4,y4,x2,y2,level-1,l_length);
	end;
end;

begin
	write('Enter level (1 - 3): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	x1 := 100;
	y1 := 335;
	x2 := 540;
	y2 := 15;
	l_length := 440;
	SetFillStyle(1,15);
	Square[1].x := x1;
	Square[1].y := y1;
	Square[2].x := x2;
	Square[2].y := y1;
	Square[3].x := x2;
	Square[3].y := y2;
	Square[4].x := x1;
	Square[4].y := y2;
	FillPoly(4,Square);
	SetFillStyle(1,0);
	SetColor(0);
	generate(x1,y1,x2,y2,level,l_length);
	ch := ReadKey;
end.

