program siergask;

uses CRT,Graph,Fractal;


var

	Triangle: array[1..3] of PointType;
	graphDriver,GraphMode,i,level,L_length,x1,y1,x2,y2,x3,y3: integer;
	ch: char;

procedure node(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;
	x5: integer; y5: integer; x6: integer; y6: integer;
	level: integer; l_length: integer); forward;

procedure generate(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; level: integer; l_length: integer);

var
	line_length,x4,y4,x5,y5,x6,y6: integer;

begin
	line_length := l_length div 2;
	x4 := x1 + line_length;
	y4 := y1;
	x5 := x1 + line_length div 2;
	y5 := y1 - Round((line_length/2)*1.26292);
	x6 := x5 + line_length;
	y6 := y5;
	node (x1,y1,x2,y2,x3,y3,x4,y4,x5,y5,x6,y6,level,line_length);
end;

procedure node(x1: integer; y1: integer; x2: integer; y2: integer;
	x3: integer; y3: integer; x4: integer; y4: integer;
	x5: integer; y5: integer; x6: integer; y6: integer;
	level: integer; l_length: integer);

begin
	Triangle[1].x := x4;
	Triangle[1].y := y4;
	Triangle[2].x := x5;
	Triangle[2].y := y5;
	Triangle[3].x := x6;
	Triangle[3].y := y6;
	FillPoly(3,Triangle);
	if level <> 0 then
	begin
		generate (x1,y1,x4,y4,x5,y5,level-1,l_length);
		generate (x4,y4,x2,y2,x6,y6,level-1,l_length);
		generate (x5,y5,x6,y6,x3,y3,level-1,l_length);
	end;
end;

begin
	write('Enter level (1 - 5): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	x1 := 64;
	y1 := 335;
	x2 := 576;
	y2 := 335;
	x3 := 320;
	y3 := 15;
	l_length := 512;
	SetFillStyle(1,15);
	Triangle[1].x := x1;
	Triangle[1].y := y1;
	Triangle[2].x := x2;
	Triangle[2].y := y2;
	Triangle[3].x := x3;
	Triangle[3].y := y3;
	FillPoly(3,Triangle);
	SetFillStyle(1,0);
	SetColor(0);
	generate(x1,y1,x2,y2,x3,y3,level,l_length);
	ch := ReadKey;
end.

