program sierp;

uses CRT,Graph,Fractal;

var
	graphDriver,GraphMode,i,generator_size,level: integer;
	Xpoints, Ypoints: array[0..24] of real;
	ch: char;


procedure generate (X1: real; Y1: real; X2: real; Y2: real;
	level: integer; sign: integer);
	var
		j,k,int_sign: integer;
		Xpoints, Ypoints: array[0..24] of real;

	begin
		turtle_r := sqrt((X2 - X1)*(X2 - X1) + (Y2 - Y1)*(Y2 - Y1))/2.0;
		turtle_x := X1;
		turtle_y := Y1;
		Xpoints[0] := X1;
		Ypoints[0] := Y1;
		Xpoints[3] := X2;
		Ypoints[3] := Y2;
		turtle_theta := point(X1,Y1,X2,Y2);
		turn(60*sign);
		step;
		Xpoints[1] := turtle_x;
		Ypoints[1] := turtle_y;
		turn(-60*sign);
		step;
		Xpoints[2] := turtle_x;
		Ypoints[2] := turtle_y;
		dec(level);
		sign := -sign;
		if level = 0 then
		begin
			for k:=0 to generator_size - 1 do
			begin
				Line(Round(Xpoints[k]+320),Round(175 - Ypoints[k]*0.729)
					,Round(Xpoints[k+1]+320),Round(175 - Ypoints[k+1]*
					0.729));
			end;
		end
		else
		begin
			int_sign := sign;
			for j:=0 to generator_size-1 do
			begin
				X1 := Xpoints[j];
				X2 := Xpoints[j+1];
				Y1 := Ypoints[j];
				Y2 := Ypoints[j+1];
				generate (X1,Y1,X2,Y2,level,int_sign);
				int_sign := -int_sign;
			end;
		end;
	end;

begin
	generator_size := 3;
	write('Enter level (1 - 8): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	generate(-130,0,130,0, level, 1);
	ch := ReadKey;
end.
