program snowhall;

uses CRT,Graph,Fractal;

var
	graphDriver,GraphMode,i,generator_size,level,init_size: integer;
	set_type: integer;
	sign: real;
	Xpoints, Ypoints: array[0..24] of real;
	initiator_x1,initiator_x2,initiator_y1,initiator_y2: array[0..9]
		of real;
	ch: char;

procedure generate (X1: real; Y1: real; X2: real; Y2: real;
	level: integer; gen_type: integer; sign: real);
	var
		j,k,set_type: integer;
		a,b,temp: real;
		Xpoints, Ypoints: array[0..24] of real;

	begin
		case gen_type of
			1: sign := -sign;
			2: begin
				sign := -sign;
				temp := X1;
				X1 := X2;
				X2 := temp;
				temp := Y1;
				Y1 := Y2;
				Y2 := temp;
			   end;
			3: begin
				temp := X1;
				X1 := X2;
				X2 := temp;
				temp := Y1;
				Y1 := Y2;
				Y2 := temp;
				end;
		end;
		dec(level);
		turtle_r := (sqrt((X2 - X1)*(X2 - X1) + (Y2 - Y1)*(Y2 - Y1)))/3.0;
		Xpoints[0] := X1;
		Ypoints[0] := Y1;
		Xpoints[11] := X2;
		Ypoints[11] := Y2;
		turtle_theta := point(X1,Y1,X2,Y2);
		turn(60*sign);
		turtle_x := X1;
		turtle_y := Y1;
		step;
		Xpoints[1] := turtle_x;
		Ypoints[1] := turtle_y;
		step;
		Xpoints[2] := turtle_x;
		Ypoints[2] := turtle_y;
		turn(-60*sign);
		step;
		Xpoints[3] := turtle_x;
		Ypoints[3] := turtle_y;
		turn(-60*sign);
		step;
		Xpoints[4] := turtle_x;
		Ypoints[4] := turtle_y;
		turn(-120*sign);
		step;
		turn(60*sign);
		step;
		Xpoints[9] := turtle_x;
		Ypoints[9] := turtle_y;
		turn(120*sign);
		step;
		Xpoints[10] := turtle_x;
		Ypoints[10] := turtle_y;
		turtle_r := (sqrt((Xpoints[9] - Xpoints[4])*(Xpoints[9] -
			Xpoints[4]) + (Ypoints[9] - Ypoints[4])*(Ypoints[9] -
			Ypoints[4])))/3.0;
		turtle_theta := point(Xpoints[4],Ypoints[4],Xpoints[9],Ypoints[9]);
		turn(-60*sign);
		turtle_x := Xpoints[4];
		turtle_y := Ypoints[4];
		step;
		Xpoints[5] := turtle_x;
		Ypoints[5] := turtle_y;
		step;
		Xpoints[6] := turtle_x;
		Ypoints[6] := turtle_y;
		turn(60*sign);
		step;
		Xpoints[7] := turtle_x;
		Ypoints[7] := turtle_y;
		turn(60*sign);
		step;
		Xpoints[8] := turtle_x;
		Ypoints[8] := turtle_y;
		if level = 0 then
		begin
			for k:=0 to generator_size - 1 do
			begin
				Line(Round(Xpoints[k]+320),Round(175 - Ypoints[k]*0.729)
					,Round(Xpoints[k+1]+320),Round(175 - Ypoints[k+1]*
					0.729));
			end;
		end
		else
		begin
			for j:=0 to generator_size - 1 do
			begin
				if level = 1 then
					begin
						case j of
							2,8,10: set_type := 0;
							0,5:    set_type := 1;
							1,3,4:  set_type := 2;
							6,7,9:  set_type := 3;
					    end;
					end;
				if level > 1 then
				begin
					case j of
						2,8,10: set_type := 0;
						0:      set_type := 1;
						1,3,4:  set_type := 2;
						5,6,7,9:  set_type := 3;
				    end;
				end;
				X1 := Xpoints[j];
				X2 := Xpoints[j+1];
				Y1 := Ypoints[j];
				Y2 := Ypoints[j+1];
				generate (X1,Y1,X2,Y2,level,set_type,sign);
			end;
		end;
	end;

begin
	sign := 1;
	set_type := 0;
	generator_size := 11;
	init_size := 1;
	initiator_x1[0] := -150;
	initiator_x2[0] := 150;
	initiator_y1[0] := -75;
	initiator_y2[0] := -75;
	write('Enter level (1 - 8): ');
	readln(level);
	if level < 1 then
		level := 1;
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	SetLineStyle(0,$FFFF,1);
	SetColor(15);
	for i:=0 to init_size - 1 do
	begin
		generate(initiator_x1[i], initiator_y1[i], initiator_x2[i],
			initiator_y2[i], level,set_type,sign);
	end;
	ch := ReadKey;
end.
