program trees;

uses CRT, Graph,Fractal;

const
	ln_2: real = (0.6931471);
	Square: array[1..4] of PointType =   ((x: 50;   y: 100),
								   (x: 100;  y: 100),
								   (x: 100;  y: 100),
								   (x: 150;  y: 150));

var

	GraphDriver,GraphMode,i,j,level,width: integer;
	height,left_alpha,right_alpha,left_angle,right_angle,
	left_width_factor,left_height_factor,right_width_factor,
	right_height_factor,x,y,x1,y1,x2,y2: real;
	ch: char;

procedure generate(x: real; y: real; width: integer; height: real; angle: real;
	level: integer);

var
	x1,y1: real;

	begin
		turtle_x := x;
		turtle_y := y;
		turtle_r := height;
		step;
		x1 := turtle_x;
		y1 := turtle_y;
		dec(level);
		if level < 3 then
		begin
			SetColor(10);
			SetFillStyle(1,10);
		end
		else
		begin
			SetColor(6);
			SetFillStyle(1,6);
		end;
		if Abs(x - x1) > Abs(y - y1) then
		begin
			Square[1].x := Round(x+320);
			Square[1].y := Round(175 - y*0.729) + width div 2;
			Square[2].x := Round(x+320);
			Square[2].y := Round(175 - y*0.729) - width div 2;
			Square[3].x := Round(x1+320);
			Square[3].y := Round(175 - y1*0.729) - width div 2;
			Square[4].x := Round(x1+320);
			Square[4].y := Round(175 - y1*0.729) + width div 2;
		end
		else
		begin
			Square[1].x := Round(x+320) - width div 2;
			Square[1].y := Round(175 - y*0.729);
			Square[2].x := Round(x+320) + width div 2;
			Square[2].y := Round(175 - y*0.729);
			Square[3].x := Round(x1+320) + width div 2;
			Square[3].y := Round(175 - y1*0.729);
			Square[4].x := Round(x1+320) - width div 2;
			Square[4].y := Round(175 - y1*0.729);
		end;
		FillPoly(4,Square);
		if level > 0 then
		begin
			turtle_theta := point(x,y,x1,y1);
			turn(left_angle);
			generate(x1,y1,Round(left_width_factor*width),left_height_factor*
				height,left_angle,level);
			turtle_theta := point(x,y,x1,y1);
			turn(-right_angle);
			generate(x1,y1,Round(right_width_factor*width),right_height_factor*
				height,right_angle,level);
		end;
	end;


begin
	write('Enter stem height: ');
	readln(height);
	write('Enter stem width: ');
	readln(width);
	write('Enter left alpha: ');
	readln(left_alpha);
	write('Enter right alpha: ');
	readln(right_alpha);
	write('Enter left branch angle: ');
	readln(left_angle);
	write('Enter right branch angle: ');
	readln(right_angle);
	write('Enter recursion level: ');
	readln(level);
	GraphDriver := 4;
	GraphMode := EGAHi;
	InitGraph(graphDriver,GraphMode,'');
	left_width_factor := exp((-ln_2/left_alpha));
	left_height_factor := exp((-2*ln_2)/(3*left_alpha));
	right_width_factor := exp((-ln_2/right_alpha));
	right_height_factor := exp((-2*ln_2)/(3*right_alpha));
	x := 0;
	y := -235;
	SetBkColor(9);
	ClearDevice;
	x1 := 0;
	y1 := y + height;
	SetColor(6);
	SetFillStyle(1,6);
	if Abs(x - x1) > Abs(y - y1) then
	begin
		Square[1].x := Round(x+320);
		Square[1].y := Round(175 - y*0.729) + width div 2;
		Square[2].x := Round(x+320);
		Square[2].y := Round(175 - y*0.729) - width div 2;
		Square[3].x := Round(x1+320);
		Square[3].y := Round(175 - y1*0.729) - width div 2;
		Square[4].x := Round(x1+320);
		Square[4].y := Round(175 - y1*0.729) + width div 2;
	end
	else
	begin
		Square[1].x := Round(x+320) - width div 2;
		Square[1].y := Round(175 - y*0.729);
		Square[2].x := Round(x+320) + width div 2;
		Square[2].y := Round(175 - y*0.729);
		Square[3].x := Round(x1+320) + width div 2;
		Square[3].y := Round(175 - y1*0.729);
		Square[4].x := Round(x1+320) - width div 2;
		Square[4].y := Round(175 - y1*0.729);
	end;
	FillPoly(4,Square);
	turtle_theta := point(x,y,x1,y1);
	turn(left_angle);
	generate(x1,y1,Round(left_width_factor*width),left_height_factor*height,
		left_angle,level);
	turtle_theta := point(x,y,x1,y1);
	turn(-right_angle);
	generate(x1,y1,Round(right_width_factor*width),right_height_factor*height,
		right_angle,level);
	ch := ReadKey;
end.
