#include <dos.h>
#include <conio.h>

typedef unsigned char byte;

#define XPixels  320
#define YPixels  200
#define MaxIter  150

#define XMin   -2.3L  //-0.64L
#define XMax    0.9L  //-0.44L
#define YMin   -1.2L  // 0.55L
#define YMax    1.2L  // 0.70L
#define Escape  4.0L

const double DeltaX = (XMax - XMin) / (double)XPixels;
const double DeltaY = (YMax - YMin) / (double)YPixels;


double Xval[XPixels];

int main()
{
  double RowVal,X,Y,Xsq,Ysq,Xv;
  int color,row,col;
  union REGS r;

  //create pointer to beginning of video memory
  byte far * gmem = (byte far*) (0xA0000000L);

  //set video mode to 320X200X256
  r.x.ax=0x0013;
  int86(0x10,&r,&r);

  //precalculate increments along Y-axis
  Xval[0]=XMin;

  for(col=1;col<XPixels;++col)
     Xval[col]=Xval[col-1]+DeltaX;

  RowVal=YMax;

  //calculate and display Mandelbrot set
  for(row=0;row<YPixels;++row)
     {
     for(col=0;col<XPixels;++col)
        {
        X=Y=Xsq=Ysq=0.0L;
        Xv=Xval[col];
        color=0;

        //iterate equation
        while(color<MaxIter)
           {
           //calculate squares
           Xsq=X*X;
           Ysq=Y*Y;

           //if Z > Escape, jump out
           if((Xsq+Ysq)>=Escape)
              break;

           //calculate next Z
           Y*=X;
           Y+=Y+RowVal;
           X=Xsq-Ysq+Xv;

           //increment iteration count
           ++color;
           }

        //plot pixel
        if(color==MaxIter)
           *gmem=0;
        else
           *gmem=(color&15) +1;

        //move to next pixel
        ++gmem;
        }

     RowVal-=DeltaY;
     }

  sound(200);
  delay(250);
  nosound();
  while(!kbhit());

  r.x.ax=0x0003;
  int86(0x10,&r,&r);

  return 0;
}