/*Paldemo : Palette demonstration.

  Creates some nice little effects by fiddling with the palette.
  Please note that it is NOT neccessary to place a WaitVerticalRetrace()
  after every graphics call, as I have done here. The reason for my
  indiscrepancy is that the visual impact is greatly lessened by doing
  things too fast, eg it looks kewl when the 'bars' on the screen
  slowly are fazed in, rather than all appearing instantly as they would
  have if I had removed the WaitVerticalRetrace. In general, use
  WaitVertical Retrace only before several graphics function calls, eg at
  the start of your sprite re-drawing function to reduce flicker.
*/

#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>
#include "13hlib.h"

//Globals
Mode13hLib Mode13h;
ColorStruct ColStr;
int k;
char *a, *b, *c;

//Functions
void rotatepalette();
void SetUpPalette();
void SetUpGrayPalette();
void DrawColors();
void DrawGrays();
void ScreenFade();

void main()
{
 if(Mode13h.DetectVGA() == FAILURE){
		       cprintf("You need a VGA card to run this program.\n\r");
		       exit(1);
		      }
 Mode13h.SetMode13h();
 a = &ColStr.r;
 b = &ColStr.g;
 c = &ColStr.b;
 SetUpPalette();
 SetUpGrayPalette();
 DrawColors();

 for(int j =0; j <= 10; j++)
  {
  delay(20);
  rotatepalette();
  }
 DrawGrays();
 delay(600);
 ScreenFade();
 Mode13h.CloseMode13h();
}

void SetUpPalette()
{
 *b = 0;
 *c = 0;
 Mode13h.WaitVerticalRetrace();
 for(k = 1; k<= 63; k += 2)
  {
  *a = k - 1;
  Mode13h.SetPaletteColor(k, ColStr);
  *a = k;
  Mode13h.SetPaletteColor(k + 1, ColStr);
  }
 *a = 0;
 for(k=0; k<=63; k += 2)
  {
   *b = k;
   Mode13h.SetPaletteColor(k + 63, ColStr);
   *b = k + 2;
   Mode13h.SetPaletteColor(k + 64, ColStr);
  }
 *b = 0;
 for(k=0; k<=63; k += 2)
  {
   *c = k;
   Mode13h.SetPaletteColor(k+126, ColStr);
   *c = k +1;
   Mode13h.SetPaletteColor(k+127, ColStr);
  }
 delay(200);
}

void SetupGrayPalette()
{
 ColorStruct GreyPal;


 for(int k = 1; k<= 55; k++)
  {
   GreyPal.r = k;
   GreyPal.g = k;
   GreyPal.b = k;
   Mode13h.SetPaletteColor(k+200, GreyPal);
  }
}

void rotatepalette()
{
 a = &ColStr.r;
 b = &ColStr.g;
 c = &ColStr.b;
 delay(15);
 SetUpPalette();
 a = &ColStr.b;
 b = &ColStr.r;
 c = &ColStr.g;
 delay(15);
 SetUpPalette();
 a = &ColStr.g;
 b = &ColStr.b;
 c = &ColStr.r;
 delay(15);
 SetUpPalette();
}

void ScreenFade()
{
 for(int j  = 63; j >= 1; j--)
 {
  for(int k = 0; k<= 255; k++)
   {
    Mode13h.GetPaletteColor(k, ColStr);
    if(ColStr.r > 6)
      ColStr.r -= 4;
    else ColStr.r = 0;
    if(ColStr.g > 6)
      ColStr.g -= 4;
    else ColStr.g = 0;
    if(ColStr.b > 6)
      ColStr.b -= 4;
    else ColStr.b = 0;
   Mode13h.SetPaletteColor(k, ColStr);
   }
  Mode13h.WaitVerticalRetrace();
  delay(75);
  }
}

void DrawColors()
{
 Mode13h.WaitVerticalRetrace();

 for(k=1; k<=189; k++)
 {
  delay(20);           //Slow it down  bit
  Mode13h.HorizontalLine(0, k+3, 319, k);
 }

 for(k = 1; k<= 189; k++)
  {
   delay(20);                // Slow it down a bit
   Mode13h.VerticalLine(k + 62, 0, 199, k);
  }

 /*
 NOTE: For the above two loops, I included delays so that the columns appear
 slowly.
 If you leave them out, the lines will apeear instantaneously.
 Try it: Comment out one of them and re-compile.
 */
}

void DrawGrays()
{
 int height = 200, width = 320;

 for(int k = 0; k <= 55; k++)
  {
   delay(50);               // Slow down a bit...
   Mode13h.Rectangle(k, k,  width, height, k+200);
   height-= 2;
   width -= 2;
  }
}

