/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 36                         
                                                                              
 This program shows how the wxorbox routine works.                           
                                                                              
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 None                                                                        
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>

short oldmode;
short ox, oy;  /* old mouse coordinates */
short i;


void main(void)
{

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  printf ("WGT Example #36\n\n");
  printf ("Draws a bar using WXORBOX to highlight regions. Click the mouse button\n");
  printf ("to advance to the next box type. The second demo uses four commands to simulate\n");
  printf ("a rectangle. Another mouse click ends the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();         /* Gets the current mode */
  vga256 ();                     /* Initialize graphics mode */

  minit ();
  
  for (i = 0; i < 200; i++) /* Draw a background */
   {
    wsetcolor (i);
    wline (0, i, 319, i);
   }

  do {  /* Draws a filled xorbox using mouse coordinates as one corner. */
   ox = mouse.mx;
   oy = mouse.my;
   wxorbox (50, 50, ox, oy, 128);    /* Draw the box */
   while ((mouse.mx == ox) && (mouse.my == oy) && (!mouse.but))
      wretrace ();
   /* Do nothing while mouse is stationary. */
   wxorbox (50, 50, ox, oy, 128);             
    /* Erase the box by drawing the same thing */
  } while (mouse.but == 0);

  noclick ();

  do {  /* Draws a hollow rubber box using mouse coordinates as one corner. */
   ox = mouse.mx;
   oy = mouse.my;
   wxorbox (50, 50, ox, 50, 128);
   wxorbox (ox, 50, ox, oy, 128);    /* Draw the box */
   wxorbox (50, oy, ox, oy, 128);
   wxorbox (50, 50, 50, oy, 128);
   while ((mouse.mx == ox) && (mouse.my == oy) && (!mouse.but))
      wretrace ();
   /* Do nothing while mouse is stationary. */
   wxorbox (50, 50, ox, 50, 128);
   wxorbox (ox, 50, ox, oy, 128);    /* Erase the box */
   wxorbox (50, oy, ox, oy, 128);
   wxorbox (50, 50, 50, oy, 128);
  } while (mouse.but == 0);
  mdeinit ();                   /* Deinitialize the mouse handler */

 wsetmode (oldmode);
}
