/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 52                         
									      
  A full FLI/FLC animation player. Allows filenames with wildcards and a      
  selection of memory or disk playback. Resolution of the animation is
  assumed to be 320x200 max (although you could assign flicscreen to a large
  virtual screen buffer to handle bigger resolutions).
									      
  *** PROJECT ***                                                             
  This program requires the WGT5_WC.LIB and WFLIC_WC.LIB files to be linked.  
									      
  *** DATA FILES ***                                                          
  Any FLI or FLC file (or files).                                             
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <dos.h>
#include <stdlib.h>
#include <wgt5.h>
#include <wgtflic.h>

#define ESC             27              /* ESCAPE KEY */

char         ch;                        /* Keyboard input */
int          playmode;                  /* Memory or disk playback */
int          filefound;                 /* 1 if the animation file was found */
int          oldmode;                   /* Previous video mode */
int          status;                    /* Status of FLI/FLC */
int          flic_mode;

void main (int argc, char *argv[])
{
  unsigned totl;

  if ((argc < 2) || (argc > 3))         /* Display how to use this program */
  {
    printf ("\nWGT52 - Plays FLI and FLC files from either memory or disk\n");
    printf ("USAGE:   WGT52 filename [play_mode]\n");
    printf ("playmode can be:\n");
    printf (" 0 - Play from disk (default)\n");
    printf (" 1 - Play from memory\n");
    printf ("\nPress any key\n");
    getch ();
    exit (1);
  }

  if (argc > 2)
    flic_mode = atoi (argv[2]);         /* Get playmode from command line */
  else flic_mode = FLIC_DISK;           /* Or default to disk */
  
  if (flic_mode > 1)
    flic_mode = FLIC_DISK;


  oldmode = wgetmode ();                /* Preserve initial video mode */
  vga256 ();                            /* Go to graphics mode */
  flicscreen = abuf;                    /* Set to visual screen */
					/* You must set this AFTER vga256(); */
  
  if (openflic (argv[1], flic_mode, 1) == FLIC_OK) /* See if we opened file ok */
    do {
      status = nextframe ();                  /* Show frame of animation */
      if ((status != FLIC_OK) && (status != FLIC_DONE))
	break;                                /* Abort if error */
      delay (flichdr.speed);                  /* Delay proper amount */
    } while (!kbhit ());                      /* Continue until keypress */

  /* NOTE: If you don't want the flic to loop, remove the check for
	   FLIC_DONE. This will abort playback when the animation is done */

  while (kbhit())                             /* Get key from buffer */
    ch = getch ();

  closeflic ();                               /* Close current animation */

  wsetmode (oldmode);                           /* and video mode */
}
