#ifndef _WLINK_
#define _WLINK_

/* 
   WordUp Graphics Toolkit V5.0  Communications Routines
*/

#ifdef __cplusplus
  extern "C" {
#endif


#define WLINK_NOVECTOR 0x67
#define WLINK_8250_UART 0
#define WLINK_16550_UART 1

#define BUFFERSIZE      4096
/* BUFFERSIZE must be a power of 2 */


/* Buffer for input and output */
typedef struct
{
 short head, tail;           // bytes are put on head and pulled from tail
 short size;
 unsigned char data[BUFFERSIZE];
} transferbuffer;

extern transferbuffer buffer_in, buffer_out;


extern short uart_type;
extern short irqintnum;
extern short line_status;

/* Modem variables */
extern short pulsedial;
extern short usemodem;

extern struct {
  char modem_init [257];
  char modem_hangup [257];
  unsigned long baud_rate;
  short com_port;
  short irq_num;
  short uart;
  short uarttype;
  short vector;
 } link_info;



/* Communication Routines */
void wlink_flush_incoming (void);
void wlink_flush_outgoing (void);
void wlink_getuart (void);
void wlink_getvector (void);
void wlink_initport (void);
void wlink_shutdownport (void);
void wlink_write_buffer (char *buffer, unsigned int count);

void wlink_modemcommand (char *str);
void wlink_hangup_modem (void);
int wlink_modemresponse (char *resp);
void wlink_initmodem (void);
int wlink_dial (char *dialstring);
int wlink_answer (void);

#ifdef __cplusplus
}
#endif

#endif
