/*
 * xbm.s - low level bitmap routines
 *
 * DESCRIPTION
 * Routines to draw planar, masked-planar, RLE encoded, and
 * solid tiles to video memory.
 *
 * USAGE
 *
 * NOTES
 * Parts based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 *  4 Aug 95    Modified to use word w and h indices for bitmaps.
 * 30 Aug 95    Cleaned up PBM functions for efficiency
 * 31 Aug 95    Added x_tile32
 *  1 Sep 95    Added x_tile32_clipy
 *
 */

        .data        
BMHeight:
        .long   0
LineInc:
        .long   0
ymin:   .long   0
ymax:   .long   0
Plane:
        .byte   0
        
        .text
        .globl  _x_tile16
        .globl  _x_tile32
        .globl  _x_tile32_clipy
        .globl  _x_put_PBM
        .globl  _x_put_PBM_masked
        .globl  _x_put_RLE
        .globl  _x_tile16_align
        .globl  _ScrnLogicalByteWidth
        .extern _core_select
        
/******************************************************************
** void x_tile16(int x, int y, int PageBase, BYTE * bitmap);
**                  +8    +12       +16           +20
** An experiment to see if a specialized routine would be faster
*******************************************************************/
        .align  4
_x_tile16:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es

        movw    _core_select,%ax        /* We're using post-dpmi extender */
        movw    %ax,%es                 /* Use real area selector */
        
        movl    12(%ebp), %edi
        imul    _ScrnLogicalByteWidth, %edi
        movl    8(%ebp), %ecx
        movl    %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %edi              # I just found out that this is a
        addl    16(%ebp), %edi          # valid comment format too!!  :-)
        addl    $0xa0000, %edi
        
        movl    20(%ebp), %esi          /* bitmap pointer */
        addl    $4, %esi                /* get rid of h and w */

        movw    $0x3c4, %dx
        movb    $02, %al
        outb    %al, %dx
        incw    %dx
        andb    $3, %cl
        movb    $0x11, %al              /* Map mask - loaded to rotate */
        shl     %cl, %al
        movl    %edi, %ebx              /* store start address */
        movl    _ScrnLogicalByteWidth, %ebp
        subl    $4, %ebp 
        movl    $4, Plane
t16loop0:
        outb    %al, %dx
        movl    $0x10, %ecx             /* # of rows */
t16loop1:
        movsl
        addl    %ebp, %edi              /* offset to next row start */
        decl    %ecx
        jnz     t16loop1

        rolb    $1, %al
        adcl    $0, %edi
        movl    %ebx, %edi
        decl    Plane
        jnz     t16loop0

        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret

/******************************************************************
** void x_tile32(int x, int y, int PageBase, BYTE * bitmap);
**                  +8    +12       +16           +20
** More speed experiments
*******************************************************************/
        .align  4
_x_tile32:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es

        movw    _core_select,%ax        /* We're using post-dpmi extender */
        movw    %ax,%es                 /* Use real area selector */
        
        movl    12(%ebp), %edi
        imul    _ScrnLogicalByteWidth, %edi
        movl    8(%ebp), %ecx
        movl    %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %edi              # I just found out that this is a
        addl    16(%ebp), %edi          # valid comment format too!!  :-)
        addl    $0xa0000, %edi
        
        movl    20(%ebp), %esi          /* bitmap pointer */
        addl    $4, %esi                /* get rid of h and w */

        movw    $0x3c4, %dx
        movb    $02, %al
        outb    %al, %dx
        incw    %dx
        andb    $3, %cl
        movb    $0x11, %al              /* Map mask - loaded to rotate */
        shl     %cl, %al
        movl    %edi, %ebx              /* store start address */
        movl    _ScrnLogicalByteWidth, %ebp
        subl    $8, %ebp 
        movl    $4, Plane
t32loop0:
        outb    %al, %dx
        movl    $0x20, %ecx             /* # of rows */
t32loop1:
        movsl
        movsl
        addl    %ebp, %edi              /* offset to next row start */
        decl    %ecx
        jnz     t32loop1

        rolb    $1, %al
        adcl    $0, %edi
        movl    %ebx, %edi
        decl    Plane
        jnz     t32loop0

        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret


/******************************************************************
** void x_tile32_clipy(int x, int y, int PageBase, BYTE * bitmap);
**                        +8    +12       +16             +20
** For edges of a vertical scroller
*******************************************************************/
        .align  4
_x_tile32_clipy:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es

        movl    $0, ymax
        movl    $0, ymin
        movl    $0, LineInc
        movl    12(%ebp), %ebx
        movl    _YClipMin, %eax
        subl    %ebx, %eax
        jle     ct32CheckBottom
        movl    %eax, ymin
        movl    $32, %ecx               # check for totally hidden
        cmpl    %ecx, %eax
        jge     ct32done
        shll    $3, %eax
        movl    %eax, LineInc
        jmp     ct32noclip

ct32CheckBottom:
        cmpl    %ebx, _YClipMax
        jle     ct32done
        movl    $32, %eax
        addl    %ebx, %eax
        subl    _YClipMax, %eax
        jl      ct32noclip
        movl    %eax, ymax
        shll    $3, %eax
        movl    %eax, LineInc

ct32noclip:        
        movw    _core_select,%ax
        movw    %ax,%es
        
        movl    12(%ebp), %edi
        addl    ymin, %edi              # adjust to top of clip rect
        imul    _ScrnLogicalByteWidth, %edi
        movl    8(%ebp), %ecx
        movl    %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %edi              # I just found out that this is a
        addl    16(%ebp), %edi          # valid comment format too!!  :-)
        addl    $0xa0000, %edi
        
        movl    20(%ebp), %esi          /* bitmap pointer */
        addl    $4, %esi                /* get rid of h and w */
        movl    ymin, %edx
        orl     %edx, %edx              # add lines at top?
        jz      ct32bottomlineinc
        addl    LineInc, %esi
ct32bottomlineinc:
        movw    $0x3c4, %dx
        movb    $02, %al
        outb    %al, %dx
        incw    %dx
        andb    $3, %cl
        movb    $0x11, %al              /* Map mask - loaded to rotate */
        shl     %cl, %al
        movl    %edi, %ebx              /* store start address */
        movl    _ScrnLogicalByteWidth, %ebp
        subl    $8, %ebp 
        movl    $4, Plane
ct32loop0:
        outb    %al, %dx
        movl    $0x20, %ecx             /* # of rows */
        subl    ymin, %ecx
        subl    ymax, %ecx
ct32loop1:
        movsl
        movsl
        addl    %ebp, %edi              /* offset to next row start */
        decl    %ecx
        jnz     ct32loop1

        rolb    $1, %al
        adcl    $0, %edi
        movl    %ebx, %edi
        addl    LineInc, %esi           # skipped pixels at beginning
        decl    Plane
        jnz     ct32loop0

ct32done:
        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret



/*************************************************************/
/* x_put_PBM(int x, int y, int PageBase, BYTE * bitmap);     */
/*  puts an unmasked bitmap at given offset.  Bitmap is      */
/*  a legal planar bitmap (multiple of 4 wide)               */
/*************************************************************/
        .align  4
_x_put_PBM:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es
        
        movl    _ScrnLogicalByteWidth, %ebx
        movl    12(%ebp), %eax
        imul    %ebx, %eax
        addl    16(%ebp), %eax
        addl    $0xa0000, %eax
        movl    8(%ebp), %ecx
        mov     %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %eax
        movl    %eax, %edi
        
        movw    _core_select, %ax
        movw    %ax, %es
        
        xorl    %eax, %eax
        movl    20(%ebp), %esi
        lodsw
        xorl    %ebp, %ebp
        movw    %ax, %bp
        lodsw
        movl    %eax, BMHeight

        subl    %ebp, %ebx
        movl    %ebx, LineInc           # bx = height, bp = width

        andl    $0x03, %ecx
        movb    $0x11, %ah
        shlb    %cl, %ah
        movw    $0x3c4, %dx
        movb    $0x02, %al
        outb    %al, %dx
        incw    %dx
        movb    %ah, %al
        movb    $4, Plane
PBMPlaneLoop:
        pushl   %edi
        movl    BMHeight, %ebx
        outb    %al, %dx
PBMRowLoop:
        movl    %ebp, %ecx
        shrl    $1, %ecx
        rep
        movsw
        adcl    $0, %ecx
        rep
        movsb
        addl    LineInc, %edi
        decl    %ebx
        jnz     PBMRowLoop
        popl    %edi
        rolb    $1, %al
        adcl    $0, %edi
        decb    Plane
        jnz     PBMPlaneLoop

        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret

/****************************************************************/
/* x_put_PBM_masked(int x, int y, int PageBase, BYTE * bitmap); */
/*  same as x_put_pbm except 0 bytes are transparent            */
/****************************************************************/
        .align  4
_x_put_PBM_masked:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es

        movl    _ScrnLogicalByteWidth, %ebx
        movl    12(%ebp), %eax
        imul    %ebx, %eax
        addl    16(%ebp), %eax
        addl    $0xa0000, %eax
        movl    8(%ebp), %ecx
        mov     %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %eax
        movl    %eax, %edi
        
        movw    _core_select, %ax
        movw    %ax, %es
        
        xorl    %eax, %eax
        movl    20(%ebp), %esi
        lodsw
        xorl    %ebp, %ebp
        movw    %ax, %bp
        lodsw
        movl    %eax, BMHeight

        subl    %ebp, %ebx                /* BM Width in bytes */
        movl    %ebx, LineInc
        
        andl    $0x03, %ecx
        movb    $0x11, %ah
        shlb    %cl, %ah
        movw    $0x3c4, %dx
        movb    $0x02, %al
        outb    %al, %dx
        incw    %dx
        movb    $4, Plane
MBMPlaneLoop:
        pushl   %edi
        movl    BMHeight, %ebx
        movb    %ah, %al
        outb    %al, %dx
MBMRowLoop:
        movl    %ebp, %ecx
MBMColLoop:        
        movb    (%esi), %al
        incl    %esi
        orb     %al, %al
        jz      MBMNoPixel
        movb    %al, %es:(%edi)
MBMNoPixel:
        incl    %edi
        decl    %ecx
        jnz     MBMColLoop
        addl    LineInc, %edi
        decl    %ebx
        jnz     MBMRowLoop
        popl    %edi
        rolb    $1, %ah
        adcl    $0, %edi
        decb    Plane
        jnz     MBMPlaneLoop

        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret

/*************************************************************
** x_put_RLE(int X, int Y, int PageBase, BYTE * rlebitmap);
** Draws an rle-encoded bitmap to screen
*************************************************************/
        .align  4
_x_put_RLE:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %edi
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %es
        
        movl    _ScrnLogicalByteWidth, %ebx
        movl    12(%ebp), %edi
        imul    %ebx, %edi
        addl    16(%ebp), %edi
        addl    $0xa0000, %edi
        movl    8(%ebp), %ecx
        movl    %ecx, %edx
        shrl    $2, %edx
        addl    %edx, %edi
        andl    $0x0fffffff, %edi        /* Clear any linear access bits */
        
        movw    _core_select, %ax
        movw    %ax, %es
        
        andl    $0x03, %ecx
        movb    $0x11, %ah
        shlb    %cl, %ah
        movb    %ah, %bl
        movw    $0x3c4, %dx
        movb    $0x02, %al
        outb    %al, %dx
        incw    %dx
        movb    %ah, %al
        movl    $4, %ecx
        
        movl    20(%ebp), %esi
        movl    %edi, %ebp
        
RLEPlaneLoop:
        outb    %al, %dx
        xorl    %eax, %eax
RLEMainLoop:
        movb    (%esi), %al
        incl    %esi
        orb     %al, %al
        jz      RLEAddZeros
        movb    %al, %es:(%edi)
        incl    %edi
        jmp     RLEMainLoop
RLEAddZeros:
        movb    (%esi), %al
        incl    %esi
        orb     %al, %al
        jz      RLEPlaneDone
        addl    %eax, %edi
        jmp     RLEMainLoop
RLEPlaneDone:
        rolb    $1, %bl
        adcl    $0, %ebp
        movl    %ebp, %edi
        movb    %bl, %al
        decl    %ecx
        jnz     RLEPlaneLoop
        
        popw    %es
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %edi
        popl    %esi
        popl    %ebp
        ret
