/*
 * xpixel.s - draws a pixel
 *
 * DESCRIPTION
 *
 * USAGE
 *
 * NOTES
 * Based on xlib60 for BC by Themie Goumas
 * In x_read_pixel, use the read map instead of the mask register (al = 4)
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 * 30 Jun 95    Add x_get_pixel
 *
 */

        .data
SC_INDEX:
        .word   0x3c4
GC_INDEX:        
        .word   0x3ce

        .text
        .globl  _x_put_pixel
        .globl  _x_get_pixel
        .globl  _ScrnLogicalByteWidth
        .extern _core_select

_x_put_pixel:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %gs
        
        movl    8(%ebp), %ecx
        andl    $3, %ecx
        movw    $0x102, %ax
        shlb    %cl, %ah
        movw    SC_INDEX, %dx
        outw    %ax, %dx                /* Mask appropriate plane */
        
        movl    12(%ebp), %eax
        imul    _ScrnLogicalByteWidth, %eax
        movl    8(%ebp), %ebx
        shrl    $2, %ebx
        addl    %ebx, %eax
        addl    16(%ebp), %eax
        addl    $0xa0000, %eax

        movw    _core_select,%bx
        movw    %bx,%gs
        
        movb    20(%ebp), %bl
        movb    %bl, %gs:(%eax)

        popw    %gs
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popl    %ebp
        ret


_x_get_pixel:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %gs
        
        movl    8(%ebp), %ecx
        andl    $3, %ecx
        movw    $0x04, %al
        movb    %cl, %ah
        movw    GC_INDEX, %dx
        outw    %ax, %dx                /* Mask appropriate plane */
        
        movl    12(%ebp), %eax
        imul    _ScrnLogicalByteWidth, %eax
        movl    8(%ebp), %ebx
        shrl    $2, %ebx
        addl    %eax, %ebx
        addl    16(%ebp), %ebx
        addl    $0xa0000, %ebx

        movw    _core_select,%ax
        movw    %ax,%gs

        xorl    %eax, %eax
        movb    %gs:(%ebx), %al
        
        popw    %gs
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %ebp
        ret
