uses ve_main,crt,ve_pal;
const
  speed=2;
  maxstars=300;
  d=200;

var points:array[1..maxstars] of record x,y,z:integer; end;
    i:byte;

procedure conv3dto2d(var x,y:integer;xx,yy,zz:integer);
begin
  if zz-d<>0 then begin
    x:=160+(xx*d) div (zz-d);
    y:=100+(yy*d) div (zz-d);
  end;
end;

procedure init_demo;
var i:word;
begin
  randomize;
  for i:=1 to 63 do set_rgb(i,i,i,i);
  for i:=1 to maxstars do repeat
    points[i].x:=random(200)-100;
    points[i].y:=random(200)-100;
    points[i].z:=random(300)-100;
  until (points[i].x<>0) and (points[i].y<>0);
end;

procedure stars;
var
  xp,yp:array[1..maxstars] of integer;
  i:word;
begin
{  fillchar(xp,sizeof(xp),0);
  fillchar(yp,sizeof(yp),0);}
  fill_addr(vga,0);
  repeat
    wait_retrace;
    for i:=1 to maxstars do begin
      { clear previous position }
      if (xp[i]>=0) and (xp[i]<=319) and (yp[i]>=0) and (yp[i]<=199) then
        put_pixel(xp[i],yp[i],0,vga);
      { move star to viewer }
      if points[i].z<(200-speed) then inc(points[i].z,speed)
      else begin
        points[i].z:=random(300)-100; { back to far and new x and y positions }
        repeat
          points[i].x:=random(200)-100;
          points[i].y:=random(200)-100;
        until (points[i].x<>0) and (points[i].y<>0);
      end;
      { convert 3d position to 2d screen-coords }
      conv3dto2d(xp[i],yp[i],points[i].x,points[i].y,points[i].z);
      { draw new position }
      if (xp[i]>=0) and (xp[i]<=319) and (yp[i]>=0) and (yp[i]<=199) then
        put_pixel(xp[i],yp[i],(points[i].z+100) div 7,vga);
    end;
  until keypressed;
end;

begin
  init($13);
  init_demo;
  stars;
  shut_down;
end.
