// BOBPCX.C
//
// This code shows a 320x200 256 color MCGA/VGA PCX file
// No palette or header loading
// Microsoft C/C++    12/12/96       9:45pm

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graph.h>                          // Microsoft's graphics library

char far *vidmem = 0xA0000000L;             // pointer to video memory
#define RGB(r,g,b) (((long) ((b) << 8 | (g)) << 8) | (r))  // RGB mixing macro
long pal[256];                              // palette memory

main (void) {
 FILE *pcx_file;                            // file pointer
 char pcx_file_name[64];                    // file name
 int byte;                                  // read byte
 int num_pixels;                            // run length
 int pcx_header;							// header file (skipped over)
 long count = 0;                            // video buffer refrence
 
 printf("\n\n\n  .PCX file to display:");
 gets(pcx_file_name);                       // get the file name
  
  if (!(pcx_file=fopen(pcx_file_name,"rb")))  {
    puts("\n\nFile not found!!\n\n");       // open file, check if it exists
    return 0;                               // if not found, exit program
   }

 // read all 128 bytes of header
 for (pcx_header=0; pcx_header<128; pcx_header++)
  getc(pcx_file);                           // read in 128 byte header
 
 _setvideomode(_MRES256COLOR);              // set the video to mode 13h
                                            // Microsoft-specific function

 while (count < 64000)  {                   // read until VGA screen is full
  byte = getc(pcx_file);
  
   if(byte>=192 && byte<=255)  {            // test for RLE run
     num_pixels = byte-192;                 // get run length
     byte = getc(pcx_file);                 // get pixel color

      while(num_pixels-- > 0)               // write entire length
        vidmem[count++] = byte;             // write pixel to vid mem

    }    // end if

  else
   vidmem[count++]=byte;                    // not an RLE so write the byte

 } // end while

 getch();                                   // wait for key press
 fclose(pcx_file);                          // close the .PCX file
 _setvideomode(_TEXTC80);                   // reset to 80x25 text mode
 return 0;
}