;=============================================================================
; cplasma - Real Color plasma clouds demo.
;                                                     File created: 9-28-93
;                                                    Last modified: 9-28-93
; Description:
;   This file implements the real color plasma demostration using the
;   plasma routines and palette rotation using the VGA 320x200x256 mode.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembler.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;=============================================================================

                .model  small,pascal
                 jumps
                .286

                global  DrawPlasma:proc		; in PLASMA.ASM file.
                global  ColorPlasma:proc

;===================== Demo equates and data =================================

TIMEOUT         equ     70 * 6                  ; 6 seconds timeout.

                .data

Palette         db      768 dup (?)             ; hold the palette.
FadePalette     db      768 dup (?)             ; hold the faded palette.
Fade            db      ?                       ; fade level.
EscKey          db      ?                       ; true if ESC pressed.
Timer           dw      ?                       ; timer counter.

;========================== Demo routines ====================================

                .code

;-----------------------------------------------------------------------------
; WaitVRT - Waits the Vertical Retrace Period.
;-----------------------------------------------------------------------------

WaitVRT         proc near

                push    ax
                push    dx
                mov     dx,3DAh
WaitVRT1:       in      al,dx
                test    al,8
                jz      WaitVRT1
WaitVRT2:       in      al,dx
                test    al,8
                jnz     WaitVRT2
                pop     dx
                pop     ax
                ret

WaitVRT         endp

;-----------------------------------------------------------------------------
; SetPalette - set the 256 entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;-----------------------------------------------------------------------------

SetPalette      proc near

                mov     cx,768
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                mov     dx,3DAh
WaitVR1:        in      al,dx
                test    al,8
                jz      WaitVR1
                mov     dx,3C9h
                rep     outsb
WaitVR2:        in      al,dx
                test    al,8
                jnz     WaitVR2
                ret

SetPalette      endp

;-----------------------------------------------------------------------------
; ColorPlasma - Performs the demonstration.
; In:
;   DS - Data segment.
;-----------------------------------------------------------------------------

PUBLIC Colorplasma

ColorPlasma      proc

                mov     ax,0013h                ; set 320x200x256 mode.
                int     10h

                mov     [Fade],0                ; setup variables.
                mov     [EscKey],0
                mov     [Timer],0

                lea     di,[FadePalette]        ; clear fade palette.
                mov     ax,ds
                mov     es,ax
                mov     cx,768
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[FadePalette]
                call    SetPalette              ; set black palette.

GenPalette:     lea     di,[Palette]            ; generation of the
                xor     cx,cx                   ; plasma palette.
GP0:            mov     al,63
                mov     ah,cl
                mov     bl,al
                sub     bl,cl
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp0

                xor     cx,cx
Gp1:            mov     al,63
                sub     al,cl
                mov     ah,63
                mov     bl,cl
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp1

                xor     cx,cx
Gp2:            mov     al,0
                mov     ah,63
                sub     ah,cl
                mov     bl,63
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp2

                xor     cx,cx
Gp3:            mov     al,cl
                mov     ah,0
                mov     bl,63
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp3

                ; draw plasma onto VGA screen.

                call    DrawPlasma,30,36,290,164,01234h,0A000h

                mov     ax,ds
                mov     es,ax
                cld

PlasmaLoop:     test    [Timer],1               ; decreases the rot speed.
                jne     DontRotate
                lea     bx,[Palette]            ; rotate the palette.
                mov     si,bx
                mov     di,bx
                add     si,9
                mov     cx,768-9
                rep     movsb
                mov     si,bx
                mov     cx,9
                rep     movsb
                mov     di,bx
                xor     al,al
                mov     cx,9
                rep     stosb
DontRotate:

                cmp     [EscKey],0              ; change the fade level.
                jne     FadeOut
FadeIn:         mov     bl,[Fade]
                cmp     bl,128
                jae     FadeInOut
                inc     [Fade]
                jmp     FadeInOut

FadeOut:        mov     bl,[Fade]
                cmp     bl,0
                jbe     FadeInOut
                dec     [Fade]

FadeInOut:      lea     si,[Palette]            ; set fade palette using
                lea     di,[FadePalette]        ; the current fade level
                mov     cx,768                  ; and plasma palette.
FadeLoop:       lodsb
                mul     bl
                shr     ax,7
                stosb
                loop    FadeLoop

                lea     si,[FadePalette]        ; set VGA fade-palette.
                call    SetPalette

                mov     ah,1                    ; if any key pressed,
                int     16h
                jz      CheckTimer
                mov     ah,0
                int     16h
                jmp     BeginFadeOut

CheckTimer:     inc     [Timer]                 ; or timeout...
                cmp     [Timer],TIMEOUT
                jb      CheckExit

BeginFadeOut:   inc     [EscKey]                ; start fade-out and exit.

CheckExit:      cmp     [Fade],0                ; if fade-out is done
                jne     PlasmaLoop              ; then quit.

                mov     ax,0003h                ; restore 80x25x16 text mode.
                int     10h

                ret

ColorPlasma      endp


                end
