P286                                    ; Uses 286 instructions
jumps                                   ; Let TASM handle out-of-range jumps

Code   segment para public 'Code'
assume  cs:Code, ds:Code, es:Code

pal_buf db 768 dup(0)   ;Tijdelijke buffer      
include palette.inc     ;Palette waarden
include screen.inc      ;Screentje
include p_uncrnh.inc    ;uncrunch

ProgStart:
		call write_palette  ;Total blackness 4 fade-in

		mov ax,seg Screen
		mov ds,ax
		mov si,offset Screen
		mov ax,0b800h
		mov es,ax
		mov di,0
		mov cx,1322
		call uncrunch


		mov bp,31       ;Fade-in-loop
fade_in_loop:   call fade_in
		call write_palette
		dec bp
		jnz fade_in_loop
		
		mov ax,0
		int 16h

		mov bp,31       ;Fade-out-loop
fade_out_loop:  call fade_out
		call write_palette
		dec bp
		jnz fade_out_loop
				
		mov ax,3        ;Text-Mode
		int 10h 
		mov ax,4c00h    ;Exit-To-Dos
		int 21h

fade_in        proc
	       mov bx,0
@@fade1:       mov al,[palette+bx]
	       mov dl,[pal_buf+bx]
	       sub al,dl
	       cmp al,0
	       je no_inc
	       cmp al,1
	       je @@f1
	       inc [pal_buf+bx]
@@f1:
	       inc [pal_buf+bx]
no_inc:        inc bx
	       cmp bx,768
	       jne @@fade1
	       ret
endp           fade_in

fade_out       proc
	       mov bx,0
@@fade2:       cmp [pal_buf+bx],0
	       je no_dec
	       cmp [pal_buf+bx],1
	       je @@f2
	       dec [pal_buf+bx]
@@f2:          dec [pal_buf+bx]        
no_dec:        inc bx
	       cmp bx,768
	       jne @@fade2
	       ret
endp           fade_out

write_palette proc   ;Write Palette to Video-Port
		mov dx, 03DAh              
	v1:
		in    al, dx
		test   al,08h
		jnz    v1
	v2:
		in     al, dx
		test   al,08h
		jz     v2

		mov dx,3c8h
		mov ax,seg pal_buf
		mov ds,ax
		mov si,offset pal_buf
		mov cx,768
		xor al,al
		out dx,al
		inc dx
		rep outsb
		ret
endp            write_palette
Code   ends
End     ProgStart



