P286                                    ; Uses 286 instructions
jumps                                   ; Let TASM handle out-of-range jumps

        DOSSEG                  
        .MODEL  medium

        PUBLIC  FADEIN
	PUBLIC  FADEOUT

        .CODE
pal_buf db 768 dup(0)   ;Tijdelijke buffer      
palette db 0,0,0,0,0,42,0,42,0,0,42,42,42,0,0,42,0,42,42,42,0,42,42,42,0,0,21,0,0,63,0,42
    db 21,0,42,63,42,0,21,42,0,63,42,42,21,42,42,63,0,21,0,0,21,42,0,63,0,0,63,42,42,21,0,42
    db 21,42,42,63,0,42,63,42,0,21,21,0,21,63,0,63,21,0,63,63,42,21,21,42,21,63,42,63,21,42,63,63
    db 21,0,0,21,0,42,21,42,0,21,42,42,63,0,0,63,0,42,63,42,0,63,42,42,21,0,21,21,0,63,21,42,21
    db 21,42,63,63,0,21,63,0,63,63,42,21,63,42,63,21,21,0,21,21,42,21,63,0,21,63,42,63,21,0,63
    db 21,42,63,63,0,63,63,42,21,21,21,21,21,63,21,63,21,21,63,63,63,21,21,63,21,63,63,63,21,63
    db 63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;include palette.inc     ;Palette waarden

fade_in    proc
           mov bx,0
@@fade1:   mov al,[palette+bx]
           mov dl,[pal_buf+bx]
           sub al,dl
           cmp al,0
           je no_inc
           cmp al,1
           je @@f1
           inc [pal_buf+bx]
@@f1:
           inc [pal_buf+bx]
no_inc:    inc bx
           cmp bx,768
           jne @@fade1
           ret
endp       fade_in

fade_out   proc
           mov bx,0
@@fade2:   cmp [pal_buf+bx],0
           je no_dec
           cmp [pal_buf+bx],1
           je @@f2
           dec [pal_buf+bx]
@@f2:      dec [pal_buf+bx]        
no_dec:    inc bx
           cmp bx,768
           jne @@fade2
           ret
endp       fade_out

write_palette proc   ;Write Palette to Video-Port
        mov dx, 03DAh              
    v1:
        in    al, dx
        test   al,08h
        jnz    v1
    v2:
        in     al, dx
        test   al,08h
        jz     v2

        mov dx,3c8h
        mov ax,seg pal_buf
        mov ds,ax
        mov si,offset pal_buf
        mov cx,768
        xor al,al
        out dx,al
        inc dx
        rep outsb
        ret
endp            write_palette


FADEIN PROC FAR

               call write_palette  ;Total blackness 4 fade-in
               mov bp,31       ;Fade-in-loop
fade_in_loop:  call fade_in
               call write_palette
               dec bp
               jnz fade_in_loop

RET
ENDP

FADEOUT PROC  FAR
		mov ax,seg palette
		mov ds,ax      
		mov si,offset palette

		mov ax,seg pal_buf
		mov es,ax
		mov di,offset pal_buf

		mov cx,384    
		rep movsw		

                mov bp,31       ;Fade-out-loop
fade_out_loop:  call fade_out
                call write_palette
                dec bp
                jnz fade_out_loop
ret             ; try to erase this and see what happends
        
ENDP

        END












        














