/* 
   Gnu C++ MPEG player. Code used from Berkeley mpegplay version 2.0,
   mpeg_lib, and lots of others I don't really recall. 

   Put together by Thanassis Tsiodras (Hawk/Enigma).

   I AM NOT RESPONSIBLE FOR ANY DAMAGE, CAUSED BY THESE SOURCES, i.e.

>>>>>> If this code makes your computer burn, I DONT CARE <<<<<<

   #include <your favorite disclaimer here>
*/


#include <string.h>
#include <dos.h>
#include <std.h>
#include "mpeg.h"
#include "video.h"
#include "globals.h"

long readtime(void);

extern VidStream *theStream;
unsigned char w[768];
int frames;

long readtime()
{
   union REGS ri,ro;

   ri.h.ah=0;
   int86(0x1a,&ri,&ro);
   return ((long) (ro.x.cx)*65536L+ro.x.dx);
}

int convmat[8][4]=
{
  {117504, 138453, 13954, 34903}, /* no sequence_display_extension */
  {117504, 138453, 13954, 34903}, /* ITU-R Rec. 709 (1990) */
  {104597, 132201, 25675, 53279}, /* unspecified */
  {104597, 132201, 25675, 53279}, /* reserved */
  {104448, 132798, 24759, 53109}, /* FCC */
  {104597, 132201, 25675, 53279}, /* ITU-R Rec. 624-4 System B, G */
  {104597, 132201, 25675, 53279}, /* SMPTE 170M */
  {117579, 136230, 16907, 35559}  /* SMPTE 240M (1987) */
};

static void myinit_display(void)
{
  InitOrderedDither();
  init256();
  if (ditherType==ORDERED_DITHER) {
     int  crv, cbu, cgu, cgv;
     int  y, u, v;
     int  i;
     unsigned char *clp;

     clp=(char *) malloc(1024);
     clp+=384;
     for(i=0;i<768;i++)
       w[i]=0;
     for (i=-384; i<640; i++)
       clp[i] = (i<0) ? 0 : ((i>255) ? 255 : i);     

     crv = convmat[5][0];
     cbu = convmat[5][1];
     cgu = convmat[5][2];
     cgv = convmat[5][3];

     for (i=16; i<240; i++)
     {
       /* color space conversion */
       y = 16*((i>>4)&15) + 8;
       u = 32*((i>>2)&3)  - 48;
       v = 32*(i&3)       - 48;

       y = 76309 * (y - 16); /* (255/219)*65536 */

       w[i*3]   = (clp[(y + crv*v + 32768)>>16] >> 2);
       w[i*3+1] = (clp[(y - cgu*u -cgv*v + 32768)>>16] >> 2);
       w[i*3+2] = (clp[(y + cbu*u + 32786)>>16] >> 2);
     }
     clp-=384;
     free(clp);
  }
  else {
     int i;

     for (i=0; i<256; i++)
     {
       w[i*3]   = i>>2;
       w[i*3+1] = i>>2;
       w[i*3+2] = i>>2;
     }
  }
  Set256Palette(w);
}

main(int argc,char *argv[])
{
  ImageDesc imag;
  FILE *fp;
  char *FrameBuffer;
  register unsigned char *dest;
  register unsigned char *src;
  int i,fitsx,fitsy;
  int st,en,dx;
  char szFileName[128];

  if (argc<3) {
    puts("\nPlayer made by Thanassis Tsiodras - Ported from xmpeg_play 2.0\n");
    puts("Syntax: mpegplay -d[g,c] filename<.mpg> <-nb>");
    puts("Needed options:");
    puts("	           -dg means grayscale output");
    puts("		   -dc means color dithered 8 bit output");
    puts("Optional:");
    puts("	 	   Adding -nb at the end, means skip B frames.");
    exit(1);
  }
  strcpy(szFileName,argv[2]);
  if (strchr(szFileName,'.')==NULL)
    strcat(szFileName,".mpg");
  if ((fp=fopen(szFileName,"rb"))==NULL)
    return;

  if (!strcmp(argv[1],"-dc"))
     SetMPEGOption (MPEG_DITHER, ORDERED_DITHER);
  else if (!strcmp(argv[1],"-dg"))
     SetMPEGOption (MPEG_DITHER, GRAY_DITHER);
  else {
    puts("Dither option must be: -dc or -dg");
    exit(1);
  }
  if (argc==4) {
    if (!strcmp(argv[3],"-nb"))
      ToggleBFlag();
    else
      printf("%s unrecognized (I only accept -nb at the moment). \n",argv[3]);
  }
  OpenMPEG(fp, &imag);
  myinit_display();
  frames=0;
  dx=GrMaxX()+1;

  fitsx=theStream->h_size>GrMaxX()?GrMaxX():theStream->h_size;
  fitsy=theStream->v_size>GrMaxY()?GrMaxY():theStream->v_size;
  st=readtime();
  while (GetMPEGFrame(&FrameBuffer)==TRUE) {
     dest=(char *)0xD0000000+( (dx*((GrMaxY()-fitsy)/2)) + ((GrMaxX()-fitsx)/2) );
     src=FrameBuffer;
     for(i=0; i < fitsy; i++) {
        memcpy(dest,src,fitsx);
        dest+=dx;
        src+=imag.Width;
     }
     frames++;
     if (kbhit())
        break;
  }
  while (kbhit())
    getch();
  en=readtime();
  close256();
  CloseMPEG();
  puts("Player made by Thanassis Tsiodras - Ported from xmpeg_play 2.0\n");
  printf("Frame Ratio: %3.1f\n",frames/((en-st)/18.2));
}
