// Here are some simple image manipulation functions for 320x200x256 mode
// graphics.
// Released to Public Domain
// by  Steve Cox
// P.S. some functions are not optimized or fully debugged


// Steve - I went through and optimized some things. Take a look at your
// copy_buffer & put_forground routines for some helpful hints! I will go through
// and optimize these more (leaving helpful hints along the way).
// just going over what is here it looks pretty good. I will probably
// do most of the optimizing in assembly (my native tongue(SP?)) if thats
// okay. I will leave notes so it will be understandable...
// Netmail me what you think or for general chitchat. I code assembler
// and C using Borland C++ 3.1 on a 486sx25(what a machine!). I have
// published some games with Softdisk Publishing. I am currently working
// on a Graphics Engine (Sprite Portion) like Wolfenstein. I don't need
// the grid mapping system yet so I am holding out on it. Having a nightmare
// trying to find good (and readable) 3D code that uses integer math.
// Rich Geldreich's code is good and I am porting it to C. Then it is off
// to texture mapping (doesn't this sound fun?). Any questions?

// Matthew Hudson @ 1:18/14.4

#pragma inline           // you will need this for inline assembler stuff
main()
{
	// just an example main !!!!!!!!

	 char far *ScreenPtr = 0xA000;                  //make a screen ptr
	 char far *Background;
	 char far *Forground;
	 char far *DrawingBuffer;

	  Init256mode();
	  Background=load_image_buffer("back.scr");     //load Background image
	  Forground=load_image_buffer("bushes.scr");    //load forground image
	  DrawingBuffer=make_virtual_screen();          //make a sketch pad
	  copy_buffer(Background,DrawingBuffer);        //copy Background to it
	  put_forground(Forground,DrawingBuffer);       //copy Forground to it
	  copy_buffer(DrawingBuffer,ScreenPtr);         //copy to screen

  //   do something else     !!!!!!!!!!!!!!



		 free(Background);                 //free up any memory the buffers use
		 free(Forground);
		 free(DrawingBuffer);
		 resetmode();
		 exit(0);
}

// the routine below needs some work, but you are on the right track.


// This functions assumes a raw pixel dump of the video screen in 320x200x256
// mode . You can find tsr's that will do this for you.
// Draw your images using a drawing program and use the tsr to dump image to file
// Any pixel value that is 0 will not be drawn to the ImgBuffer.
// Hense ...... Xray or Transparent putimage capability
/*-----------------------------------------------------------------------*/
put_forground(char far *ImgPtr,char *ImgBuffer)
{
	int Buffseg1,Buffseg2;
	long incold;                      //inline assembler version !!!!!!!!!
												 //VERY FAST
//	Buffseg1=FP_SEG(ImgPtr);
//	Buffseg2=FP_SEG(ImgBuffer);

//	asm  PUSH BP				no need to do this C does it for you.
							// BTW: when doing an ASM routine you must
							// MOV BP,SP also. Do this before you get anything
							// from the stack.
	asm	PUSH DI
	asm	PUSH SI
	asm	PUSH DS
//   asm	PUSH ES     to C ES is a general pupose register. If in has a value
							// in it C will push ES before calling a subroutine.
	asm  MOV  AX,Buffseg1    //same for DS
	asm  MOV  DS,AX

	asm  XOR  AX,AX
	asm  MOV  DI,AX
	asm  MOV  SI,AX
	asm  CLD
	asm  MOV  CX,64000       //quit when entire image is scanned

ScanStart:

	asm	MOV   AX,Buffseg1    //point to the ImgPtr
	asm	MOV   ES,AX
	asm  XOR   AX,AX          //load zero into AL
	asm  REPE  SCASB          //repeat search of pixels aren't zero data
									  //if CX == 0 scan will quit loop
	asm  CMP   CX,0000h       //if this statment is true ,Image pointed to
	asm  JE    DONE           //by es:di is all zero pixels - quit function
	asm  MOV   SI,DI          //else, save old Imgptr offset into Buffer offset
	asm  MOV   incold,CX      //save cx into incold variable
	asm  XOR   AX,AX
	asm  REPNE SCASB          //repeat scan if pixel data is not == zero
									  //if CX == 0 then quit scan loop
	asm  PUSH  CX             //save CX for now
	asm  SUB   incold,CX      //calculate length of movsb
	asm  MOV   CX,incold      //mov length into CX
	asm  MOV   AX,Buffseg2    //
	asm  MOV   ES,AX          //point to destination buffer
	asm  PUSH  DI             //save DI for now
	asm  MOV   DI,SI          //offset destination index
	asm  REP   MOVSB          //move the data
	asm  POP   DI             //restore DI
	asm  POP   CX             //restore CX and loop back until 64000 tries
	asm  JMP   ScanStart

DONE:

//	asm	POP  ES
	asm	POP  DS
	asm	POP  SI
	asm	POP  DI
//	asm  POP  BP

	return;
}
// Same thing as put_forground but used for sprite or small images that
// need Xray putimage
// gets slower  with more pixel data ( obviously )
/*-----------------------------------------------------------------------*/
put_Xray(int x1,int y1,int width,int depth,char far *ImgBuffer,char *ImgPtr)
{

	int i,t,temp=0;
	 unsigned long int PixelAddress;


	for(i=0;i < depth;i++)
		 {
	 for(t=0;t < width;t++)
		{
		 temp=*ImgPtr++;
		 if(temp == 0){ x1++;continue;}
		 PixelAddress=(unsigned long) y1 * 320 + x1;
		 FP_OFF(ImgBuffer) = (unsigned int) PixelAddress;
		 movedata(FP_SEG(ImgPtr),FP_OFF(ImgPtr),
			  FP_SEG(ImgBuffer),FP_OFF(ImgBuffer),1);
		 x1++;
		 }
		 x1-=width;
		 y1++;
	 }
	 return;
}

// Transfers the buffers that were created earlier back and forth
// VERY FAST !!!!!!!!!!
// Fixed 64k size
/*-----------------------------------------------------------------------*/
void copy_buffer(char far *BuffPtr1,char far *BuffPtr2)
{

	// Steve your pointers were pushed to the stack when you entered
	// this routine. This is an easier (and slightly faster) way
	// of doing it...

//	int buffseg1,buffseg2;

//	buffseg1=FP_SEG(BuffPtr1);           //inline assembler version
//	buffseg2=FP_SEG(BuffPtr2);

	asm  PUSH DI
	asm  PUSH SI
	asm  PUSH DS
//	asm  PUSH ES		   no need to push ES when entering a C routine.
//								it is a General Purpose register to C.

	asm  lds  si,[bp+6]   // LDS loads the DS and SI...
	asm  les  di,[bp+10]  // same here except with ES and DI...
								 // Far pointers (if unmodified) are pushed
								 // with the offset = 0;
								 // but for safty sake (and bullet proof code)
								 // clear SI and DI anyway.

//	asm  MOV  AX,buffseg2
//	asm  MOV  ES,AX
//	asm  MOV  AX,buffseg1
//	asm  MOV  DS,AX
	asm  XOR  AX,AX       // I did a little optimization...
	asm  MOV  DI,AX
	asm  MOV  SI,AX
	asm  CLD
	asm  MOV  CX,64000
	asm  REP  MOVSB

//	asm  POP  ES
	asm  POP  DS
	asm  POP  SI
	asm  POP  DI

	return;
}

// Pass a ptr to a bitmap and this function will shrink it by the
// amount specified by the argument scale
/*-----------------------------------------------------------------------*/
contract_image(int x1,int y1,int width,int depth,int scale,char far *ImgPtr)
{
	int i,t,xinc,yinc,xoff=x1,yoff=y1,PixelColor;

	depth-=scale;
	width-=scale;
	yinc=0;

	for(i=0;i < depth;i++)
		 {
	 xinc=0;
	 if(yinc++ >= depth/scale-1) { yinc=0;ImgPtr+=width+scale; }
	 for(t=0;t < width;t++)
		{
		  PixelColor=*ImgPtr;
		  if(xinc++ >= width/scale-1 ) { xinc=0;ImgPtr++; }
		  ImgPtr++;
		  putpixel(xoff,yoff,PixelColor);
		  xoff++;
		 }
		 xoff-=width;
		 yoff++;
	 }
	 return;
}

// Pass a ptr to a bitmap and this function will expand it by the
// amount specified by the argument scale
/*-----------------------------------------------------------------------*/
expand_image(int x1,int y1,int width,int depth,int scale,char far *ImgPtr)
{

	int i,t,xoff=x1,yoff=y1,PixelColor;

	for(i=0;i < depth;i++)
		 {
	 for(t=0;t < width;t++)
		{
		 PixelColor=*ImgPtr++;
		 pixelscaled(xoff,yoff,scale,PixelColor);
		 xoff+=scale;
		 }
		 xoff-=width*scale;
		 yoff+=scale;
	 }
	 return;
}
/*-----------------------------------------------------------------------*/
halve_image(int x1,int y1,int width,int depth,char far *ImgPtr)
{
	int i,t,xoff=x1,yoff=y1,PixelColor;

	depth/=2;
	width/=2;

	for(i=0;i < depth;i++)
		 {
	 for(t=0;t < width;t++)
		{
		 PixelColor=*ImgPtr;
		 ImgPtr+=2;
		 putpixel(xoff,yoff,PixelColor);
		 xoff++;
		 }
		 xoff-=width;
		 yoff++;
	 }
	 return;
}
// Draws scaled pixels on the screen
/*-----------------------------------------------------------------------*/
pixelscaled(int x,int y,int scale,int color)
{
	int i,t,xoff=x,yoff=y,width=scale,depth=scale;

	for(i=0;i < depth;i++)
		 {
	 for(t=0;t < width;t++)
		{
		 putpixel(xoff,yoff,color);
		 xoff++;
		 }
		 xoff-=width;
		 yoff++;
	 }
	 return;
}
// 256 color mode putpixel function
/*------------------------------------------------------------------*/
putpixel(int X,int Y,unsigned char Color )
{
	 BitmapAddress = (unsigned long) Y * ScreenWidthInPixels + X;
	 FP_SEG( ScreenPtr ) = SCREEN_SEGMENT;
	 FP_OFF( ScreenPtr ) = (unsigned int) BitmapAddress;
	 *ScreenPtr = Color;
	  return;
}
/*--------------------------------------------------------------------*/
char far *make_virtual_screen()
{
	char far *ptr;
	unsigned long length=64000;

		 if((ptr=(char far*) malloc(length)) == NULL)
	 {
		printf("OUT OF MEMORY !!!!!");
		delay(1000);
		 resetmode();
		 exit(0);
	  }
		 return ptr;
}
/*--------------------------------------------------------------------*/
char far *load_image_buffer(char *fname)
{
	FILE *fp;
	char far *ptr;
	unsigned long length=64000;

	 if((fp=fopen(fname,"rb")) == NULL)
		 {
	 printf("FILE ERROR  LOADING => %s  \n",fname);
	 resetmode();
	 exit(0);
	}

		 if((ptr=(char far*) malloc(length)) == NULL)
	 {
		printf("OUT OF MEMORY !!!!!");
		quit();
	  }
		 fread(ptr,1,length,fp);
		 fclose(fp);
		 return ptr;
}
/*--------------------------------------------------------------------*/
Init256mode()
{
	 union REGS regset;
	 regset.x.ax = 0x13;
	 int86( 0x10, &regset, &regset );
	 MaxX=320;
	 MaxY=200;
	 return;
}
/*---------------------------------------------------------------------*/
resetmode()
{
	 union REGS regset;
	 regset.x.ax = 0x0003;
	 int86( 0x10, &regset, &regset );
}

