program jeff(input,output,PRN);

uses jvesa;

const FormFeed=#12;

var VESAtype:SVGAinfoTYPE;
    Modeinfo:modeinfoTYPE;
    prn:text;
    count:integer;

procedure sortWSTa(var WS:wordstringTYPE);
var count1,count2,low,temp,last:word;
begin
  for count1:= 0 to 127 do
    if WS[count1] = $FFFF then break;
  last:=count1;
  for count1:= 0 to last-1 do begin
    low:=count1;
    for count2:= count1+1 to last do
      if (WS[count2]<ws[low]) then low:=count2;
    temp:=ws[low];
    ws[low]:=ws[count1];
    ws[count1]:=temp
  end
end;

function power(base,expon:real):real;
begin
  power:=exp(expon*ln(base))
end;

procedure writehex(var where:text;num:word);
var count:word;
begin
  for count:= 3 downto 0 do
    case (num shr (count * 4)) and $F of
      $F:write(where,'F');
      $E:write(where,'E');
      $D:write(where,'D');
      $C:write(where,'C');
      $B:write(where,'B');
      $A:write(where,'A');
      else write(where,(num shr (count * 4) and $F))
    end
end;

procedure writebin(var where:text;num:byte);
var count:integer;
begin
  for count:=7 downto 0 do begin
    if num >(power(2,count)-1) then begin
      write(where,'1');
      num:=num-(trunc(power(2,count)))
    end else write(where,0)
  end
end;

begin
  assign(prn,'j.j');
  rewrite(prn);
  VESAtype.signature:='VBE2';
  SVGAini(VESAtype);
  with vesatype do begin
    writeln(PRN,signature[0],signature[1],signature[2],signature[3],' VBE Version: ',version.major,'.',version.minor);
    for count:=0 to 255 do begin
      write(PRN,OEMstrPTR^[count]);
      if OEMstrPTR^[count]=#0 then break
    end;
    writeln(PRN);
    writeln(PRN,'Total memory: ',memory*64,'kb');
    if version.major >=2 then begin
      writeln(PRN,'VESA VBE Vendor: ',Vendor^);
      writeln(PRN,'VESA VBE Product: ',product^);
      writeln(PRN,'VESA VBE Product Revision: ',ProductRev^);
      writeln(PRN,'VESA VBE Software Revision: ',softver.major,'.',softver.minor);
    end;
    write(PRN,'Cabibilities: ');
    writebin(PRN,capibilities[3]);
    writebin(PRN,capibilities[2]);
    writebin(PRN,capibilities[1]);
    writebin(PRN,capibilities[0]);
    writeln(PRN);
    sortWSTa(modesPTR^);
    write(PRN,'Modes supported (in Hex):');
    writehex(PRN,modesPTR^[0]);
    for count:=1 to 127 do begin
      if modesPTR^[count] = $FFFF then break;
      write(PRN,', ');
      writehex(PRN,modesPTR^[count]);
    end;
    writeln(PRN);
    writeln(PRN,'Mode information:');
    for count:= 0 to 127 do begin
      if modesPTR^[count] = $ffff then break;
      SVGAmodeinfo(modesPTR^[count],modeinfo);
      with modeinfo do begin
        write(PRN,'Mode:');
        writehex(PRN,modesPTR^[count]);
        writeln(PRN);
        write(PRN,'   Attributes: ');
        writebin(PRN,byte(Attributes shr 8));
        writebin(PRN,byte(attributes));
        writeln(PRN);
        write(PRN,'   Window A Attributes: ');
        writebin(PRN,WinA);
        writeln(PRN);
        write(PRN,'   Window B Attributes: ');
        writebin(PRN,WinB);
        writeln(PRN);
        writeln(PRN,'   Window granularity: ',wingran,'kb');
        writeln(PRN,'   Window Size: ',winsize,'kb');
        write(PRN,'   Window A Segment: ');
        writehex(PRN,winaseg);
        writeln(PRN);
        write(PRN,'   Window B Segment: ');
        writehex(PRN,winbseg);
        writeln(PRN);
        write(PRN,'   The window function is located at (Real Mode): ');
        writehex(PRN,seg(functptr^));
        write(PRN,':');
        writehex(PRN,ofs(functptr^));
        writeln(PRN);
        writeln(PRN,'   Bytes per scan line: ',bperln);
        writeln(PRN,'   Resolution: ',xres,'x',yres);
        writeln(PRN,'   The character size is: ',xcharsize,'x',ycharsize);
        writeln(PRN,'   There are ',noofplanes,' planes');
        writeln(PRN,'   Bits per pixel: ',bitsperpixel);
        writeln(PRN,'   There are ',noofbanks,' ',banksize,'kb banks');
        write(PRN,'   Memory model: ');
        writehex(PRN,memmodel);
        writeln(PRN);
        if memmodel=6 then begin
          write(PRN,'   Direct color attributes: ');
          writebin(PRN,DirectColorModeinfo);
          writeln(PRN)
        end;
        if version.major >= 2 then begin
          write(PRN,'   Physical base address (in hex): ');
          writehex(PRN,PhysicalPTR[3]);
          writehex(PRN,PhysicalPTR[2]);
          writehex(PRN,PhysicalPTR[1]);
          writehex(PRN,PhysicalPTR[0]);
          writeln(PRN);
          write(PRN,'   Unused memory starts at protected mode offset: ');
          writehex(PRN,OffScreenOffset[3]);
          writehex(PRN,OffScreenOffset[2]);
          writehex(PRN,OffScreenOffset[1]);
          writehex(PRN,OffScreenOffset[0]);
          writeln(PRN);
          writeln(PRN,'   Available offscreen memory: ',Offscreensize,'kb')
        end;
        writeln(PRN);
      end
    end
  end;
  close(PRN);
end.