;==============================;
;                              ;
; LENS coded by maLi/FiNESSE   ;
; e-mail: igo.gruden@uni-lj.si ;
; programming in TASM 3.2      ;
; date: 14.4.1996              ;
;                              ;
;==============================;
.model large,c
.386
.stack 100h
.data

filename db 'naomi.pcx',0
fhandle  dw ? ;file handle
palette  db 786 dup (?)
startx   dw ? ;start x of picture
starty   dw ? ;start y of picture
sizex    dw ? ;width of picture
sizey    dw ? ;height of picture
pcxver   db ? ;pcx version-must be 5 for 320x200x256 .pcx file
picture  dw ? ;segment of allocated block-picture
screen   dw ? ;segment of virtual screen
nomemory db 'not enough memory$'
nofile   db 'file error$'
nopcx    db 'this is not valid 256 colors .pcx file$'
greets   db 'LENS',13,10
         db 'Code: maLi/FiNESSE - 1996$'
filesize equ 21319
len      db ?
smerx    db ?
smery    db ?
lx       dw ?  ;lens x position
ly       dw ?  ;lens y position
fde      dw ?
f        dw ?
lensize  dw 60
lensize2 dw 60*60
src      db 60*60 dup (?)
dest     db 60*60 dup (?)

include lens.inc
include ytable.inc

.code
;============= I N I T   D E M O - A L L O C A T E . . . =============
        mov ax,@data

        mov ds,ax
        mov ax,4a00h
        mov bx,1000h
        int 21h
        jc error_nomemory    ;not enough memory
        mov ax,4800h         ;allocate memory for virtual screen
        mov bx,1000h
        int 21h
        mov screen,ax        ;save segment

        mov ax,4a00h
        mov bx,1000h
        int 21h
        jc error_nomemory    ;not enough memory
        mov ax,4800h         ;allocate memory for .pcx file
        mov bx,1000h
        int 21h
        mov picture,ax       ;save segment

        mov ax,3d00h         ;open file
        xor al,al            ;normal file
        lea dx,filename
        int 21h
        jc error_file        ;error
        mov fhandle,ax       ;save file handle

        push ds
        mov ax,screen
        mov ds,ax
        xor dx,dx
        mov ax,3f00h         ;read from file
        mov bx,cs:[fhandle]  ;set file handler
        mov ax,3f00h
        mov cx,filesize      ;file size
        int 21h
        pop ds
        mov ax,3e00h         ;close file
        mov bx,cs:[fhandle]
        int 21h

;================== L O A D    . P C X     F I L E ===========
        mov ax,screen
        mov fs,ax
        mov si,1
        mov al,fs:[si]
        cmp al,5             ;checking if it's 256 colors .pcx file
        jnz error_pcx        ;it's not...

        add si,3
        mov ax,word ptr fs:[si]
        mov startx,ax        ;read start x of picture

        add si,2
        mov ax,word ptr fs:[si]
        mov starty,ax        ;read start y of picture

        add si,2
        mov ax,word ptr fs:[si]
        mov sizex,ax         ;read size x of picture

        add si,2
        mov ax,word ptr fs:[si]
        mov sizey,ax         ;read size y of picture

        mov si,filesize
        sub si,768
        mov cx,768
        xor di,di           ;read palette
        read_pal:
        mov al,fs:[si]
        shr al,2
        mov [palette+di],al
        inc si
        inc di
        loop read_pal

        mov ax,0013h
        int 10h

        call setpalette

        mov si,127           ;ignore pcx header

        mov ax,picture       ;where to decode picture
        mov es,ax
        xor di,di
        cld
        pcx_main:

        mov al,fs:[si]
        inc si
        mov bl,al
        and bl,0c0h          ;is compressed?
        cmp bl,0c0h
        jnz not_compressed

        and al,3fh           ;it's compressed
        mov len,al           ;lenght of packet
        mov al,fs:[si]       ;color
        inc si
        jmp draw_pcx

        not_compressed:
        mov bl,1
        mov len,bl

        draw_pcx:

        mov cl,len            ;draw pixel(s)
        xor ch,ch             ;lenght of block is in len
        rep stosb             ;color is in al

        cmp di,63999          ;is picture drawn?
        jb pcx_main


        push ds
        mov ax,screen
        mov es,ax
        mov ax,picture
        mov ds,ax
        mov cx,16000
        xor si,si
        xor di,di
        rep movsd
        pop ds

        xor cx,cx;lens y position
        xor bx,bx;lens x position
        mov smerx,bl
        mov smery,bl
        mov f,bx;fading?
        mov fde,bx;dont fade until fde < 600
;========= M A I N   P R O G R A M - L E N S    M O V I N G =============

        lens_main:

        mov bx,fde
        inc bx
        mov fde,bx

        mov bx,lx;calculate x position of lens
        mov al,smerx
        cmp al,0
        jz vecajx
        dec bx
        mov lx,bx
        cmp bx,0
        ja donex
        xor al,al
        mov smerx,al
        jmp donex
        vecajx:
        inc bx
        cmp bx,255
        jb donex
        mov al,1
        mov smerx,al
        donex:
        mov lx,bx

        mov bx,ly;calculate y position of lens
        mov al,smery
        cmp al,0
        jz vecajy
        dec bx
        mov ly,bx
        cmp bx,0
        ja doney
        xor al,al
        mov smery,al
        jmp doney
        vecajy:
        inc bx
        cmp bx,135
        jb doney
        mov al,1
        mov smery,al
        doney:
        mov ly,bx

        call getsrc;get image for lens
        call transform;transform image
        call putdest;put destination
        call vretrace
        call flip;make visible

        cmp fde,600
        jbe dalje

        mov bx,f
        inc bx
        mov f,bx

        mov bx,768
        fade:
        mov al,[palette+bx]
        cmp al,0
        jbe smol
        dec al
        mov [palette+bx],al
        smol:
        dec bx
        jnz fade
        call setpalette






        dalje:
        cmp f,63
        jb lens_main

        ;mov ax,0003h
        ;int 10h

        jmp end_progy


        error_file:
        mov ax,900h
        lea dx,nofile
        int 21h
        jmp end_progy

        error_pcx:
        mov ax,900h
        lea dx,nopcx
        int 21h
        jmp end_progy

        error_nomemory:
        mov ax,900h
        lea dx,nomemory
        int 21h

        end_progy:

        mov ax,screen ;deallocate memory
        mov es,ax
        mov ax,4900h
        int 21h

        mov ax,picture;deallocate memory
        mov es,ax
        mov ax,4900h
        int 21h

        ;mov ax,900h
        ;lea dx,greets
        ;int 21h

        mov ax,4c00h
        int 21h

vretrace proc near
         push ax dx
         mov dx,3dah
         vr:
         in al,dx
         and al,8
         jnz vr
         vnr:
         in al,dx
         and al,8
         jz vnr
         pop dx ax
         ret
         endp

flip proc near
     push ax cx si di ds es
     mov ax,screen
     mov ds,ax
     mov ax,0a000h
     mov es,ax
     xor di,di
     xor si,si
     mov cx,16000
     rep movsd
     pop es ds di si cx ax
     ret
     endp

;get src for lens
getsrc proc near
       push ax bx cx si di es
       mov ax,picture
       mov es,ax

       mov di,ly
       add di,di
       mov si,[ytab+di]
       add si,lx;start address of lens
       xor di,di
       mov bx,lensize;load counter y
       gety:
       mov cx,lensize;load counter x
       getx:
       mov al,es:[si]
       mov [src+di],al
       inc di
       inc si
       loop getx
       add si,320
       mov ax,lensize
       sub si,ax
       dec bx
       jnz gety
       pop es di si cx bx ax
       ret
       endp


;do transformation
transform proc near
          push bx cx di si bp ds es
          push ds
          pop es
          lea si,lens
          lea di,dest
          mov cx,lensize2
          xor bh,bh
          do_transf:
          lodsw
          mov bx,ax
          mov al,[src+bx]
          stosb
          inc dx
          loop do_transf
          pop es ds bp si di cx bx
          ret
          endp transform



;put lens
putdest proc near
        push ax bx cx si di es
        mov ax,screen
        mov es,ax
        mov di,ly
        add di,di
        mov si,[ytab+di]
        add si,lx
        mov bx,lensize
        xor di,di
        puty:
        mov cx,lensize
        putx:
        mov al,[dest+di]
        mov es:[si],al
        inc di
        inc si
        loop putx
        add si,320
        mov ax,lensize
        sub si,ax
        dec bx
        jnz puty
        pop es di si cx bx ax
        ret
        endp


setpalette proc near
           uses ax,cx,dx,si
           mov dx,3c8h      ;set palette
           xor al,al
           out dx,al
           inc dx
           mov cx,768
           lea si,palette
           rep outsb
           ret
           endp

end

