(*   UNIT MedCut   Median Cut Algorithm in Pascal
     Author Hannes Streicher
     EMail  HStreicher@T-Online.de
            Compuserve 101447;227
     Mail   Tannenstr. 3
            D-82049 Pullach
     HiColor oder Truecolor Bilddateien in Palettenbasierte Bilder berfhren
     Use    Try to map the colours of a Highcolour or True Color image
            to a Fixed number of colours (max 256)
     Shareware  DM 25.--
     Literatur   C'T Magazin fr Computertechnik
     Version     1996.12.21
*)

{$A+,B-,D-,E+,F+,G+,I-,L-,N+,O+,P-,Q-,R-,S-,T-,V-,X-,Y-}

unit MedCut;
{.$DEFINE DEBUG}

interface
uses
{$IFDEF DEBUG}
  Printer,
{$ENDIF}
  Graph;
const MaxCol      : Integer = 255;  (* wieviele Farben in der Palette *)
      AbsMaxCol   = 255;

type  XLookUpType = array[0..32768] of Byte;

var Lookup      : ^XLookUpType; (*array[0..32768] of byte;
                 (* this is a lookup to speed up *)
                 (* display of the analyzed picture *)
    Palette     : array[0..AbsMaxCol] of record R,G,B : Byte; end;


procedure InitMedCut(Mc : Integer);
  (* Aufruf VOR allen anderen Routinen
     Mc ist die Anzahl der Farben auf die Reduziert werden soll *)

procedure KillMedCut; (* call after analookup , to release memory *)

(* eine der folgenden Routinen muss fr jedes Pixel des Ausgangsbildes
   aufgerufen weden
   either of the following four must be called for each pixel in the
   image to be reduced to a palette *)

procedure DoLookup24( R,G,B : Byte);  (* for 24 bit colors *)

procedure DoLookUp24Li( R,G,B : Longint);  (* for 24 bit colors *)

procedure DoLookUp16( W : Word);   (* for 16 bit colors 0rrrrrgggggbbbbb *)

procedure DoLookUpRGB5Bit( R,G,B : Byte);

(* nachdem alle Pixels an eine der obigen Routinen bergeben wurden      *)
(* muss NewAnaLookUp aufgerufen werden , um das Histogramm der Farben    *)
(* auszuwerten , danach enthlt das Array LOOKUP die Map Werte           *)
(* um die True Color Werte in die Palettenwerte zu berfhren            *)
(* sollten die True Colorwerte als 24 Bit Daten vorliegen dann muss      *)
(* vor jedem Aufruf die Funktion Convert24to15 aufgerufen werden         *)

(* after all the pixels have been given to one of the above routines     *)
(* call newanalookup , to analyze the histgram built above and determine *)
(* the palette, after that the palette information will be contained     *)
(* in the array LOOKUP  based on a 15 bit true color value , if you have *)
(* 24 bit then use the function convert24to15 before the lookup          *)
(* the result will be stored in the array palette for 8 bit color values *)
(*------------------  Pseudo Code ---------------- *)
(* initmedcut *)
(* read image  call dolookup__ for each pixel *)
(* newanalookup *)
(* redraw image with palette *)
(* killmedcut *)

procedure NewAnaLookup; (* median cut algorithm *)

function Convert24to15(R,G,B : Integer): Integer;

function Convert24To15Li(R,G,B : Longint): Integer;

(*  WARNING needs about 32*32*32 *4 ( 128K) bytes of heap space *)


implementation

uses Crt;

type    LookUpType = array[0..31] of array[0..31] of Longint;
        LookUpPtr  = ^LookUpType;

     QuaderType = record
                    RMin, RMax,
                    GMin, GMax,
                    BMin, BMax  : Integer;
                    Size        : Longint;
                    Qty         : Longint;
                    R,G,B       : Integer;  (* die errechnete farbe *)
                  end;

var Quader  : array[0..AbsMaxCol] of QuaderType;
    QuaCnt  : Integer;

var I,J,K   : Word;
    LokUp   : array[0..31] of LookUpPtr;
    i1,I2,i3: Integer;

procedure DoLookUp16( W : Word);
var R,G,B : Integer;
begin
  R:=(W and $7C00) shr 10; (* 0111 1100 0000 0000 = $7c00*)
  G:=(W and $03e0) shr 5 ; (* 0000 0011 1110 0000 = $03e0*)
  B:=W and $001f; (* 0000 0000 0001 1111 = $001f*)
  inc(LokUp[R]^[G,B]);
end;

procedure DoLookup24( R,G,B : Byte);
begin
  R:= R shr 3;
  G:= G shr 3;
  B:= B shr 3;
  inc(LokUp[R]^[G,B]);
end;

procedure DoLookUp24Li( R,G,B : Longint);
begin
  R:= R shr 3;
  G:= G shr 3;
  B:= B shr 3;
  inc(LokUp[R]^[G,B]);
end;

procedure DoLookUpRGB5Bit( R,G,B : Byte);
begin
  inc(LokUp[R]^[G,B]);
end;


procedure NewAnaLookup;  (* median cut algorithm *)

  function MedCutGetColor( Wrk : Integer ) : Integer; near;
  var Max,tmp,tr: Longint;
      I,Pos     : Integer;
      R,G,B     : Integer;
  begin
    R:=(Wrk and $7c00) shr 10;
    G:=(Wrk and $03e0) shr 5;
    B:=Wrk and $1f;
    Max:=32*32*4;
    Pos:=0;
    for I:=0 to QuaCnt do
      begin
        tr:=Quader[I].R-R;
        tmp:=tr*tr;
        if tmp<Max then
	  begin
	    tmp:= tmp+  (Quader[I].G-G)*(Quader[I].G-G)+
                        (Quader[I].B-B)*(Quader[I].B-B);
	    if tmp<Max  then
	      begin
	        Max:=tmp;
	        Pos:=I;
	      end;  (* for i / if *)
	  end; (* if tmp *)
    end; (* for i *)
    MedCutGetColor:=Pos;
  end;   (* medcutgetcolor *)

  procedure AverageColor(RMin,RMax,GMin,GMax,BMin,BMax : Integer;
                         var Rw,gw,Bw : Integer);
  (* die farben in einem quader aufsummieren und den gewichteten mittelwert bilden *)
  var Rr,Gr,br : Longint;  (* gewichtete werte *)
      Count    : Longint; (* count fuer gewichtung *)
      Menge    : Longint;
      R,G,B    : Longint;
  begin
    Rr:=0; Gr:=0; br:=0;
    Count:=0;
    for R:=RMin to RMax do
      for G:=GMin to GMax do
        for B:=BMin to BMax do
         if LokUp[R]^[G,B]>0 then
          begin
            Menge:=LokUp[R]^[G,B];
            Rr:=Rr+Menge*R;
            Gr:=Gr+Menge*G;
            br:=br+Menge*B;
            Count:=Count+Menge;
          end; (* for r/g/b *)
    if Count<>0 then
      begin
        Rw:=round(Rr/Count);
        gw:=round(Gr/Count);
        Bw:=round(br/Count);
      end else begin
        Rw:=(RMin+RMax)div 2;
        gw:=(GMin+GMax)div 2;
        Bw:=(BMin+BMax)div 2;
      end;
  end;

  function QuaderCount(RMin,RMax,GMin,GMax,BMin,BMax:Integer):Longint;
  var R,G,B : Integer;
      cnt   : Longint;
  begin
    cnt:=0;
    for R:=RMin to RMax do
      for G:=GMin to GMax do
        for B:=BMin to BMax do
          begin
            cnt:=cnt+LokUp[R]^[G,B];
          end;
    QuaderCount:=cnt;
  end;

  function QuaderSize(RMin,RMax,GMin,GMax,BMin,BMax : Integer): Longint;
  begin
    QuaderSize:=Longint(RMax-RMin+1)*Longint(GMax-GMin+1)*Longint(BMax-BMin+1);
  end;

  procedure ReduceQuader(var RMin,RMax,GMin,GMax,BMin,BMax : Integer);
  var G,B,R : Integer;
      cnt   : Longint;
  begin  (* den quader auf das minimum reduzieren, so dass alle unbelegten *)
    (* werte des histogramms abgeschnitten werden *)
    (* erstens nach rechts einengen *)
    cnt:=0;
    R:=RMin;
    while ((cnt=0) and (R<RMax)) do
      begin
        for G:=GMin to GMax do
          for B:=BMin to BMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then inc(R);
      end;
    RMin:=R;
    (* zweitens nach links *)
    R:=RMax;
    cnt:=0;
    while ((cnt=0) and (R>RMin)) do
      begin
        for G:=GMin to GMax do
          for B:=BMin to BMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then dec(R);
      end;
    RMax:=R;
    (* jetzt fuer gruen *)
    cnt:=0;
    G:=GMin;
    while ((cnt=0 ) and (G<GMax)) do
      begin
        for R:=RMin to RMax do
          for B:=BMin to BMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then inc(G);
      end;
    GMin:=G;
    cnt:=0;
    G:=GMax;
    while ((cnt=0) and (G>GMin)) do
      begin
        for R:=RMin to RMax do
          for B:=BMin to BMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then dec(G);
      end;
    GMax:=G;
    (* und jetzt blau *)
    cnt:=0;
    B:=BMin;
    while ((cnt=0 ) and (B<BMax)) do
      begin
        for R:=RMin to RMax do
          for G:=GMin to GMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then inc(B);
      end;
    BMin:=B;
    cnt:=0;
    B:=BMax;
    while ((cnt=0) and (B>BMin)) do
      begin
        for R:=RMin to RMax do
          for G:=GMin to GMax do cnt:=cnt+LokUp[R]^[G,B];
        if cnt=0 then dec(B);
      end;
    BMax:=B;
  end; (* reduce quader *)

  procedure RotTeilen(RMin,RMax,GMin,GMax,BMin,BMax: Integer; QuCnt : Longint; var Teil : Integer);
  var TmpCnt : Longint;
      R,G,B  : Integer;
  begin
    TmpCnt:=0;
    QuCnt :=QuCnt div 2;
    Teil:=pred(RMin);
    repeat
      inc(Teil);
      for G:=GMin to GMax do
        for B:=BMin to BMax do
          TmpCnt:=TmpCnt+LokUp[Teil]^[G,B];
    until ((TmpCnt>=QuCnt) or (Teil>=RMax));
    if Teil=RMax then Teil:=pred(RMax);
  end; (* rotteilen *)

  procedure GruenTeilen(RMin,RMax,GMin,GMax,BMin,BMax: Integer; QuCnt : Longint;  var Teil : Integer);
  var TmpCnt : Longint;
      R,G,B  : Integer;
  begin
    TmpCnt:=0;
    QuCnt :=QuCnt div 2;
    Teil:=pred(GMin);
    repeat
      inc(Teil);
      for R:=RMin to RMax do
        for B:=BMin to BMax do
          TmpCnt:=TmpCnt+LokUp[R]^[Teil,B];
    until ((TmpCnt>=QuCnt) or (Teil>=GMax));
    if Teil=GMax then Teil:=pred(GMax);
  end; (* gruenteilen *)

  procedure BlauTeilen(RMin,RMax,GMin,GMax,BMin,BMax: Integer; QuCnt : Longint;  var Teil : Integer);
  var TmpCnt : Longint;
      R,G,B  : Integer;
  begin
    TmpCnt:=0;
    QuCnt :=QuCnt div 2;
    Teil:=pred(BMin);
    repeat
      inc(Teil);
      for G:=GMin to GMax do
        for R:=RMin to RMax do
          TmpCnt:=TmpCnt+LokUp[R]^[G,Teil];
    until ((TmpCnt>=QuCnt) or (Teil=BMax));
    if Teil=BMax then Teil:=pred(BMax);
  end; (* blauteilen *)

  procedure DoDivide(ToCut: Integer);
  var tt,DR,Dg,db : Integer; (* laenge der r,g oder b achse *)
  begin
    (* hier die fallunterscheidung fuer teilen entlang der rot gruen oder blau *)
    (* achse. es muss die laengste geteilt werden *)
    DR:=Quader[ToCut].RMax-Quader[ToCut].RMin;
    Dg:=Quader[ToCut].GMax-Quader[ToCut].GMin;
    db:=Quader[ToCut].BMax-Quader[ToCut].BMin;
    inc(QuaCnt);
    if DR>Dg then
      begin
        if DR>=db then
          begin
            with Quader[ToCut] do RotTeilen(RMin,RMax,GMin,GMax,BMin,BMax,Qty,tt);
            Quader[QuaCnt]:=Quader[ToCut];
            Quader[QuaCnt].RMax:=tt;
            Quader[ToCut].RMin:=Succ(tt);
          end else begin
            with Quader[ToCut] do BlauTeilen(RMin,RMax,GMin,GMax,BMin,BMax,Qty,tt);
            Quader[QuaCnt]:=Quader[ToCut];
            Quader[QuaCnt].BMax:=tt;
            Quader[ToCut].BMin:=Succ(tt);
          end; (* else *)
      end  (* dr>dg *)
      else
      begin (* dr<dg *)
        if Dg>=db then
          begin
            with Quader[ToCut] do GruenTeilen(RMin,RMax,GMin,GMax,BMin,BMax,Qty,tt);
            Quader[QuaCnt]:=Quader[ToCut];
            Quader[QuaCnt].GMax:=tt;
            Quader[ToCut].GMin:=Succ(tt);
          end else begin
            with Quader[ToCut] do BlauTeilen(RMin,RMax,GMin,GMax,BMin,BMax,Qty,tt);
            Quader[QuaCnt]:=Quader[ToCut];
            Quader[QuaCnt].BMax:=tt;
            Quader[ToCut].BMin:=Succ(tt);
          end; (* else *)
      end;  (* dr<dg *)
  end; (* pro dodivide *)

  function FindBiggestQuader: Integer;
  var I,J : Integer;
      QQty : Longint;
  begin
    QQty:=0;
    J:=-1;
    for I:=0 to QuaCnt do
      if Quader[I].Qty>QQty then
        if Quader[I].Size>1 then
          begin
            QQty:=Quader[I].Qty;
            J:=I;
          end;
    FindBiggestQuader:=J;
    (* wenn j=-1 dann abbrechen da nur quader mit groesse 1 *)
  end; (* func findbiggest *)

var ToCut    : Integer;
    R1,G1,B1 : Word;
begin  (* newanalookup *)
  FillChar(Quader,SizeOf(Quader),0);
  QuaCnt:=0;
  Quader[0].RMin:=0;   Quader[0].RMax:=31;
  Quader[0].GMin:=0;   Quader[0].GMax:=31;
  Quader[0].BMin:=0;   Quader[0].BMax:=31;
  with Quader[0] do ReduceQuader(RMin,RMax,GMin,GMax,BMin,BMax);
  with Quader[0] do Size:=QuaderSize(RMin,RMax,GMin,GMax,BMin,BMax);
  with Quader[0] do Qty:=QuaderCount(RMin,RMax,GMin,GMax,BMin,BMax);
  ToCut:=FindBiggestQuader;
  while (QuaCnt<MaxCol) and (ToCut>-1) do  (* iterative median cutt *)
    begin
{$IFDEF DEBUG}
      Writeln(LST,'Quacnt : ',QuaCnt,'    ToCut : ',ToCut);
      with Quader[ToCut] do
        Writeln(LST,'MinMax ',ToCut:3,RMin:5,RMax:5,GMin:5,GMax:5,BMin:5,BMax:5,Size:10,Qty:10);
{$ENDIF}
      (* teilen , reduzieren und abspeichern *)
      DoDivide(ToCut);
      with Quader[QuaCnt] do ReduceQuader(RMin,RMax,GMin,GMax,BMin,BMax);
      with Quader[QuaCnt] do Size:=QuaderSize(RMin,RMax,GMin,GMax,BMin,BMax);
      with Quader[QuaCnt] do Qty :=QuaderCount(RMin,RMax,GMin,GMax,BMin,BMax);
      with Quader[ToCut]  do ReduceQuader(RMin,RMax,GMin,GMax,BMin,BMax);
      with Quader[ToCut]  do Size:=QuaderSize(RMin,RMax,GMin,GMax,BMin,BMax);
      with Quader[ToCut]  do Qty :=QuaderCount(RMin,RMax,GMin,GMax,BMin,BMax);(*qty-quader[quacnt].qty;*)
{$IFDEF DEBUG}
      with Quader[ToCut] do
        Writeln(LST,'MinMax ',ToCut:3,RMin:5,RMax:5,GMin:5,GMax:5,BMin:5,BMax:5,Size:10,Qty:10);
      with Quader[QuaCnt] do
        Writeln(LST,'MinMax ',QuaCnt:3,RMin:5,RMax:5,GMin:5,GMax:5,BMin:5,BMax:5,Size:10,Qty:10);
{$ENDIF}
      ToCut:=FindBiggestQuader;
    end; (* while colcnt *)
  New(Lookup);
  FillChar(Lookup^,SizeOf(Lookup^),255); (* loschen *)
  for ToCut:=0 to QuaCnt do
    begin
      with Quader[ToCut] do
        begin
          AverageColor(RMin,RMax,GMin,GMax,BMin,BMax,R,G,B);
{$IFDEF DEBUG}
          Write(LST,ToCut:5,':',RMin:5,RMax:5,GMin:5,GMax:5,BMin:5,BMax:5);
          Writeln(LST,'====>',R:10,G:10,B:10);
{$ENDIF}
        end;
      with Quader[ToCut] do
       for R1:=RMin to RMax do
         for G1:=GMin to GMax do
           for B1:=BMin to BMax do
             Lookup^[R1*32*32+G1*32+B1]:=ToCut;
      (* with quader[tocut] do setrgbpalette(tocut,r *2,g *2,b *2); *)
      Palette[ToCut].R:=Quader[ToCut].R*8;
      Palette[ToCut].G:=Quader[ToCut].G*8;
      Palette[ToCut].B:=Quader[ToCut].B*8;
    end; (* for tocut *)
  for I:=0 to 31 do Dispose(LokUp[I]); (* frees the heap *)
  for R1:=0 to 32767 do  (* costs a lot of time *)
    if Lookup^[R1]=255 then Lookup^[R1]:=MedCutGetColor(R1);
{$IFDEF DEBUG}
  Write(LST,^L);
{$ENDIF}
end; (* new analookup *)

function Convert24to15(R,G,B : Integer): Integer;
begin
  Convert24to15:= (  ((R and $F8) shl (10-3) )
         or((G and $F8) shl (5-3) )
         or((B and $f8) shr 3 ) )
end;

function Convert24To15Li(R,G,B : Longint): Integer;
begin
  Convert24To15Li:= (  ((R and $F8) shl (10-3) )
         or((G and $F8) shl (5-3) )
         or((B and $f8) shr 3 ) )
end;

procedure InitMedCut( Mc : Integer);
begin
  for I:=0 to 31 do New(LokUp[I]);
  for i1:=0 to 31 do
    for I2:=0 to 31 do
      for i3:=0 to 31 do
        LokUp[i1]^[I2,i3]:=0;
  if Mc>=255 then Mc:=254; (* da 255 als unbesetzt wert verwendet wird *)
  MaxCol:=Mc;
  (*new(lookup); jetzt in analookup da erst nach quader notwendig *)
end; (* initmedcut *)

procedure KillMedCut;
begin
  (* for i:=0 to 31 do dispose(lokup[i]); wird in analookup erledigt nach analyse *)
  Dispose(Lookup);
end; (* initmedcut *)


procedure Sample;
  (* Leere Routinen mssen je nach Anwendung gefllt werden *)
  procedure OpenGrafFile(fn : string);
    (* ffnet grafikdatei , liest und interpretiert Header Daten *)
  begin end;
  procedure GetGrafPixel(X,Y : Integer; var R,G,B : Byte );
    (* liest die R G B Werte an der Position X , Y aus *)
  begin end;
  procedure CloseGrafFile;
  begin end;

var Gd,Gm,
    X,Y,C : Integer;
    R,G,B : Byte;
    Breite,
    Laenge : Integer;
begin
  (* grafic datei ffnen *)
  OpenGrafFile('BILD.TGA');
  InitMedCut(255); (* hier die maximale Anzahl der Palettenfarben *)
  for X:=1 to Breite do
    for Y:=1 to Laenge do
      begin
        GetGrafPixel(X,Y,R,G,B);
        DoLookup24(R,G,B);
        (* falls die daten als 15 bit HiColor vorliegen dann DoLookup16 *)
      end;
  NewAnaLookup; (* auswerten *)
  (* Neue Datei erzeugen , oder anzeigen *)
  DetectGraph(Gd,Gm);
  InitGraph(Gd,Gm,'');
  for C:=0 to 255 do (* palette setzen  / set VGA palette *)
    SetRGBPalette(C,Palette[C].R div 4,  (* div 4 da VGA nur mit 6 bit Arbeitet *)
                    Palette[C].G div 4,
                    Palette[C].B div 4);
  (* Einlesen und in Palettenfarben ummappen *)
  (* Read Imagefile and Output remapped to Datafile *)
  for X:=1 to Breite do
    for Y:=1 to Laenge do
      begin
        GetGrafPixel(X,Y,R,G,B);
        PutPixel(X,Y,Lookup^[Convert24to15(R,G,B)]);
      end;
  KillMedCut;
  CloseGraph;
  CloseGrafFile;
end;

end. (* median cut *)



