;-----------------------------------------------------------------------------
;       SOME PANNING ROUTINES!
;
;       Greets to Draeden/VLA for the SUPERB mode-X library
;
;       The rest (not much, by the way! :-)) written by BYTE KNiGHT
;       on a day of learning this myself... 06.02.95
;
;       I wrote this thing to help others in the same situation as
;       myself.. Just getting in to X-mode and *NOTHING* is right anymore..
;       The pixels doesn't LOOK right.. AT ALL!
;       Suddenly you realize:  The good-ol' linear-mode is G O N E !
;       I must set the BIT-PLANES!! What's THAT!! WHAT do I do??
;       HOW do I do it?? HELP!! HELP!! Yeah....Whatever.....
;       Hope this thing will clearify things a bit....
;       It did for me! :-)
;
;-----------------------------------------------------------------------------

        IDEAL
        DOSSEG
        model small
        stack 200h
        codeseg
        p386
        assume cs:@code,ds:@code

;-----------------------------------------------------------------------------

START:  jmp     begin

include "modex.inc"

offs    dw      00                      ; The offset of wich the VISUAL
                                        ; page starts..

        Global  sky : byte,skypal : BYTE
;----------------------------------------------------------------------------

BEGIN:  @SetModeX m320x200x256, 800     ; Want 800 pixel 'virtual widt'
                                        ; wich means that the screen is
                                        ; 800 pixels wide, while the VISUAL
                                        ; screen is 320.. Make any sense?

                                        ; Set the palette, using BIOS
        push    es
        push    cs
        pop     es
        mov     ax,1012h
        mov     bx,0
        mov     cx,256
        mov     dx,offset skypal        ; The palette, external OBJ
        int     10h
        pop     es


        push    cs                      ; Code and Data are the same..
        pop     ds

        push    0A000h                  ; Videomem segment
        pop     es

        mov     si,offset sky           ; The NICE backgrnd piccy, ext OBJ..
        mov     di,0

        mov     dx,3c4h                 ; Sequencer port, for choosing
                                        ; wich plane to write to

major:  mov     cx,80                   ; Because 320/4(planes)=80
loop1:
        mov     al,02
        mov     ah,0001b                ; Plane 1...
        out     dx,ax                   ; GO!

        lodsb                           ; Load image byte....
        mov     [es:di],al              ; store it...

        mov     al,02
        mov     ah,0010b                ; Plane 2...
        out     dx,ax

        lodsb                           ; Etc...
        mov     [es:di],al

        mov     al,02
        mov     ah,0100b
        out     dx,ax

        lodsb
        mov     [es:di],al

        mov     al,02
        mov     ah,1000b
        out     dx,ax

        lodsb
        mov     [es:di],al

        inc     di
        loop    loop1

        add     di,(800-320)/4          ; We want the whole picture in one page
        cmp     si,64000                ; Check if whole image has been drawn
        jb      major                   ; NOT?? OK, keep going...


        mov     ah,0                    ; Hit any key to continue...
        int     16h


; The actual PANNING starts here..

op2:    mov     bx,[cs:offs]            ; Where to start the visual page
        inc     [cs:offs]               ; Increase it, to move right...
        @FullVertWait                   ; Wait for retrace
        @set_start_offset               ; HIT IT!! Set visual page starting
                                        ; at offset BX..

        cmp     [cs:offs],800-320       ; Did we hit the right limit??
        jae     op3                     ; NOPE! go back and continue..

        mov     ah,1                    ; Has a key been hit?
        int     16h
        jz      op2                     ; If not, keep going
op3:
        mov     ah,0                    ; Flush keyboard buffer
        int     16h

        mov     ax,0003h                ; Back to textmode..
        int     10h

        mov     ax,4c00h
        int     21h                    ; And to DOS.. (Sigh..)

END START

