/****************************************************************************\
*                                                                            *
*  MOUSE256.C                                                                *
*                                                                            *
*  This example program shows how to create a multi-colored mouse cursor     *
*  with Fastgraph in 256-color XVGA and SVGA graphics modes.  The program    *
*  calls an assembly language function SETMOUSE (in the file SETMOUSE.ASM)   *
*  that stores the mouse cursor screen and cursor masks in Fastgraph's       *
*  internal data area.                                                       *
*                                                                            *
*  The mouse_masks array is a 16x16 grid containing alternating screen and   *
*  cursor mask values for each pixel in the mouse cursor.  The values are    *
*  arranged as 16 rows (from top to bottom), each containing mask values for *
*  16 pixels (from left to right).  Passing this array to SETMOUSE changes   *
*  the mouse cursor.  Refer to Chapter 14 in the Fastgraph User's Guide for  *
*  more detailed information about the mouse cursor screen and cursor masks. *
*                                                                            *
*  When calling SETMOUSE, the mouse cursor must be INVISIBLE.                *
*                                                                            *
*  Copyright (c) 1993 Ted Gruber Software.  All rights reserved.             *
*                                                                            *
\****************************************************************************/

#include <fastgraf.h>

unsigned char far mouse_masks[] =
{
   255,  0,  0,  9,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0,  9,255,  0,255,  0,255,  0,255,  0,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0,  9,255,  0,255,  0,255,  0,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0,  9,255,  0,255,  0,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0,  9,255,  0,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,  0,  9,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,
     0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,
     0, 14,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,
     0, 14,  0, 14,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0, 14,  0, 14,  0, 14,  0,  9,
     0,  9,  0,  9,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0, 14,  0,  9,  0, 14,  0, 14,  0,  9,
   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0, 14,  0,  9,255,  0,  0,  9,  0, 14,  0, 14,
     0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,  0,  9,  0,  9,255,  0,255,  0,  0,  9,  0, 14,  0, 14,
     0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,  0,  9,  0, 14,
     0, 14,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,  0,  9,  0, 14,
     0, 14,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,

   255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0,  0,  9,
     0,  9,  0,  9,255,  0,255,  0,255,  0,255,  0,255,  0,255,  0
};

main()
{
   /* initialize Fastgraph for mode 20 */

   fg_setmode(20);

   /* show the default mouse cursor against a white background */

   fg_mouseini();
   fg_setcolor(15);
   fg_fillpage();
   fg_mousevis(1);
   fg_waitkey();

   /* change the cursor outline to light blue (color 9), */
   /* and pixels inside the cursor to yellow (color 14)  */

   fg_mousevis(0);
   setmouse(mouse_masks);
   fg_mousevis(1);
   fg_waitkey();

   /* restore 80x25 text mode */

   fg_mousefin();
   fg_setmode(3);
   fg_reset();
}
