;*****************************************************************************
;
; SETMOUSE.ASM
;
; Copyright (c) 1993 Ted Gruber Software.  All rights reserved.
;
; This source code is free for use in Fastgraph applications.
;
; Assemble with
;
;    MASM /MX /T SETMOUSE;
; or TASM /MX /T SETMOUSE
;
; then link SETMOUSE.OBJ with your Fastgraph application.
;
; Prototype
;
;    void setmouse (unsigned char far *masks);
;
; Description
;
;    Define the internal screen and cursor masks for the mouse driver in
;    XVGA and SVGA 256-color graphics modes.
;
; Parameters
;
;    masks        A 512-byte array of alternating screen and cursor mask
;                 values in expanded format.
;
; Return value
;
;    none
;
; Restrictions
;
;    This routine is only meaningful in modes 20 to 27.
;
;*****************************************************************************

          EXTRN   VGApairs:word

;arg1     equ     [bp+4]        ; for small memory model
arg1      equ     [bp+6]        ; for medium and large memory model

_TEXT     SEGMENT byte public 'CODE'
_setmouse PROC    far
          PUBLIC  _setmouse

          push    bp            ; save caller's BP register
          mov     bp,sp         ; make BP point to argument list
          push    si            ; save caller's SI register
          push    di            ; save caller's DI register
          cld                   ; set the direction flag to forward

          push    ds
          pop     es            ; point ES to the data segment
          lea     di,VGApairs   ; ES:DI = address of VGApairs array
          lds     si,[bp+6]     ; DS:SI = address of masks parameter
          mov     cx,256        ; size of VGApairs array in words
          rep     movsw         ; copy masks array into the VGApairs array
          push    es
          pop     ds            ; restore caller's default data segment

          xor     ax,ax         ; in case setmouse was called as a function
          pop     di            ; restore caller's DI register
          pop     si            ; restore caller's SI register
          pop     bp            ; restore caller's BP register
          ret                   ; return to the caller

_setmouse ENDP
_TEXT     ENDS
          END
