/*--------------------------------------------------------------------------*/
/* Palette.C - VGA mode13h palette manipulation - 16/7/96 - Stephen Wilson. */
/*--------------------------------------------------------------------------*/
/* Version 1.0 - Having finally made some sense of the VGA palette, I am    */
/*               writing this small demo program to show the basics of      */
/*               manipulating the palette.                                  */
/*                                                                          */
/*               The program shows a couple of simple fades, and some easy  */
/*               colour scrolling.                                          */
/*--------------------------------------------------------------------------*/
/* Things that need doing.                                                  */
/* -----------------------                                                  */
/* Some sort of detection routine to check that there actually is a VGA     */
/* card installed might be a good idea.                                     */
/* Choice of color scroll direction - perhaps pass a value to the function  */
/* that does the colour scrolling telling it which direction to scroll.     */
/* Add a routine to vary the palette every so often - perhaps have it go    */
/* from being all blue - to all red, to all green or something.             */
/*--------------------------------------------------------------------------*/
/* On the off chance that anyone does see this - and you want to contact me */
/* for any reason - you may get me at:                                      */
/*                                                                          */
/* Up until September 1996 : E-mail S.Wilson@pascal.dra.hmg.gb              */
/*                                                                          */
/* After that - I go back to university - and I don't have a clue what my   */
/* e-mail address will be. - Try looking at Andy's graphics page:           */
/*                                                                          */
/*         http://www.osha.igs.net/~dandelong/graphics.htm                  */
/*                                                                          */
/* I'll try to keep him informed of where I am.                             */
/*                                                                          */
/* Of course - you can always catch me by good old snail mail at:           */
/*                                                                          */
/*  Stephen Wilson,                                                         */
/*  12 The Fellway,                                                         */
/*  West Denton,                                                            */
/*  Newcastle upon Tyne.                                                    */
/*  ME5 5BY.                                                                */
/*  UK.                                                                     */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* Include files.                                                           */
/*--------------------------------------------------------------------------*/
#include<conio.h>              /* needed for inp() and outp()               */
#include<dos.h>                /* needed for pokeb()                        */
#include<bios.h>               /* needed for bioskey()                      */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* Global variables.                                                        */
/*--------------------------------------------------------------------------*/
/* None needed.                                                             */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* Function declarations.                                                   */
/*--------------------------------------------------------------------------*/
void SetGFXMode(int mode);

void ReadPalette(unsigned char * Red, unsigned char * Green,
		 unsigned char * Blue);

void WritePalette(unsigned char * Red, unsigned char * Green,
		  unsigned char * Blue);

void WaitVR(void);

void SwitchPalette(unsigned char * FromRed, unsigned char * FromGreen,
		   unsigned char * FromBlue, unsigned char * ToRed,
		   unsigned char * ToGreen, unsigned char * ToBlue);

void ColourCycle(unsigned char * Red, unsigned char * Green,
		 unsigned char * Blue);
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* main() function.                                                         */
/*--------------------------------------------------------------------------*/
int main()
{
  unsigned char Black[256];
  unsigned char Red[256];
  unsigned char Green[256];
  unsigned char Blue[256];
  int a, b, c, d, count;


  SetGFXMode(0x0013);                   /* set the video mode to 13h VGA.   */

  for(count=0;count<=255;count++)       /* set the entire palette to black, */
    Black[count]=0;                     /* if we don't do this - it looks   */
					/* messy when we set the grid up on */
  WritePalette(Black, Black, Black);    /* the screen - uncomment to see.   */

  for(d=0;d<=15;d++)                    /* this sets the grid pattern up on */
    for(c=0;c<=15;c++)                  /* the screen - it took me an age   */
      for(b=0;b<=2;b++)                 /* to work it out - basically there */
	for(a=0;a<=5;a++)               /* is 1 pattern, reflected in x&y.  */
	{
	  pokeb(0xA000, (a+(d*5))+((199-((b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160+a+(d*5))+((199-((b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (a+(d*5))+((199-((100+b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160+a+(d*5))+((199-((100+b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );

	  pokeb(0xA000, (160-(a+(d*5)))+((199-((b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (320-(a+(d*5)))+((199-((b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160-(a+(d*5)))+((199-((100+b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (320-(a+(d*5)))+((199-((100+b+4)+(c*3)))*320), (((c/2)+1)*((d/2)+1))-1 );

	  pokeb(0xA000, (a+(d*5))+((199-(100- ((b+4)+(c*3)) ) )*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160+a+(d*5))+((199-(100- ((b+4)+(c*3)) ) )*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (a+(d*5))+((199-(200- ((b+4)+(c*3)) ) )*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160+a+(d*5))+((199-(200- ((b+4)+(c*3)) ) )*320), (((c/2)+1)*((d/2)+1))-1 );

	  pokeb(0xA000, (160-(a+(d*5)))+((199-(100-((b+4)+(c*3))))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (320-(a+(d*5)))+((199-(100-((b+4)+(c*3))))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (160-(a+(d*5)))+((199-(200-((b+4)+(c*3))))*320), (((c/2)+1)*((d/2)+1))-1 );
	  pokeb(0xA000, (320-(a+(d*5)))+((199-(200-((b+4)+(c*3))))*320), (((c/2)+1)*((d/2)+1))-1 );
	}

  for(a=0;a<=63;a++)            /* This sets up the colour gradient in the  */
  {                             /* palette - I have set it so it goes from  */
    Red[a]=0;                   /* black - to all blue - to white, and back */
    Red[a+64]=a;                /* down again. - some interesting results   */
    Red[a+128]=(63-a);          /* can be made with messing about with the  */
    Red[a+192]=0;               /* colour scheme (and some absolutely       */
    Green[a]=0;                 /* disgusting ones too! ;D)                 */
    Green[a+64]=a;              /*                                          */
    Green[a+128]=(63-a);        /*                                          */
    Green[a+192]=0;             /* 					    */
    Blue[a]=a;                  /* 	                        	    */
	 Blue[a+64]=63;              /* 					    */
    Blue[a+128]=63;             /* 					    */
    Blue[a+192]=(63-a);         /* 					    */
  }                             /* 					    */


  SwitchPalette(Black,Black,Black,Red,Green,Blue);
  /* this fades our palette in - from a black screen. */

  ColourCycle(Red,Green,Blue);
  /* this colour scrolls the palette to make the colours change. */

  SwitchPalette(Red,Green,Blue,Black,Black,Black);
  /* this fades the palette back out to black from whatever it is. */

  SetGFXMode(0x0003);  /* this sets the GFX card back into text mode. */

  return(0);
}
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* Self defined functions.                                                  */
/*--------------------------------------------------------------------------*/
void SetGFXMode(int mode)
{
  asm{
       mov AX,mode
       int 10H
     }

}


void ReadPalette(unsigned char * Red,unsigned char * Green,unsigned char * Blue)
{
  int count=0;

  for(count=0;count<=255;count++)    /* for each palette element     */
  {
    outp(0x3C7,count);  	     /* tell which element to view   */

    Red[count]=inp(0x3C9);           /* read RED value               */
    Green[count]=inp(0x3C9);         /* read GREEN value             */
    Blue[count]=inp(0x3C9);          /* read BLUE value              */
  }
}


void WritePalette(unsigned char * Red,unsigned char * Green,unsigned char * Blue)
{
  int count=0;

  for(count=0;count<=255;count++)    /* for each palette element     */
  {
    outp(0x3C8,count);               /* tell which element to view   */

    outp(0x3C9,Red[count]);          /* write RED value to palette   */
    outp(0x3C9,Green[count]);        /* write GREEN value to palette */
    outp(0x3C9,Blue[count]);         /* write BLUE value to palette  */
  }
}


void WaitVR(void)             /* This routine pauses the execution of the   */
{                             /* program until the vertical retrace on the  */
  asm {                       /* monitor begins. The vertical retrace is    */
	mov dx,0x03DA         /* the time it takes for the monitor to move  */
      }                       /* the beam it uses to update the screen from */
	t1: asm {             /* the bottom right corner back to the top    */
	   in  al, dx         /* left corner ready for the next update scan.*/
	   and al, 0x08       /* By writing to the screen while the retrace */
	   jz t1              /* is happening - your new image is displayed */
		}             /* entirely - it doesn't get displayed mid    */
	t2: asm {             /* scan. This makes animation and stuff look  */
	   in  al, dx         /* smoother, and stops "static" appearing on  */
	   and al, 0x08       /* screen whilst altering the palette.        */
		jz t2              /* Of course - because you are synchronising  */
		}             /* execution of the program to the monitor    */
}                             /* it can slow the code down slightly.        */


void SwitchPalette(unsigned char * FromRed,unsigned char * FromGreen,
		   unsigned char * FromBlue, unsigned char * ToRed,
		   unsigned char * ToGreen,unsigned char * ToBlue)
{
  unsigned char tempRed[256];           /* set up some arrays that we can   */
  unsigned char tempGreen[256];         /* alter without affecting anything */
  unsigned char tempBlue[256];          /* in the main program.             */
  int exit_flag, count;

  for(count=0;count<=255;count++)       /* Set the temp values so that they */
  {                                     /* are the same as the values we    */
    tempRed[count]=FromRed[count];      /* want to move the palette from.   */
    tempGreen[count]=FromGreen[count];  /* We are going to use these temp   */
    tempBlue[count]=FromBlue[count];    /* values to carry out the switch   */
  }                                     /* so they need set for the start.  */

  WaitVR();                                  /* set the palette so it uses  */
  WritePalette(tempRed,tempGreen,tempBlue);  /* the From colour scheme.     */

  while(exit_flag!=0)   /* as long as something has changed - keep going. */
  {
	 exit_flag=0;                         /* reset the loop control          */
    for(count=0;count<=255;count++)      /* for each colour in the palette. */
    {
      if(tempRed[count]!=ToRed[count])   /* if To and From aren't the same. */
      {
	if((tempRed[count])<(ToRed[count]))  /* if From is more than To.    */
	{
	  tempRed[count]=(tempRed[count]+1); /* increase the From(temp) val.*/
	  exit_flag=1;
	}
	else
	{
	  tempRed[count]=(tempRed[count]-1); /* decrease the From(temp) val.*/
	  exit_flag=1;
	}
      }

      if(tempGreen[count]!=ToGreen[count])
      {
	if((tempGreen[count])<(ToRed[count]))
	{
	  tempGreen[count]=(tempGreen[count]+1);
	  exit_flag=1;
	}
	else
	{
	  tempGreen[count]=(tempGreen[count]-1);
	  exit_flag=1;
	}
      }

      if(tempBlue[count]!=ToBlue[count])
      {
	if((tempBlue[count])<(ToBlue[count]))
	{
	  tempBlue[count]=(tempBlue[count]+1);
	  exit_flag=1;
	}
	else
	{
	  tempBlue[count]=(tempBlue[count]-1);
	  exit_flag=1;
	}
      }
    }

    WaitVR();
    WritePalette(tempRed,tempGreen,tempBlue); /* set palette to new values. */
  }
}

void ColourCycle(unsigned char * Red,unsigned char * Green,unsigned char * Blue)
{
  unsigned char tempRed, tempGreen, tempBlue;
  int count;

  do
  {
    for(count=0;count<=255;count++)    /* for each colour in the palette    */
    {
      if(count==0)                     /* if it is the first element        */
      {
	tempRed=Red[count];            /* store current val in temp val.    */
	Red[count]=Red[count+1];       /* copy next val into current one.   */
	tempGreen=Green[count];
	Green[count]=Green[count+1];
	tempBlue=Blue[count];
	Blue[count]=Blue[count+1];
      }
      else
      {
	if(count==255)                 /* if it is the last element.        */
	{
	  Red[count]=tempRed;          /* copy temp val into current one    */
	  Green[count]=tempGreen;
	  Blue[count]=tempBlue;
	}
	else                           /* if not first or last.             */
	{
	  Red[count]=Red[count+1];     /* copy next val into current one.   */
	  Green[count]=Green[count+1];
	  Blue[count]=Blue[count+1];
	}
      }
    }
    WaitVR();
    WritePalette(Red, Green, Blue);    /* write changes to palette.         */
  }
  while(bioskey(1)==0);                /* until a key is pressed.           */

}
/*--------------------------------------------------------------------------*/

