// 	palette.h
//	Author: Karl Lager
//	blend, map, and set 256 color palettes
//	public domain
//

	// load palette
	// Load a palette from a pcx file
	// Returns 0 on success, -1 on error (file not found)
	// On premature end of file, returns #of bytes not read.
	// Preconditions: *pal must point to a allocated block of 768 bytes
	//                filename is the name of a 256 color pcx file or
	//                a 768 byte palette file.
int loadpcxpalette( char *filename, char *palette );

	// reduce palette
	// Converts a 3x8bit x256color palette to a 3x6bit x256 color VGA
	// 	palette (256 color levels -> 64 color levels)
	// Preconditions: *pal must point to a 768 byte palette.
	//
void reducepalette( unsigned char *pal );

	// set chroma key
	// Initialize the blend palette with a user specified color as
	//	the transparent color.
	// Preconditions: r,g, and b are in the range 0-255
void chromakey( int r, int g, int b );

	// blend palette
	// Blends a palette with a weighted palette (can be 24 bit x 256 color
	// 	or 3x6 bit by 256 color palette.
	// Blend palette is initialized by sending it a NULL pointer.
	// or by calling the chromakey function.
	// Preconditions: *pal points to a 768 byte palette or NULL
	// Postconditions: blend palette is stored and ready to
	//                 blend in the next palette.
void blendpalette( char *pal );

	// get blend palette
	// Return the palette created by blendpalette.
	// Preconditions: *pal points to an allocated block of 768 bytes.
	//                At least one palette has been put in blendpalette.
void get_blendpal( char *pal );

	// map palette:
	// Creates an index array which map image uses to convert a BGI
	// 	bitmap from its original palette to the blend palette.
	// Preconditions: pal and blendpal point to 768 byte palettes.
void mappalette( unsigned char *pal, unsigned char *blendpal );

	// map palette - transparent
	// same as map palette, but don't map dark greys to 0
void mappalette_t( unsigned char *pal, unsigned char *blendpal );

	// map image
	// Convert a bitmap from its original palette to the blend palette.
	// Preconditions: palette index was previously set by mappalette
	//                or mappalette_t, *pal was the original palette
	//                for the bitmap *p
void mapimage( void *p );

	// get palette
	// copy the current 256 color palette from the VGA card.
	// Preconditions: *pal must point to a allocated block of 768 bytes.
void getpalette( char *pal );

	// set palette
	// load a 256 color palette into the VGA card.
	// Preconditions: *pal has been reduced to 64 color levels.
void setpalette( char *pal );

//********************************************************

// load pcx file (for testing purposes)
// Preconditions: filename is the name of a 256 color PCX file
// on success, returns a bgi bitmap
// on failure, returns NULL

void *loadpcx( char *filename );