TITLE - Panning.ASM
;
; Her kommer frste eksempel i direkte EGA/VGA programmering for de som 
; har tenkt  lre EGA/VGA programmering. 
;
; 
;  ***   Pixel Panning DEMO:  ***
; 
;  Programmet viser hvordan man skriver og manipulerer data direkte til
;  EGA/VGA registre. Bruk venstre/hyre piltastene til  PANNE, avsluttes
;  ved  trykke <ESC>

;  Programmet er delvis kommentert, men det skulle ikke vre s vanskelig
;   skjnne resten. Legg merke til at teksten 'Hopper' nr det er gtt
;  8 pixels (begge veier). Prv gjerne  fikse det og gjerne kom med
;  tilbakemelding om en forbedret versjon. Jeg er  treffe p
;  PROGRAMMER'S BBS 


ATTRIBUTE_REG           equ         3C0h
CRT_REG                 equ         3D4h
CRT_offset_reg          equ         13h
CRT_start_addr_lo       equ         0Dh
BIOS_column             equ         44Ah
INPUT_STATUS_1          equ         3DAh
TAB         equ         15 dup(20h)

data        segment

text        db          'Eksempel p PIXEL PANNING ',10,13,10,13
	db          TAB,'Smooth panning achieved by direct manipulation',10,13 
	db          TAB,'of the EGA/VGA Registers - ',10,13,10,13
	db          TAB,'Avsluttes med <ESC> ........$'

newcolumn   dw          100         ;ny strrelse p displayet (bredden)
x_coord     dw          0       ;x_offset for panning 
data        ends

sseg        segment stack
	dw          64          dup(?)
sseg        ends

code        segment
Main        proc        far
	assume      cs:code,ds:data,ss:sseg
	push        ds
	sub         ax,ax
	push        ax
	mov         ax,data
	mov         ds,ax
	
	mov         ax,03h      ;bios set mode her mode 3
	int         10h                     ;prv gjerne andre mode ogs

	call        Set_column      ;forandre displayets bredde
		

	mov         ah,02
	mov         bh,0
	mov         dh,8
	mov         dl,20
	int         10h

	lea         dx,text         ;skriv ut tekst p skjermen
	mov         ah,9
	int         21h
LP1:
	mov         ah,0
	int         16h
	cmp         al,1bh
	je          exit
	cmp         al,0
	jne         LP1
	cmp         ah,4bh
	je          move_right
	cmp         ah,4dh
	je          move_left
	jmp         LP1

move_left:
	cmp         x_coord,0
	je          reset
	dec         x_coord
	call        panning
	cmp         x_coord,0
	je          reset
	jmp         LP1
reset:
	mov         x_coord,0
	jmp         LP1

move_right:
	inc         x_coord
	call        panning
	cmp         x_coord,799
	je          reset2
	jmp         LP1
reset2:
	mov         x_coord,799
	jmp         LP1


exit:
	mov         ax,03
	int         10h
	ret
Main        endp

Set_column  proc
	xor         ax,ax
	mov         es,ax
	mov         dx,CRT_REG              ;CRT address reg
	mov         al,CRT_offset_reg
	out         dx,al                   ;velg CRT offset reg
	inc         dx                      ;CRT data reg

	mov         ax,[newcolumn]          ;hent ny skjermbredde
	mov         es:[BIOS_column],ax     ;la BIOS vite om det
	SHR         AL,1                    ;dele p 2 for offset reg
	out         dx,al                   ;Sett offset reg
	ret
Set_column  endp

Panning     proc        
	mov         dx,INPUT_STATUS_1
	
Vrt1:       
	in          al,dx
	test        al,8                    ;test for Vertical retrace
	jz          Vrt1

Vrt2:
	in          al,dx                   ;vent p vertical
	test        al,8                    ;retrace slutt
	jnz         Vrt2



	mov         bx,x_coord
	shr         bx,1
	shr         bx,1
	shr         bx,1
	mov         dx,CRT_REG
	mov         al,CRT_start_addr_lo          
	out         dx,al
	inc         dx
	mov         al,bl                   ;hent panning verdien
	out         dx,al                   ;og skriv til CRT



	mov         dx,INPUT_STATUS_1
Vrt3:
	in          al,dx                   ;vent p vertical retrace
				;
	test        al,8
	jz          Vrt3

	mov         dx,ATTRIBUTE_REG
	mov         al,33h                  ;palette addr source=1
				;reg addr=13h
	out         dx,al
	mov         ax,x_coord              ;hent offset
	and         al,7                    ;tar bare 3 bits (LSB)
	out         dx,al                   ;set PANNING register
	ret
Panning     endp


code        ends
	end         Main

