/*  PCX loading and displaying program, written by Andrew Delong.
    This isn't copyright or anything.
    Do whatever you want with it, the code sucks.

    dandelong@osha.igs.net  (Dec 29/96)
*/

#include <alloc.h>
#include <stdio.h>
#include <mem.h>
#include <conio.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>

#include "pcx.h"

#define null 0
#define BUFSIZE 512


//a direct pointer to video memory
char far *screenptr=(char far*)MK_FP(0xA000,0x0000);

//                       getPCXHead()
//Loads the data for a PCX header and loads palette if it exists
//returns 0 if the pcx is valid, or 1 if not
int getPCXHead(int fh,struct PCXi *pcx) {
  char c;
  int i;
  lseek(fh,0L,SEEK_SET); //seek to START of file to read header
  read(fh,&pcx->head,sizeof(struct PCXHead));

//if it is the PCX id # (0x0A) then  load the info
  if(pcx->head.id!=0x0A)
    return(1);

  lseek(fh,-769L,SEEK_END);//go to the END of the file -(256*3+1) bytes
  read(fh,&c,1);
  if(c==(char)12) {//12 means a 256c palette appended to end of file

    for(i=0;i<768;i++) {//load each byte into the palette
			 //and we have to shift each palette value >> 2
      read(fh,&c,1);
      pcx->palette[i]=c>>2;
    }
  }
  return(0);
}

//                         loadPCX()
//returns 0 if successfull, otherwise 1
//loads a pcx format image file and stores the data into 'img'

//NOTE: because we load the PCX into an `Image' file we do not use
//the `data' member of the PCX structure,
//FIX: can't load pcx files with more than 64k of image data! (try huge ptrs)
int loadPCX(char *filename,struct Image *img) {

  struct PCXi pcx;//for loading pcx

//this buffer is used to speed up disk reading, I saw this done
//from a book called "Flights of Fantasy" by Christopher Lampton
//((c)Waite Group Press)
  unsigned char readBuffer[BUFSIZE];

  unsigned int offset=0,     //-current offset for storing data
	       readOffset=0, //-current offset in read buffer
	       readlength=0, //-# of bytes read by the 'read()' function

	       count,        //-count byte, total repeats for current pixel
	       colour,       //-used if repeat, otherwise stores 'count'
//			        since its got the colour initially
	       k;            //-loop variable (0 to count)

  unsigned long totalBytes;//width*height, total pixel values to read

  int fh=open(filename,O_BINARY);
  if(fh==-1)    //uh oh, if error opening file, return error
    return(1);

//if error loading header (not pcx type file for instance) return error
  if(getPCXHead(fh,&pcx)) {
    close(fh);
    return(1);
  }

//add 1 since these are coords
  img->width = pcx.head.x2 - pcx.head.x1 + 1;
  img->height = pcx.head.y2 - pcx.head.y1 + 1;

//allocate mem to load the pcx data
  totalBytes=img->width*img->height;
  img->data=(char far*)farmalloc(totalBytes);
  if(!img->data)
    return(1);

//copy the pcx palette data to 'img' palette data
  _fmemcpy(img->palette,pcx.palette,256*3);

  //seek to start of image data and start reading ...
  lseek(fh,128L,SEEK_SET);

//while we have not read all the pixels in the image (width*height pixels)
  while(offset<totalBytes)
  {
    if(readOffset>=readlength) {//check to see if we need to read data
				//into our buffer
      readOffset=0;
      readlength=read(fh,readBuffer,BUFSIZE);//read data into the buff
      if(readlength==0) {  //if DOS returned no data read then return
	close(fh);
	return(1);
      }
    }

    count=readBuffer[readOffset++];

//if the current read value is > 192 then it is a repeat count
//so we have to put 'count' bytes of the next byte into
//our final data for the image
    if(count>192) {
      count-=192;

      //but since we are about to get another byte, check for disk read
      if(readOffset>=readlength) {
	readOffset=0;
	readlength=read(fh,readBuffer,BUFSIZE);
	if(readlength==0) {
	  close(fh);
	  return(1);
	}
      }

      colour=readBuffer[readOffset++];//get colour value from NEXT byte

      for(k=0;k<count;k++) //repeat the colour
	img->data[offset++]=colour;

    }
//if it wasn't a repeat count, then just put it into our image
    else
      img->data[offset++]=count;
  }
  close(fh);
  return(0);//no error, return 0
}

//                          putImage()
//puts the image from 'img' onto the screen, upper left corner at ('x','y')
void putImage(int x,int y,struct Image *img) {
  int i;
  char far *source=img->data;
  char far *dest=(char far*)(x+y*320+(long)screenptr);

//for each line in the image ...
  for(i=0;i<img->height;i++) {
    _fmemcpy(dest,source,img->width);//copy a strip of data onto the screen
    dest+=320;                      //move to start of next strip on both
    source+=img->width;             //the screen and the image buffer
  }
}

//sets the palette to the 256 R:G:B values in 'palreg' (must be 768 bytes long)
void set256Palette(char far *palreg) {
  asm {
    push es        //save es register
    mov   ah,10h     // function 10h
    mov   al,12h     //subfuntcion 12h (set pal regs)
    mov   bx,0       // from VGA palette register 0
    mov   cx,256     // change all 256 registers
    les   dx,palreg  // (es:dx) points to our colour regs
    int   10h
    pop es          //restore es register
  }
}

//calls bios to set the video mode # 'mode'
void setMode(short mode) {
  asm {
    mov ax,[mode]
    int 10h
  }
}

//exits the program with a message (can be error message)
void exitprog(char *msg) {
  printf(msg);
  exit(0);
}



/////////        MAIN

//get argument from command line
void main(int argc,char *argv[])
{
  struct Image img;

//make sure user passed a filename
  if(argc!=2) {
    exitprog("Usage: pcxview <filename.pcx>\n");
  }

//inform what file we recieved as a parameter (no need to do this tho) ...
  printf("loading %s ...\n",argv[1]);

//if error then don't display the pcx, exit
  if(loadPCX(argv[1],&img))
    exitprog("Error loading PCX");

  setMode(0x13);  //mode 320x200x256 VGA

  set256Palette(img.palette);//set the palette AFTER going to VGA mode

  putImage(0,0,&img);//display at top left corner of screen

  getch();//wait for a key press

  setMode(0x03);   //restore 80x25x16 text mode

  farfree(img.data); //free the data for the heck of it

  exitprog("Exiting without error");
}




