; Assembler portion of Height Mapping test
; Started: 06/05/96
; Module: HTASM.ASM

    IDEAL
    JUMPS
    P386
    P387


    MASM
    .MODEL FLAT
    .CODE
    IDEAL

    extrn   _OffsetTable:word
    extrn   _Buffer:dword
    extrn   _Color:dword
    extrn   _World:dword
    extrn   _USERX:word
    extrn   _USERY:word
    extrn   _xPosns:word
    extrn   _yPosns:word
    extrn   _startpostable:word
    extrn   _RangeTable:dword
    extrn   _UserAlt:word
    extrn   _Used:byte
    extrn   _CurrentColumn:dword
    extrn   _CurrentAngle:dword
    extrn   _HighRow:dword
    extrn   _OldPos:dword
    extrn   _CurrentColor:byte


    public  CopyVertical_
    public  FillLinearBuffer_
    public  FillUsedBuffer_

;==============================================================================
; Copy a linear buffer to a vertical column of a video buffer
;==============================================================================
proc    CopyVertical_ near
    mov     eax,[_HighRow]  ; Pick up the starting row to draw
    cmp     eax,200         ; If at the bottom of the screen
    jae     noCopy          ; then get out now

    push    ebx
    push    ecx

    push    esi
    push    edi

    mov     edi,[_Buffer]               ; Buffer to draw into
    movzx   ebx,[_OffsetTable+eax*2]    ; Pre-calculated video offset
    add     edi,ebx
    add     edi,[_CurrentColumn]        ; Display column to start with

    mov     esi,offset _Used            ; Buffer to get data from
    add     esi,eax                     ; Plus the start row

    mov     ecx,200                     ; Total rows that can be drawn
    sub     ecx,eax                     ; Minus our starting row
    mov     ebx,320                     ; Amount to skip for each row

cvLoop:
    mov     al,[esi]                    ; Current pixel
    mov     ah,al                       ; Setup to copy to columns at once
    mov     [edi],ax
    inc     esi                         ; Next row of source buffer
    add     edi,ebx                     ; Next row of video buffer
    dec     ecx
    jnz     cvLoop

    pop     edi
    pop     esi

    pop     ecx
    pop     ebx

noCopy:
    ret
    endp


;==============================================================================
; void FillLinearBuffer(short startpos,short i);
;==============================================================================
proc    FillLinearBuffer_

    cmp     eax,[_OldPos]       ; Are we beyond the last remembered row?
    jle     noFill              ; Nope, get out now
    cmp     eax,0               ; Are we in bounds for the screen?
    jle     noFill              ; Nope
    cmp     eax,200             ; Check if beyond last row
    jge     noFill              ; Get out if so

    push    ebx
    push    ecx
    push    edx
    push    edi

    mov     ebx,[_OldPos]
    cmp     ebx,200             ; Is last remembered row out of bounds?
    jge     nfDone              ; Yes, getout

    cmp     dx,10               ; Is length near the bottom of the screen?
    jge     short nfLarger      ; Not yet

    mov     ecx,200
    sub     ecx,ebx             ; Get 200 - OldPos for number of rows
    mov     eax,199             ; and set our starting row at bottom of screen
    jmp     short nfDoFill      ; then continue with the fill


nfLarger:
    mov     ecx,eax             ; Get our starting row
    sub     ecx,ebx             ; Minus last remembered row

nfDoFill:
    sub     eax,ecx             ; Subtract number of rows from starting row
    jnc     short nfNotNegative ; Didn't go above top

    add     ecx,eax             ; Else adjust the number of rows
    xor     eax,eax             ; And set our starting row at top

nfNotNegative:
    cmp     eax,[_HighRow]      ; Keep our highest row used updated
    jge     short nfNotLess     ; Nope, not less than highest
    mov     [_HighRow],eax      ; Else save current high row

nfNotLess:
    mov     edi,offset _Used    ; Get our linear buffer
    add     edi,eax             ; Add in the row we are going to start with

    mov     al,[_CurrentColor]  ; Get the color we want to use
    mov     ah,al
    mov     bx,ax               ; Hold onto it for a second
    shl     eax,16              ; Move to the upper end
    mov     ax,bx               ; Now eax contains 32 bit of color

    mov     ebx,ecx
    shr     ecx,2               ; Divide length by four
    rep     stosd               ; and blast in (sort of) 4 bytes at a time
    and     ebx,3               ; get the remaining bytes to copy
    mov     ecx,ebx
    rep     stosb               ; and store them as bytes

nfDone:
    pop     edi
    pop     edx
    pop     ecx
    pop     ebx


noFill:
    ret
    endp

;==============================================================================
;
;==============================================================================
proc FillUsedBuffer_ near
    push    ecx
    push    edi
    mov     al,[_CurrentColor]
    mov     ah,al               ; Put color into AX
    mov     cx,ax               ; Hold onto it for a second
    shl     eax,16              ; Move color to upper 16 bits
    mov     ax,cx               ; And then fill lower 16 bits again
    mov     edi,offset _Used
    add     edi,100             ; Start 100 bytes into buffer

    mov     ecx,25              ; Fill 25 * 4 = 100 bytes of the buffer
    rep     stosd

    pop     edi
    pop     ecx
    ret
    endp


    end

