#include <stdio.h>
#include <math.h>
#include "../includes/gfx.h"

#define PI 3.14159

char *vPage,*Palette,*background;
char sprite[145][33];

void main()
{
  long xi,x,y,i,j,color,t,ofs;
  float counter,l;
  FILE *f;

  vPage = (char *)malloc(PAGE_SIZE);
  background = (char *)malloc(PAGE_SIZE);
  Palette = (char *)malloc(PALETTE_SIZE);

  Init_Virtual_Page(vPage);
  Init_Gfx_Mode();
  Set_Virtual_Page(VIRTUAL_PAGE);
  //generate background
  t = i = j = 0;
  for (y = 0;y < 20;y++) {
    for (x = 0;x < 40;x++) {
      if (t == 0) color = 1; else color = 2;
      for (j = 0;j < 10;j++)
      for (i = 0;i < 10;i++)
      Put_Pixel(x*10+i,y*10+j,color);
      t = 1 - t;
    }
    t = 1 - t;
  }
  memcpy(background,vPage,PAGE_SIZE);
  //load sprite
  if ((f = fopen("sprite.dat","rb")) == NULL) {
    printf("Sprite file not found!\n");
    exit(1);
  }
  fread(vPage,1,PAGE_SIZE,f);
  fclose(f);
  //load palette
  if ((f = fopen("sprite.pal","rb")) == NULL) {
    printf("Palette file not found!\n");
    exit(1);
  }
  fread(Palette,1,PALETTE_SIZE,f);
  fclose(f);
  Set_Palette(Palette);
  Set_Color(1,63,63,63);
  Set_Color(2,63,0,0);
  //get sprite
  for (y = 0;y < 33;y++)
  for (x = 0;x < 145;x++) sprite[x][y] = vPage[x+y*320];
  xi = 0;
  //main loop
  while (!kbhit()) {
    xi++;
    memcpy(vPage,background,PAGE_SIZE);
    for (x = 0;x < 145;x++) {
      counter += 0.02;
      l = sin((0.15*(x+counter))/PI)*10;
      for (y = 0;y < 33;y++)
      if (sprite[x][y] != 0) {
        color = vPage[(long)(y+l+150)*320+x+xi];
        if (color == 1) ofs = -50; else ofs = -100;
        vPage[(long)(y+l+150)*320+x+xi] = sprite[x][y] + ofs;
      }
    }
    Flip_Virtual_Page();
  }
  Init_Text_Mode();
  printf("Funny sinus scroll by maLi/DarkSiDe - 1996\n");
  printf("E-mail: mtrtnik@info.src.si\n");
}