Program PanTest;
Uses Crt;
{$L PixelPan.Obj}
Type
     ChartType=record
          DirStart,DirEnd: byte
     End;

Const
     MaxBalls=20; MaxCollisions=20;
     BytesPerLine: integer=(40);
     QueueSize=40;

     North=0; South=1;
     East=2; West=3;
     NE=4; SE=5; NW=6; SW=7;

     Absent=0;
     Stationary=1;
     Moving=2;

     Top=0; Bottom=1; Left=2; Right=3;
     Nothing=4; TL=5; TR=6; BL=7; BR=8;


Type
     XYrec=record
          x,y: integer
     End;

     BallRec=record
          Queue: array[1..QueueSize] of XYrec;
          QueueHead,QueueTail: integer;
          x,y: integer;
          Color: byte;
          Direction: byte;
          Collision: byte
     End;
     BallRecArray=array[1..MaxBalls] of BallRec;

Var
     i,j,k,l: integer;
     ch: char;
     xmax,ymax: integer;
     xsize,ysize: integer;
     scrnx,scrny: integer;
     x1,y1,x2,y2: integer;
     SizeX,SizeY: integer;
     Step: integer;
     Color: integer;
     SizeXS,SizeYS,StepS: string;
     SectionS,SlugS: string;
     Code,ScreenMode: integer;
     Modes: string;
     Trace: boolean;
     BallPtr: integer;
     Balls: BallRecArray;
     QueueLength: integer;


Procedure SetMode(Mode: integer); external;
Procedure SetLineLength(Length: integer); external;
Procedure SetViewPosition(Hpixel,LineNum: integer); external;
Procedure Pset(x,y: integer; Color: byte); external;
Procedure Line(x1,y1,x2,y2: integer; Color: byte); external;
Procedure Ellipse(x,y,r1,r2: integer; Color: byte; Fill: boolean); external;
Procedure Retrace; External;

Procedure Hlin(x1,y1,x2,color: integer);
Begin
     Line(x1,y1,x2,y1,Color)
End;

Procedure Vlin(x1,y1,y2,color: integer);
Begin
     Line(x1,y1,x1,y2,Color)
End;

Procedure Swap(Var n1,n2: integer);
Var
     x: integer;

Begin
     x:=n1; n1:=n2; n2:=x
End;
 
Procedure Box(x1,y1,x2,y2,color: integer);
Var
     i: integer;

Begin
     if y2<y1 then Swap(y1,y2);
     if x2<x1 then Swap(x1,x2);
     For i:=y1 to y2 do
          Line(x1,i,x2,i,Color)
End;

Procedure AddQueue(i,px,py: integer);
Begin
     With Balls[i] do
     Begin
          {if QueueHead=QueueTail then
          Begin
               TextMode(co80);
               WriteLn('Internal Error -- press a key.');
               ch:=readkey;
               Halt
          End;}
          Queue[QueueHead].x:=px;
          Queue[QueueHead].y:=py;
          inc(QueueHead);
          if QueueHead>QueueLength then QueueHead:=1
     End
End;

Function TakeFromQueue(i: integer; Var px,py: integer): boolean;
Var
     Full: boolean;
     qh: integer;

Begin
     With Balls[i] do
     Begin
          {Full:=FALSE; qh:=QueueHead-1; if qh<1 then qh:=QueueLength;
          if (qh-QueueTail)=0 then Full:=TRUE;
          if (QueueTail=1) and (qh=QueueLength) then Full:=TRUE;}
          Full:=QueueHead=QueueTail;
          if not Full then
               TakeFromQueue:=FALSE
          else
          Begin
               TakeFromQueue:=TRUE;
               px:=Queue[QueueTail].x;
               py:=Queue[QueueTail].y;
               inc(QueueTail);
               if QueueTail>QueueLength then QueueTail:=1
          End
     End
End;

Procedure DrawBall(i: integer);
Var
     x,y: integer;

Begin
     x:=Balls[i].x; y:=Balls[i].y;
     if (x>=x1) and (y>=y1) and (x+SizeX<=x2) and
        (y+SizeY<=y2) then
     Ellipse(x,y,SizeX,SizeY,Balls[i].Color,TRUE);
     AddQueue(i,x,y)
End;

Procedure EraseBall(i: integer);
Var
     SmallX,SmallY,x,y: integer;

Begin
     if (Random(5)=0) and (Trace) then SmallX:=1 else SmallX:=0;
     if (Random(5)=0) and (Trace) then SmallY:=1 else SmallY:=0;
     if TakeFromQueue(i,x,y) and (x>=x1) and (y>=y1) and (x+SizeX<=x2) and
        (y+SizeY<=y2) then
     Ellipse(x,y,SizeX-SmallX,SizeY-SmallY,0,TRUE)
End;

Procedure MoveBall(i: integer);
Begin
     With Balls[i] do
     Case Direction of
          East: Inc(x,Step);
          West: Dec(x,Step);
          North: Dec(y,Step);
          South: Inc(y,Step);
          NE: Begin Dec(y,Step); Inc(x,Step) End;
          SE: Begin Inc(y,Step); Inc(x,Step) End;
          NW: Begin Dec(y,Step); Dec(x,Step) End;
          SW: Begin Inc(y,Step); Dec(x,Step) End
     End
End;

Procedure DetectBounce(i: integer);
Begin
     With Balls[i] do
     if Collision<>Nothing then
     Begin
          {Color:=Random(15)+1;}
          Case Collision of
               Top:  Case Direction of
                        North: Direction:=South;
                        NE: Direction:=SE;
                        NW: Direction:=SW
                      End;
               Bottom:Case Direction of
                        South: Direction:=North;
                        SE: Direction:=NE;
                        SW: Direction:=NW
                      End;
               Right: Case Direction of
                        East: Direction:=West;
                        NE: Direction:=NW;
                        SE: Direction:=SW
                      End;
               Left:  Case Direction of
                        West: Direction:=East;
                        NW: Direction:=NE;
                        SW: Direction:=SE
                      End;
               TL:    Case Direction of
                        North: Direction:=NE;
                        NW: Direction:=SE;
                        West: Direction:=SW
                      End;
               TR:    Case Direction of
                        East: Direction:=SE;
                        NE:   Direction:=SW;
                        North: Direction:=NW
                      End;
               BL:    Case Direction of
                        South: Direction:=SE;
                        SW: Direction:=NE;
                        West: Direction:=NW
                      End;
               BR:    Case Direction of
                        East: Direction:=NE;
                        SE: Direction:=NW;
                        South: Direction:=SW
                      End
          End
     End
End;

Function InB(x1,y1,x2,y2,x,y: integer): boolean;
Begin
     if (x>=x1) and (x<=x2) and (y>=y1) and (y<=y2) then
          InB:=TRUE
     else
          InB:=FALSE
End;

Function FindHit(x,y,j: integer): byte;
Var
    b1x1,b1y1,b1x2,b1y2: integer;
    b2x1,b2y1,b2x2,b2y2: integer;
    l,t: integer;

Begin
     b1x1:=x; b1y1:=y; b1x2:=x+sizeX*2; b1y2:=y+sizeY*2;
     With Balls[j] do
     Begin
          b2x1:=x; b2y1:=y; b2x2:=x+sizeX*2; b2y2:=y+sizeY*2
     End;
     l:=y+sizeY; t:=x+sizeX;
     FindHit:=Nothing;
     if InB(b2x1,b2y1,b2x2,b2y2,b1x1,b1y1) then FindHit:=TL else
     if InB(b2x1,b2y1,b2x2,b2y2,b1x2,b1y1) then FindHit:=TR else
     if InB(b2x1,b2y1,b2x2,b2y2,b1x1,b1y2) then FindHit:=BL else
     if InB(b2x1,b2y1,b2x2,b2y2,b1x2,b1y2) then FindHit:=BR;
     if InB(b2x1,b2y1,b2x2,b2y2,b1x1,l   ) then FindHit:=Left else
     if InB(b2x1,b2y1,b2x2,b2y2,t   ,b1y1) then FindHit:=Top else
     if InB(b2x1,b2y1,b2x2,b2y2,t   ,b1y2) then FindHit:=Bottom else
     if InB(b2x1,b2y1,b2x2,b2y2,b1x2,l   ) then FindHit:=Right
End;

Procedure FindCollisions;
Var
     i,j: integer;

Begin
     For i:=1 to BallPtr do MoveBall(i);
     For i:=1 to BallPtr do
     Begin
          With Balls[i] do
          Begin
               Collision:=Nothing;
               if x<=x1 then Collision:=Left;
               if x+SizeX>=x2 then Collision:=Right;
               if y<=y1 then Collision:=Top;
               if y+SizeY>=y2 then Collision:=Bottom;
               j:=1;
               While (j<=BallPtr) and (Collision=Nothing) do
               Begin
                    if i<>j then
                         Collision:=FindHit(x,y,j);
                    inc(j)
               End;
               DetectBounce(i)
          End
     End;
     For i:=1 to BallPtr do MoveBall(i)
End;

Procedure EllipseDemo;
Var
     viewx,viewy,i: integer;
     x,y: integer;

Begin
     Hlin(0,0,xmax,1);
     Hlin(0,ymax,xmax,1);
     Vlin(0,0,ymax,1);
     Vlin(xmax,0,ymax,1);
     For i:=1 to BallPtr do
     Begin
          Balls[i].Color:=Random(15)+1;
          Balls[i].x:=i*SizeX+2;
          Balls[i].y:=Random(Ysize-SizeX*2)+SizeX;
          Balls[i].Direction:=Random(8);
          Balls[i].QueueHead:=1; Balls[i].QueueTail:=1
     End;
     x1:=SizeX+2; y1:=sizeY+2; x2:=xsize-2; y2:=ysize-2;

     For i:=1 to BallPtr do
          DrawBall(i);
     While not keypressed do
     Begin
          FindCollisions;
          For i:=1 to BallPtr do
          Begin
               EraseBall(i);
               DrawBall(i)
          End;
          x:=Balls[1].x; y:=Balls[1].y;
          viewx:=x-(Scrnx div 2); if viewx<0 then viewx:=0;
          viewy:=y-(Scrny div 2); if viewy<0 then viewy:=0;
          if viewx>xmax-scrnx+1 then viewx:=xmax-scrnx+1;
          if viewy>ymax-scrny+1 then viewy:=ymax-scrny+1;
          SetViewPosition(viewx,viewy);

          if Random(10)=0 then
          Begin
               Line(0,0,xmax,ymax,15);
               Line(xmax,0,0,ymax,15)
          End
     End;
     ch:=readkey
End;

Begin
     Randomize;
     SetMode(3);
     WriteLn('VGA panning demo by Peter Jungck / Joe Tamburino');
     WriteLn('Base routines featured in The Programmer''s Journal, May-June 1991.');
     WriteLn('(Article by Peter Jungck, improvements by Joe Tamburino)');
     WriteLn;
     WriteLn('Peter''s address:  1019 West Lovers Lane / Arlington, TX 76013');
     WriteLn('Joe''s address:    7 Christopher Rd. / Westford, MA 01886.');
     WriteLn('                  Phone: (508) 692-7756');
     WriteLn;
     Write('Enter step rate (1 to 5 recommended) [3]: '); ReadLn(StepS);
     Write('Enter ball width  (3 to 20 recommended) [7]: '); ReadLn(sizexS);
     Write('Enter ball height (3 to 20 recommended) [6]: '); ReadLn(sizeyS);
     Write('Enter # of slug sections (1 to ',QueueSize,' required) [10]: '); ReadLn(SectionS);
     Write('Enter # of slugs (1 to ',MaxBalls,' required) [6]: '); ReadLn(SlugS);
     Write('Leave traces (y/n) [n]: ');
     Repeat
          ch:=upcase(readkey)
     Until ch in ['Y','N',#13];
     if ch=#13 then ch:='N'; WriteLn(ch);
     if ch='Y' then Trace:=TRUE else Trace:=FALSE;
     WriteLn;
     WriteLn('Select a screen mode:');
     WriteLn('    1:  320x200x16, mode 0Dh');
     WriteLn('    2:  640x350x16, mode 10h');
     WriteLn('    3:  640x480x16, mode 12h');
     WriteLn;
     Write('Which mode (1-2 only) [1]: '); ReadLn(Modes);
     if Modes='' then Modes:='1';
     if (Modes<>'1') and (Modes<>'2') and (Modes<>'3') then Modes:='1';
     Case Modes[1] of
          '1': ScreenMode:=$0d;
          '2': ScreenMode:=$10;
          '3': ScreenMode:=$12
     End;
     if StepS='' then Step:=3 else Val(StepS,Step,Code);
     if sizexS='' then SizeX:=7 else Val(sizexS,SizeX,Code);
     if sizeyS='' then SizeY:=6 else Val(sizeyS,SizeY,Code);
     if SectionS='' then QueueLength:=10 else Val(SectionS,QueueLength,Code);
     if (QueueLength<0) or (QueueLength>QueueSize) then QueueLength:=10;
     if SlugS='' then BallPtr:=6 else Val(SlugS,BallPtr,Code);
     if (BallPtr<0) or (BallPtr>MaxBalls) then BallPtr:=6;
     Case ScreenMode of
          $0d:  Begin
                     BytesPerLine:=80;
                     xmax:=639; ymax:=799;
                     scrnx:=320; scrny:=200
                End;
          $10:  Begin
                     BytesPerLine:=120;
                     xmax:=959; ymax:=539;
                     scrnx:=640; scrny:=350
                End;
          $12:  Begin
                     BytesPerLine:=120;
                     xmax:=959; ymax:=539;
                     scrnx:=640; scrny:=480
                End
     End;
     xsize:=xmax+1; ysize:=ymax+1;
     SetMode(ScreenMode);
     SetLineLength(BytesPerLine);
     SetViewPosition(0,0);
     EllipseDemo;
     SetMode(3)
End.
