; PIXELPAN.ASM -- EGA/VGA Pixel Panning Routines

SLOW_EGA       equ         0
               .model      small
               .data
extrn          BytesPerLine: word
; Ellipse variables:
		even
t_e_lo		dw		?
t_e_hi		dw		?
r1_lo		dw		?
r1_hi		dw		?
r2_lo		dw		?
r2_hi		dw		?
y_p_lo		dw		?
y_p_hi		dw		?
max_x		dw		?
c_x		dw		?
c_y		dw		?
xe		dw		?
ye		dw		?
portion		db		?
Old_BP		dw		?

               .code
Public         SetMode
Public         SetLineLength
Public         SetViewPosition
Public         Pset
Public         Line
Public         Ellipse
Public         Retrace

Voffset        equ         0a000h

SetMode        proc        near
vm_mode        equ         word ptr [bp+4]

               push        bp
               mov         bp,sp
               mov         ax,vm_mode
               xor         ah,ah
               int         10h
               pop         bp
               ret         2
SetMode        endp


SetLineLength  proc         near
LineLen        equ          word ptr [bp+4]

               push         bp
               mov          bp,sp
               mov          ax,LineLen
               cmp          ax,40
               jae          Low_Ok
               mov          ax,40
               jmp          Hi_Ok
Low_Ok:        cmp          ax,320
               jbe          Hi_Ok
               mov          ax,320
Hi_Ok:         mov          BytesPerLine,ax
               xchg         bx,ax
               mov          dx,3d4h
               mov          ax,13h
               out          dx,ax
               inc          dx
               mov          ax,bx
               shr          ax,1
               out          dx,ax
               mov          ax,bx
               pop          bp
               ret          2
SetLineLength  endp

WaitForRetrace macro
               local        Wait,Retrace
               mov          dx,3dah
Wait:          in           al,dx
               test         al,8
               jz           Wait
Retrace:       in           al,dx
               test         al,8
               jnz          Retrace
               cli
               endm

Retrace        proc         near
               WaitForRetrace
               ret
Retrace        endp

SetViewPosition proc        near
LineNum        equ          word ptr [bp+4]
Hpixel         equ          word ptr [bp+6]

               push         bp
               mov          bp,sp
               mov          ax,Hpixel
               mov          cx,ax
               and          cx,7
               shr          ax,1
               shr          ax,1
               shr          ax,1
               xchg         bx,ax
               mov          ax,LineNum
               mul          BytesPerLine
               add          bx,ax
               WaitForRetrace
               in           al,dx
               mov          ax,bx
               mov          al,0ch
               mov          dx,3d4h
               out          dx,ax
               mov          al,0dh
               mov          ah,bl
               out          dx,ax
if SLOW_EGA
               sti
               mov          dx,3dah
Wait2:         in           al,dx
               test         al,08h
               jz           Wait2
               cli
endif
               mov          dx,3c0h
               mov          al,33h
               out          dx,al
               xchg         cl,al
               out          dx,al
               sti
               pop          bp
               ret          4
SetViewPosition endp


Pset           proc         near
Color          equ          word ptr [bp+4]
ps_ypos        equ          word ptr [bp+6]
ps_xpos        equ          word ptr [bp+8]

               push         bp
               mov          bp,sp
               push         ds
               mov          bx,BytesPerLine
               mov          ax,Voffset
               mov          ds,ax
               mov          ax,ps_ypos
               mul          bx
               mov          bx,ps_xpos
               mov          cx,bx
               shr          bx,1
               shr          bx,1
               shr          bx,1
               add          bx,ax
               and          cl,7
               xor          cl,7
               mov          ch,1
               shl          ch,cl

               mov          dx,3ceh
               mov          al,5
               out          dx,al
               mov          dx,3cfh
               mov          al,2
               out          dx,al

               mov          dx,3ceh
               mov          al,8
               out          dx,al
               mov          dx,3cfh
               mov          al,ch
               out          dx,al

               mov          al,[bx]
               mov          ax,Color
               mov          [bx],al

               mov          dx,3ceh
               mov          al,5
               out          dx,al
               mov          dx,3cfh
               mov          al,0
               out          dx,al
               mov          dx,3ceh
               mov          al,8
               out          dx,al
               mov          dx,3cfh
               mov          al,0ffh
               out          dx,al
               pop          ds
               pop          bp
               ret          6
Pset           endp

PixelAddr10    proc         near
               mov          cl,bl
               push         dx
               mul          BytesPerLine
               pop          dx
               shr          bx,1
               shr          bx,1
               shr          bx,1
               add          bx,ax
               mov          ax,Voffset
               mov          es,ax
               and          cl,7
               xor          cl,7
               mov          ah,1
               ret
PixelAddr10    endp

Line           proc         near
x1             equ          word ptr [bp+12]
y1             equ          word ptr [bp+10]
x2             equ          word ptr [bp+8]
y2             equ          word ptr [bp+6]
Color          equ          byte ptr [bp+4]
VertIncr       equ          word ptr [bp-6]
Incr1          equ          word ptr [bp-8]
Incr2          equ          word ptr [bp-10]
Routine        equ          word ptr [bp-12]
ByteOffsetShift equ         3
RMWbits        equ          0

               push         bp
               mov          bp,sp
               sub          sp,8
               push         si
               push         di

               mov          dx,3ceh
               mov          ah,Color
               xor          al,al
               out          dx,ax
               mov          ax,0f01h
               out          dx,ax
               mov          ah,RMWbits
               mov          al,3
               out          dx,ax

               mov          si,BytesPerLine
               mov          cx,x2
               sub          cx,x1
               jz           VertLine10
               jns          L01
               neg          cx
               mov          bx,x2
               xchg         bx,x1
               mov          x2,bx
               mov          bx,y2
               xchg         bx,y1
               mov          y2,bx

L01:           mov          bx,y2
               sub          bx,y1
               jz           HorizLine10
               jns          L03
               neg          bx
               neg          si

L03:           mov          VertIncr,si
               mov          Routine,offset LoSlopeLine10
               cmp          bx,cx
               jle          L04
               mov          Routine,offset HiSlopeLine10
               xchg         bx,cx

L04:           shl          bx,1
               mov          Incr1,bx
               sub          bx,cx
               mov          si,bx
               sub          bx,cx
               mov          Incr2,bx

               push         cx
               mov          ax,y1
               mov          bx,x1
               call         PixelAddr10

               mov          di,bx
               shl          ah,cl
               mov          bl,ah
               mov          al,8
               pop          cx
               inc          cx
               jmp          Routine

VertLine10:    mov          ax,y1
               mov          bx,y2
               mov          cx,bx
               sub          cx,ax
               jge          L31
               neg          cx
               mov          ax,bx

L31:           inc          cx
               mov          bx,x1
               push         cx
               call         PixelAddr10

               shl          ah,cl
               mov          al,8
               out          dx,ax
               pop          cx

L32:           or           es:[bx],al
               add          bx,si
               loop         L32
               jmp          Lexit

HorizLine10:   push         ds
               mov          ax,y1
               mov          bx,x1
               call         PixelAddr10
               mov          di,bx
               mov          dh,ah
               not          dh
               shl          dh,cl
               not          dh

               mov          cx,x2
               and          cl,7
               xor          cl,7
               mov          dl,0ffh
               shl          dl,cl

               mov          ax,x2
               mov          bx,x1
               mov          cl,ByteOffsetShift
               shr          ax,cl
               shr          bx,cl
               mov          cx,ax
               sub          cx,bx

               mov          bx,dx
               mov          dx,3ceh
               mov          al,8

               push         es
               pop          ds
               mov          si,di

               or           bh,bh
               js           L43
               or           cx,cx
               jnz          L42
               and          bl,bh
               jmp          short L44

L42:           mov          ah,bh
               out          dx,ax
               movsb
               dec          cx

L43:           mov          ah,11111111b
               out          dx,ax
               rep movsb

L44:           mov          ah,bl
               out          dx,ax
               movsb
               pop          ds
               jmp          short Lexit

; Non horizontal / vertical lines:

LoSlopeLine10: mov          ah,bl
L11:           or           ah,bl
               ror          bl,1
               jc           L14

               or           si,si
               jns          L12
               add          si,Incr1
               loop         L11

               out          dx,ax
               or           es:[di],al
               jmp          short Lexit
L12:           add          si,Incr2
               out          dx,ax
               or           es:[di],al
               add          di,VertIncr
               loop         LoSlopeLine10
               jmp          short Lexit

L14:           out          dx,ax
               or           es:[di],al
               inc          di
               or           si,si
               jns          L15
               add          si,Incr1
               loop         LoSlopeLine10
               jmp          short Lexit

L15:           add          si,Incr2
               add          di,VertIncr
               loop         LoSlopeLine10
               jmp          short Lexit

HiSlopeLine10: mov          bx,VertIncr
L21:           out          dx,ax
               or           es:[di],al
               add          di,bx
L22:           or           si,si
               jns          L23
               add          si,Incr1
               loop         L21
               jmp          short Lexit
L23:           add          si,Incr2
               ror          ah,1
               adc          di,0
               loop         L21

Lexit:         xor          ax,ax
               out          dx,ax
               inc          ax
               out          dx,ax
               mov          al,3
               out          dx,ax
               mov          ax,0ff08h
               out          dx,ax
               pop          di
               pop          si
               mov          sp,bp
               pop          bp
               ret          10
Line           endp

DoHlin		proc		near
; Designed for interface with Ellipse procedure.  Call with the	first
; (x,y)	coordinate in CX,DX, and the amount to add (twice) in SI
; Color	is in AX
		push		ax
		push		bx
		push		cx
		push		dx
		push		si
		push		di

		push		cx
		push		dx
		add		cx,si
		add		cx,si
		push		cx
                push            dx
		push		ax
		call		Line

		pop		di
		pop		si
		pop		dx
		pop		cx
		pop		bx
		pop		ax
		ret
DoHlin		endp

DoPset		proc		near
; For use with the Ellipse procedure as	an interface to	the main pixel-set
; routine, Pset2.
x		equ		word ptr [bp+8]
y		equ		word ptr [bp+6]
Color		equ		byte ptr [bp+4]
		push		bp
		mov		bp,sp

		push		ax
		push		bx
		push		cx
		push		dx
		push		si
		push		di
		push		es

		push		x
		push		y
		mov		al,Color
		xor		ah,ah
		push		ax
		call		Pset

		pop		es
		pop		di
		pop		si
		pop		dx
		pop		cx
		pop		bx
		pop		ax
		pop		bp
		ret		6
DoPset		endp


Ellipse		proc		near
; Call With:  Ellipse(x1,y1,r1,r2:  word;  Color:  byte;  FillIt:  boolean);
; Draws	an ellipse centered at x1,y1;  the x-radius is in r1, and the
; y-radius is in r2.  The attribute is specified in Color.
; Note:	 If FillIt is TRUE (1) then the Ellipse is solid, otherwise
; just the parimeter is filled.
; The code has been taken from "EGA/VGA, A Programmer's	Reference Guide" by
; Dyck Kliewer and published by	Intertext/McGraw-Hill
x1		equ		word ptr [bp+14]
y1		equ		word ptr [bp+12]
r1		equ		word ptr [bp+10]
r2		equ		word ptr [bp+8]
Color		equ		byte ptr [bp+6]
FillIt          equ             byte ptr [bp+4]

;
r_l		equ		1
t_b		equ		11111110b
pixpb		equ		3
b_mask		equ		10000000b


                even
		push		bp
		mov		bp,sp

		and		portion,t_b
		call		e_call
		or		portion,r_l
		push		r2
		push		r1
		pop		r2
		pop		r1
		call		e_call

                mov             sp,bp
		pop		bp
		ret		12

e_call		proc		near
		push		ax
		push		bx
		push		cx
		push		dx
		mov		ax,x1
		mov		c_x,ax
		mov		ax,y1
		mov		c_y,ax
		mov		ax,0
		mov		xe,0
		mov		bx,r2
		mov		ye,bx
		mov		cx,r1
		call		near ptr ellip
		pop		dx
		pop		cx
		pop		bx
		pop		ax
		ret
e_call		endp


ellip		proc		near
		push		bp
		mov		Old_BP,bp
		mov		si,ax
		mov		ax,bx
		mul		bx
		mov		bp,dx
		mov		bx,ax
		mov		r2_lo,ax
		mov		r2_hi,dx
		mov		ax,cx
		mul		cx
		mov		di,dx
		mov		cx,ax
		mov		r1_lo,ax
		mov		r1_hi,dx

		push		bx
		push		cx
		push		di
		push		bp
		push		si
		mul		ax
		mov		bp,ax
		mov		bx,dx
		mov		ax,di
		mul		cx
		shl		ax,1
		rcl		dx,1
		add		bx,ax
		mov		cx,dx
		mov		ax,di
		mul		ax
		add		cx,ax
		mov		ax,bp
		mov		dx,r2_lo
		mov		di,r2_hi
		add		dx,r1_lo
		adc		di,r1_hi
		mov		bp,0
		mov		si,0
div_loop:	cmp		cx,0
		jne		c_div
		cmp		bx,di
		ja		c_div
		cmp		ax,dx
		jae		c_div
		jmp		short div_done
c_div:		inc		bp
		jnz		no_of
		inc		si
no_of:		sub		ax,dx
		sbb		bx,di
		sbb		cx,0
		jmp		short div_loop
div_done:	shl		ax,1
		rcl		bx,1
		cmp		di,bx
		ja		no_up
		cmp		dx,ax
		ja		no_up
		inc		bp
		jnz		no_up
		inc		si
no_up:		sub		bx,bx
		cmp		dx,0
		jne		rt_strt
		cmp		si,0
		jne		rt_strt
		jmp		rt_done
rt_strt:	mov		bx,512
		mov		cx,512
rt_lp:		shr		cx,1
		mov		ax,bx
		mul		ax
		cmp		dx,si
		jg		t_lg
		jl		t_sm
		cmp		ax,bp
		jb		t_sm
		jmp		short t_lg
t_sm:		add		ax,bx
		adc		dx,0
		cmp		si,dx
		ja		t_sm2
		cmp		bp,ax
		ja		t_sm2
		jmp		short rt_done
t_sm2:		add		bx,cx
		jmp		short rt_lp
t_lg:		sub		ax,bx
		sbb		dx,0
		cmp		dx,si
		ja		t_lg2
		cmp		ax,bp
		ja		t_lg2
		jmp		short rt_done
t_lg2:		sub		bx,cx
		jmp		short rt_lp
rt_done:	inc		bx
		mov		max_x,bx
		pop		si
		pop		bp
		pop		di
		pop		cx
		pop		bx

		push		bx
		push		bp
		mov		ax,cx
		mul		ye
		mov		bx,ax
		mov		bp,dx
		mov		ax,di
		mul		ye
		add		bp,ax
		neg		bx
		not		bp
		shl		bx,1
		rcl		bp,1
		add		cx,bx
		adc		di,bp
		mov		t_e_lo,cx
		mov		t_e_hi,di

		shl		r1_lo,1
		rcl		r1_hi,1
		shl		r1_lo,1
		rcl		r1_hi,1
		mov		bx,ye
		dec		bx
		mov		ax,r1_lo
		mul		bx
		mov		bp,dx
		neg		ax
		mov		y_p_lo,ax
		mov		ax,r1_hi
		mul		bx
		add		ax,bp
		not		ax
		mov		y_p_hi,ax
		pop		bp
		pop		bx
		shl		bx,1
		rcl		bp,1
		push		bx
		push		bp
		shl		bx,1
		rcl		bp,1
		mov		r2_lo,bx
		mov		r2_hi,bp
		mov		cx,bx
		mov		di,bp
		pop		bp
		pop		bx
		mov		dx,t_e_hi
		mov		ax,t_e_lo

retest:		; Plot the points:

		push		ax
		push		bx
		push		cx
		push		dx
		push		di
		push		si
		push		bp
		mov		bp,Old_BP
		mov		di,ye
		test		portion,r_l
		jz		no_xchg
		xchg		si,di
no_xchg:	mov		al,Color
		xor		ah,ah
		cmp             FillIt,0
		jnz		DoHlinPlot
		mov		cx,c_x
		add		cx,si
		mov		dx,c_y
		add		dx,di
		push		cx
		push		dx
		push		ax
		call		DoPset
		sub		cx,si
		sub		cx,si
		push		cx
		push		dx
		push		ax
		call		DoPset
		sub		dx,di
		sub		dx,di
		push		cx
		push		dx
		push		ax
		call		DoPset
		add		cx,si
		add		cx,si
		push		cx
		push		dx
		push		ax
		call		DoPset
		jmp		short DonePlot

DoHlinPlot:     mov		cx,c_x
		sub		cx,si
		mov		dx,c_y
		add		dx,di
		call		DoHlin
		sub		dx,di
		sub		dx,di
		call		DoHlin

DonePlot:	pop		bp
		pop		si
		pop		di
		pop		dx
		pop		cx
		pop		bx
		pop		ax

		cmp		si,max_x
		jne		e_cont
		jmp		e_done

e_cont:		cmp		dx,0
		jl		Less1
		push		bx
		push		bp
		mov		bx,y_p_lo
		mov		bp,y_p_hi
		add		ax,bx
		adc		dx,bp
		dec		ye
		add		bx,r1_lo
		adc		bp,r1_hi
		mov		y_p_lo,bx
		mov		y_p_hi,bp
		pop		bp
		pop		bx
Less1:		add		ax,bx
		adc		dx,bp
		inc		si
		add		bx,cx
		adc		bp,di
		jmp		Retest
e_done:		pop		bp
		ret
ellip		endp
Ellipse		endp

               end
