/*
 SVGA Vesa PCX Loader 640x480x256
 By Dhonn Lushine
 (ludhonn@aol.com)
 Compiled with Watcom C++ 10.6
 5:42 PM 5/19/97
*/

#include <dos.h>
#include <stdio.h>

char pal[768];
char *double_buffer;
char *video_buffer=(char *)0xa0000;

/*
mode:
 101h=640x480x256
 103h=800x600x256
 107h=1280x1024x256
VESA 1.2+
 10Eh=320x200x64K
 10Fh=320x200x16M
 111h=640x480x64K
 112h=640x480x16M
 115h=800x600x16M
 11Bh=1280x1024x16M
VESA 2.0+
 120h=1600x1200x256
*/

void setvesa(short mode);
#pragma aux setvesa=\
"mov ax,4f02h"\
"int 10h"\
parm [bx] modify [eax ebx];


void pageflip(short page);
#pragma aux pageflip=\
"shl dx,4"\
"mov ax,4f05h"\
"xor ebx,ebx"\
"int 10h"\
parm [dx] modify [ax dx ebx];


void settext(void);
#pragma aux settext=\
"mov ax,3"\
"int 10h"\
modify [ax];

int loadpcx(char *file,char *buffer,int size)
{
 FILE *fp;
 int i,data,numb;
 if((fp=fopen(file,"rb"))==0)
  return 0;
 fseek(fp,128,SEEK_SET);
 for(i=0;i<size;)
 {
  data=fgetc(fp);
  if(data>=192&&data<=255)
  {
   numb=data-192;
   data=fgetc(fp);
   while(numb-->0) buffer[i++]=data;
  }
  else
   buffer[i++]=data;
 }
 fseek(fp,-768,SEEK_END);
 for(i=0;i<768;i+=3)
 {
  pal[i]=fgetc(fp)>>2;
  pal[i+1]=fgetc(fp)>>2;
  pal[i+2]=fgetc(fp)>>2;
 }
 fclose(fp);
 return 1;
}

void setpal(char *palette)
{
 int i,j;
 for(i=0;i<256;i++)
 {
  outp(0x3c8,i);
  for(j=0;j<3;j++)
   outp(0x3c9,palette[j+i*3]);
 }
}

void main(int argc,char**argv)
{
 int i,j,page;
 if(argc<2)
 {
  printf("syntax: %s pcxfile\n",argv[0]);
  return;
 } 
 setvesa(0x101);
 double_buffer=(char*)malloc(65536*5);
 if(!double_buffer)
 {
  printf("no mem\n");
  return;
 }
 loadpcx(argv[1],double_buffer,640*480);
 setpal(pal);

 for(page=0,j=0;page<5;page++)
 {
  pageflip(page);
  for(i=0;i<65536;i++,j++)
   video_buffer[i]=double_buffer[j];
 }

 getch();
 settext();
 free(double_buffer);
}
