/*.............................. TIF_DEMO.C .................. 6-6-95 ......*/
/* This program demonstrates the use of the TIFF reading, display and       */
/* writing capabilities of the VSA256 Version 4.0 Graphics Library and      */
/* the TIFF256 Graphics Library Extensions Version 4.0.                     */
/*                                                                          */
/* TO RUN:  - Enter VESA video mode                                         */
/*          - Hit any key to continue or ESC to exit program                */
/*          - Enter x,y image origin                                        */
/*          - Enter full TIFF file name including path and extension        */
/*          - Image is now drawn                                            */
/*          - If you want to modify (invert) image and save say yes (y).    */
/*          -    Then enter new name to save as.                            */
/*          -    Then wait while image is modified and saved.               */
/*          - Hit any key to repeat sequence or ESC to exit program         */
/*                                                                          */
/* NOTE: Sometimes your text input is not visible, depending on the Color   */
/*       Look Up Table that is active due to last image ploted.  Keep       */
/*       typing, your input will be accepted anyway.                        */
/*..........................................................................*/
#include <stdio.h>
#include <stdlib.h>
#include<math.h>
#include<limits.h>
#include <conio.h>
#include <malloc.h>

#include <vsa_font.h>       /* Required to support VSA256 Graphics Library  */
#include <vsa.h>            /* Required to support VSA256 Graphics Library  */
#include <tiff.h>         	/* Required to support TIFF256 Graphics Library */

#ifndef _MSC_VER
/*.....                This is line for Borland C Only !               .....*/
extern unsigned _stklen = 8000;
#endif

int rainbow_lut(void);
int color_bar(int, int);
int prime_list(int, int);
int image_stats(void);
int banner(unsigned);
int xform_image(int, int);
void update_message(int, int, int, char *);
void clear_text_area(int, int, int, int);
void vsa_get_input(char *);
void vsa_setup(void);

void main(int argc, char *argv[])
{
	int a,b,tx0,ty0,first,error,tcm=1;
	unsigned xx,yy,x0,y0,ya;
	unsigned long image_size;
	unsigned char lut[768], huge *image;
	char filename[100],key,text[100];
	ya = 4;
	first = 1;
	if(argc> 1)
		tcm = atoi(argv[1]);
/*..........................................................................*/
/* If demo locks up during color cycling, or color mods crash for whatever  */
/* reason, set the global parameter VSA_ATI_COLOR = 1.                      */
/*..........................................................................*/
//  VSA_ATI_COLOR = 1;
/*..........................................................................*/
/*               Initialize video mode and VSA256 environment.              */
/*               Valid modes are: 100h, 101h, 103h, and 105h.               */
/*..........................................................................*/
	vsa_setup();
	xx = XResolution;
	yy = YResolution;
	vsa_set_text_cursor_mode(1);
	tx0 = 0.5*XResolution - 17*XCharSize;
	ty0 = 0.85*YResolution;
/*..........................................................................*/
/*             Draw color look up table at bottom of screen.                */
/*..........................................................................*/
	rainbow_lut();
	tf_set_prime_colors();
	color_bar(a,b);
/*..........................................................................*/
/*  Turn on Adpative Palette feature for 24 bit/pixel images.               */
/*  (num_colors = 256, quality = 50)                                        */
/*  Also, turn on LZW Compression for any TIFF files which are written.     */
/*..........................................................................*/
	tf_set_true_color_mode(tcm,256,50);
	tf_set_compression(1);
HERE:
	a = .125*xx;
	b = .91*yy;
	color_bar(a,b);
/*..........................................................................*/
/*                   Draw Prime Colors at screen right.                     */
/*..........................................................................*/
	a = xx - 11*XCharSize;
	b = ya*YCharSize+4;
	prime_list(a,b);
/*..........................................................................*/
/*                          Draw a banner                                   */
/*..........................................................................*/
	banner(ya);
/*..........................................................................*/
/*                         Outline Screen                                   */
/*..........................................................................*/
	vsa_set_color(TF_Red);
	vsa_move_to(0,0);
	vsa_rect(xx-1,yy-1);
	vsa_move_to(1,1);
	vsa_rect(xx-2,yy-2);
/*..........................................................................*/
/*  This next block of code demonstrates some simple Color Look Up Table    */
/*  modications and also saving a new TIFF file. (Skipped on first pass.)   */
/*..........................................................................*/
	if((first == 0) && (!error))
		{
			clear_text_area(tx0,ty0-YCharSize,51,TF_Black);
			update_message(tx0,ty0,TF_Green,
											 "Want to Transform and Save as new TIFF ? (y,n): ");
			key = getch();
			if((key == 'y') || (key == 'Y'))
				{
					update_message(tx0,ty0,TF_Green,"Enter Path and Filename to save as: ");
					vsa_get_input(filename);
					update_message(tx0,ty0,TF_Green,"TRANSFORMING and SAVING !!");
					xform_image(x0,y0);
/*..........................................................................*/
/*  This commented code shows a representative use of tf_save_image.        */
/*..........................................................................*/
//...     image_size = vsa_image_size(0,0,347,571);
//...     image = (unsigned char huge *)halloc(image_size,1);
//...     if(image == NULL)
//...       {
//...         error = 1;
//...         update_message(tx0,ty0-YCharSize,TF_Red,"Error - Not enough memory for image!");
//...         getch();
//...         goto NOTSUPPORTED;
//...       }
//...     vsa_get_image(x0,y0,x0+347,y0+571,image);
//...     vsa_read_color_block(0,256,lut);
//...     error = tf_save_image(image,lut,filename);
//...     hfree(image);
/*..........................................................................*/
					error = tf_save_file(x0,y0,x0+(unsigned)TF_ImageWidth-1,
															 y0+(unsigned)TF_ImageLength-1,filename);
					if(error == -1)
						update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Can't Open or Create File!              ");
					if(error == -2)
						update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Not Enough Memory for Save Routine!     ");
					if(error == -3)
						update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Not Enough Memory for Compression.      ");
					if(error == -4)
						update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Problem Compressing the Data!           ");
				}
		}
	first = 0;
/*..........................................................................*/
/*         Wait for any key to continue; if ESC key, quit program.          */
/*..........................................................................*/
	update_message(tx0,ty0,TF_Yellow,"Press ESC to exit, Any other key to continue ...");
	key = getch();
	if(key == 27)
		goto BAIL;
/*..........................................................................*/
/*                   Get picture start coordinates.                         */
/*..........................................................................*/
	clear_text_area(tx0,ty0-YCharSize,51,TF_Black);
	update_message(tx0,ty0,TF_Red,"Input picture origin (x0,y0): ");
	vsa_get_input(text);
	sscanf(text,"%d,%d",&x0,&y0);
	x0 += 5;
	y0 += ya*YCharSize+4;
/*..........................................................................*/
/*             Open TIFF File, Prep environment, and handle errors.         */
/*..........................................................................*/
FILENAME:
	update_message(tx0,ty0,TF_Green,"Input full Filename: ");
	vsa_get_input(filename);
	error = tf_scan_file(filename);
	tf_decode_scan_error(tx0,ty0-YCharSize,TF_Red,error);
	if(error == -1)
		goto HERE;
	if(error != 0)
		goto NOTSUPPORTED;
/*..........................................................................*/
/*                     Tell user whats happening now.                       */
/*..........................................................................*/
	if(TF_SamplesPerPixel == 3)
		{
			if(tcm > 1)
				update_message(tx0,ty0-YCharSize,TF_Red,
				"Please Wait - Calculating ADAPTIVE Palette.     ");
			if(tcm == 1)
				update_message(tx0,ty0-YCharSize,TF_Red,
				"Please Wait - Dithering RGB Image.");
		}
/*..........................................................................*/
/*                 Display TIFF image starting at (x0,y0).                  */
/* Note, Two methods are shown below.  One is commented out, your choice.   */
/*..........................................................................*/
	error = tf_display_ifd(x0,y0);
	if(error == 1)
		{
			update_message(tx0,ty0-YCharSize,TF_Red,"Low Memory: Turning Adaptive Palette OFF!       ");
			tf_set_true_color_mode(1,255,50);
			error = tf_display_ifd(x0,y0);
			tf_set_true_color_mode(2,255,50);
		}
	if(error == -1)
		update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Not Enough Memory to Decompress TIFF!   ");
	if(error == -2)
		update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Compressed Strip Exceeds Max Size!      ");
	if(error == -3)
		update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Bad Compressed TIFF data!               ");
	if(error == -4)
		update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Uncompressed Strip Exceeds Max Size!    ");
	if(error == -5)
		update_message(tx0,ty0-YCharSize,TF_Red,"ERROR - Can't Allocate Misc. Working Memory!    ");
	if(error != 0)
		goto NOTSUPPORTED;
/*..........................................................................*/
/*  This commented code shows a representative use of tf_load_image.        */
/*..........................................................................*/
//...  image_size = tf_image_size();
//...  image = (unsigned char huge *)halloc(image_size,1);
//...  if(image == NULL)
//...    {
//...      error = 1;
//...      update_message(tx0,ty0-YCharSize,TF_Red,"Error - Not enough memory for image!");
//...      getch();
//...      goto NOTSUPPORTED;
//...    }
//...  if(tf_load_image(image,lut) < 2)
//...    {
//...      update_message(tx0,ty0-YCharSize,TF_Red,"Low Memory: Turning Adaptive Palette OFF!       ");
//...      tf_set_true_color_mode(1,255,50);
//...      tf_load_image(image,lut);
//...      tf_set_true_color_mode(2,255,50);
//...    }
//...  vsa_write_color_block(0,256,lut);
//...  vsa_put_image(x0,y0,image,0);
//...  hfree(image);
/*..........................................................................*/

/*..........................................................................*/
/*                 Restore Prime Color Values.                              */
/*..........................................................................*/
	tf_set_prime_colors();
/*..........................................................................*/
/*                            Frame new image.                              */
/*..........................................................................*/
	vsa_set_color(TF_White);
	vsa_move_to(x0-2,y0-2);
	vsa_rect(x0+(unsigned)TF_ImageWidth+1,y0+(unsigned)TF_ImageLength+1);
	vsa_set_color(TF_Black);
	vsa_move_to(x0-1,y0-1);
	vsa_rect(x0+(unsigned)TF_ImageWidth,y0+(unsigned)TF_ImageLength);
/*..........................................................................*/
/*                 Update Image Statistics                                  */
/*..........................................................................*/
	image_stats();
/*..........................................................................*/
/*                        Close opened TIFF file.                           */
/*..........................................................................*/
NOTSUPPORTED:
	tf_close_file();
	goto HERE;
/*..........................................................................*/
/*                       Restore text video mode and Bail Out.              */
/*..........................................................................*/
BAIL:
	tf_about();
	getch();
	vsa_init(0x03);
	return;                       /*.....            End main            .....*/
}


rainbow_lut()
{
	int i,start,count;
	unsigned char color_array[768];
	for(i=0;i<224;i++)
		{
			color_array[3*i+2]=0;
			color_array[3*i+1]=0;
			color_array[3*i]=0;
		}
/*................................ RED .....................................*/
	for(i=0;i<56;i++)
		{
				color_array[3*i] = 63*sin((i*6.28)/112.0);
		}
/*............................... BLUE .....................................*/
	for(i=0;i<126;i++)
		{
				color_array[3*i+2] = 63*sin((i*6.28)/252.0);
		}
/*............................... GREEN ....................................*/
	for(i=96;i<210;i++)
		{
				color_array[3*i+1] = 63*sin(((i-90)*6.28)/252.0);
		}
/*................................ RED .....................................*/
	for(i=140;i<224;i++)
		{
				color_array[3*i]   = 63*sin(((i-140)*6.28)/280.0);
		}
	start = 32;
	count = 224;
	vsa_write_color_block(start,count,color_array);
	return 0;
}


color_bar(x0,y0)
int x0,y0;
{
	int i;
	unsigned xx,yy,a,b;
	float c;
	xx = XResolution;
	yy = YResolution;
/*..........................................................................*/
/*     Draw outline for color bar.                                          */
/*..........................................................................*/
	vsa_set_color(TF_White);
	vsa_move_to(x0-1,y0-1);
	a = .75*xx;
	b = .065*yy;
	vsa_rect(x0+a+1,y0+b+1);
	c = (float)a/256;
	for(i=0;i<256;i++)
		{
			vsa_set_color((unsigned char)i);
			vsa_move_to(x0+(unsigned)(i*c),y0);
			vsa_rect_fill(x0+(unsigned)(c+i*c),y0+b);
		}
	return 0;
}

prime_list(x0,y0)
int x0,y0;
{
	int tx0,ty0;
	unsigned xxx;

	xxx = x0 + 9*XCharSize;

	tx0 = x0;
	ty0 = y0;
	update_message(tx0,ty0,TF_White,"Black =  ");
	vsa_set_color(TF_Black);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Red,"Red =    ");
	vsa_set_color(TF_Red);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Orange,"Orange = ");
	vsa_set_color(TF_Orange);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Yellow,"Yellow = ");
	vsa_set_color(TF_Yellow);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Green,"Green =  ");
	vsa_set_color(TF_Green);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Aqua,"Aqua =   ");
	vsa_set_color(TF_Aqua);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Blue,"Blue =   ");
	vsa_set_color(TF_Blue);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_Violet,"Violet = ");
	vsa_set_color(TF_Violet);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	ty0 += YCharSize;
	update_message(tx0,ty0,TF_White,"White =  ");
	vsa_set_color(TF_White);
	vsa_move_to(xxx,ty0);
	vsa_rect_fill(xxx+XCharSize,ty0+YCharSize-4);

	return 0;
}

image_stats()
{
	char text[100];
	int tx0,ty0;

	tx0 = 39*XCharSize;
	ty0 = YCharSize;

	sprintf(text,"Width  = %d     ",TF_ImageWidth);
	update_message(tx0,ty0,TF_White,text);
	ty0 += YCharSize;;
	sprintf(text,"Length = %d     ",TF_ImageLength);
	update_message(tx0,ty0,TF_White,text);
	ty0 = YCharSize;
	tx0 = 55*XCharSize;
	if(TF_PhotometricInterpretation < 2)
		{
			update_message(tx0,ty0,TF_White,"Color Model = Bilevel or");
			ty0 += YCharSize;;
			update_message(tx0,ty0,TF_White,"              GrayScale ");
			ty0 += YCharSize;;
			sprintf(text,"%d Bits Per Pixel        ",TF_BitsPerSample[0]);
			update_message(tx0,ty0,TF_White,text);
			ty0 += YCharSize;;
		}
	if(TF_PhotometricInterpretation == 2)
		{
			update_message(tx0,ty0,TF_White,"Color Model = True Color");
			ty0 += YCharSize;;
			update_message(tx0,ty0,TF_White,"24 Bits Per Pixel       ");
			ty0 += YCharSize;;
			update_message(tx0,ty0,TF_White,"(8 bits each R,G,B)     ");
			ty0 += YCharSize;;
		}
	if(TF_PhotometricInterpretation == 3)
		{
			update_message(tx0,ty0,TF_White,"Color Model = Palette   ");
			ty0 += YCharSize;;
			sprintf(text,"%d Bits Per Pixel        ",TF_BitsPerSample[0]);
			update_message(tx0,ty0,TF_White,text);
			ty0 += YCharSize;;
			update_message(tx0,ty0,TF_White,"                        ");
			ty0 += YCharSize;;
		}
	if(TF_PhotometricInterpretation > 3)
		update_message(tx0,ty0,TF_White,"Color Model = Unknown   ");
	ty0 = YCharSize;
	tx0 = 82*XCharSize;
	if(TF_Compression == 1)
		{
			update_message(tx0,ty0,TF_White,"Uncompressed File  ");
			ty0 += YCharSize;;
		}
	if(TF_Compression == 5)
		{
			update_message(tx0,ty0,TF_White,"LZW Compressed File");
			ty0 += YCharSize;;
		}
	return 0;
}

banner(ya)
unsigned ya;
{
	int tx0,ty0;
	unsigned xx;
	xx = XResolution;
	vsa_move_to(0,0);
	vsa_set_color(TF_Red);
	vsa_rect(xx-1,ya*YCharSize);
	vsa_move_to(38*XCharSize,0);
	vsa_line_to(38*XCharSize,ya*YCharSize);
	vsa_move_to(38*XCharSize+1,0);
	vsa_line_to(38*XCharSize+1,ya*YCharSize);
	ty0 = YCharSize;
	tx0 = 2*XCharSize;
	vsa_write_string(tx0,ty0,TF_Green,"TIFF256 GRAPHICS LIBRARY EXTENSIONS");
	vsa_write_string(tx0,ty0+YCharSize,TF_Green,"           VERSION 4.0  ");
	vsa_write_string(tx0,ty0+2*YCharSize,TF_Green,"  Copyright Spyro Gumas 1992 - 1995");
	return 0;
}

xform_image(x0,y0)    /* Cheap Negative maker */
int x0,y0;
{
	unsigned char array[1024];
	int i,j;
	for(j=y0;j<y0+TF_ImageLength;j++)
		{
			vsa_get_raster_line(x0,(unsigned)(x0+TF_ImageWidth-1),j,array);
			for(i=0;i<TF_ImageWidth;i++)
				array[i] = 255 - array[i];
			vsa_raster_line(x0,(unsigned)(x0+TF_ImageWidth-1),j,array);
		}
	return 0;
}


void update_message(int x0,int y0,int color,char *text)
{
	clear_text_area(x0,y0,51,TF_Black);
	vsa_write_string(x0,y0,color,text);
	vsa_set_color(color);
	return;
}

void clear_text_area(int x0,int y0,int length,int color)
{
	vsa_set_color(color);
	vsa_move_to(x0,y0);
	vsa_rect_fill(x0+length*XCharSize-1,y0+YCharSize-1);
	return;
}

/*.......................... VSA_GET_INPUT .................... 6-25-94 ....*/
/*  This routine reads the keyboard input and echos it to the screen until  */
/* a carriage return is entered. Then the whole text string is returned     */
/* via 'text'.                                                              */
/*..........................................................................*/
void vsa_get_input(char *text)
{
	int i,x,y;
	char key;
	vsa_get_text_cursor(&x,&y);
	i=0;
	text[0] = 0;
	while((key = getch()) != 13)               /*  Do until a return is hit.  */
		{
			if(key != 8)
				{                                    /*  If not a back space        */
					text[i] = key;                     /*  add key entry to string.   */
					text[i+1] = 0;
					vsa_write_string(x,y,TF_White,text);/*  Echo the updated string.   */
					i++;
				}
			else
				{                                    /*  If a back space            */
					if(i > 0) i --;                    /*  delete last key entry.     */
					text[i] = 92;
					vsa_write_string(x,y,TF_White,text);/*  Echo the updated string.   */
					text[i] = 0;
				}
		}
	return;
}

/*.............................. VSA_SETUP .................... 6-6-95 .....*/
/*  This routine goes through the video mode set up stuff.                  */
/*..........................................................................*/
void vsa_setup(void)
{
	int i,vmode;
/*..........................................................................*/
/*               Initialize video mode and VSA256 environment.              */
/*               Valid modes are: 100h, 101h, 103h, and 105h.               */
/*..........................................................................*/
	printf("\n");
	printf("\n");
	printf("VESA standard Video Modes  =>   Mode | Resolution\n");
	printf("              (256 color)       -----|-----------\n");
	printf("                                100  |  640 x 400\n");
	printf("                                101  |  640 x 480\n");
	printf("                                103  |  800 x 600\n");
	printf("                                105  | 1024 x 768\n");
	printf("                                107  | 1280 x 1024\n");
	printf("Input Mode: ");
	scanf("%x",&vmode);
	if((i = vsa_init(vmode)) != 0)
		{
			printf("Error Initializing Requested Video Mode!\n");
			if(i==1) printf("  - Did You Load Correct VESA Driver (TSR) ??\n");
			if(i==2) printf("  - VESA BIOS Extensions (Driver) Not Loaded !!\n");
			if(i==3) printf("  - Requested Video Mode Not Supported by this Card!\n");
			if(i==4) printf("  - Mode Not an SVGA Mode Supported by this Card!\n");
			if(i==5) printf("  - VESA Driver Not Returning Mode Information!\n");
			exit(0);
		}
	return;
}

