        TITLE   CIRCLE

COMMENT \

        Circle drawing routine to be called from TURBO Pascal

Author:         Bob Pupazzoni
                84 Maple Avenue
                Tuckahoe, NY   10707

Format:         PROCEDURE CIRCLE(X0,Y0,R,C : INTEGER;
                  EXTERNAL 'CIRCLE.COM';

Where:          X0,Y0 are the coords. of the center point
                R     is the radius
                C     is the color

Notes:          1. The routine will work with both 320 x 200
                   and 640 x 200 graphics modes.

                2. No range checks are made on the coordinates, so
                   points plotted outside the display area may
                   produce strange results.

                3. This file must be converted to a .COM file using
                   the EXE2BIN utility in order to work properly with
                   TURBO Pascal.

                4. The algorithm used is discussed in:

                        Dr. Dobb's Journal #86
                        'Faster Circles for Apples', p. 18.
                        see Reader Commentary box by W. A. McWorter

        \

        ; E Q U A T E S

X0      EQU     WORD PTR [BP+10]
Y0      EQU     WORD PTR [BP+8]
R       EQU     WORD PTR [BP+6]
COLOR   EQU     BYTE PTR [BP+4]

X       EQU     WORD PTR [BP-2]
Y       EQU     WORD PTR [BP-4]
A       EQU     WORD PTR [BP-6]
B       EQU     WORD PTR [BP-8]
F       EQU     WORD PTR [BP-10]
E       EQU     WORD PTR [BP-12]

        ; M A C R O S

PLOT    MACRO   OP1,OP2
        MOV     AH,12
        MOV     AL,COLOR
        MOV     CX,SI
        MOV     DX,DI
        OP1     CX,X
        OP2     DX,Y
        INT     10H
        ENDM

        ; M A I N   P R O G R A M

CODE    SEGMENT PARA
        ASSUME  CS:CODE,SS:CODE,DS:NOTHING,ES:NOTHING

CIRCLE  PROC    NEAR            ; Set up frame
        PUSH    BP
        MOV     BP,SP
        SUB     SP,12

        MOV     E,3             ; Assume 320 x 200 graphics
        MOV     AH,15           ; Find out video state
        INT     10H
        CMP     AL,6            ; No, it's 640 x 200 graphics
        JNE     L9
        MOV     E,12

L9:     MOV     AX,R            ; X=R
        MOV     X,AX
        SHL     AX,1            ; A=-2*X+1
        NEG     AX
        INC     AX
        MOV     A,AX
        XOR     AX,AX           ; Y=0
        MOV     Y,AX
        MOV     F,AX            ; F=0
        INC     AX              ; B=1
        MOV     B,AX
        MOV     SI,X0           ; Store X0,Y0 in registers
        MOV     DI,Y0

L0:     PLOT    ADD,ADD         ; Plot 4 points at a time
        PLOT    ADD,SUB
        PLOT    SUB,ADD
        PLOT    SUB,SUB

        MOV     AX,R            ; If F<=R then
        CMP     F,AX
        PUSHF
        JG      L1

        INC     Y               ; Y=Y+1
        MOV     AX,B            ; F=F+B
        ADD     F,AX
        MOV     AX,E            ; B=B+E
        ADD     B,AX

L1:     POPF                    ; If F>=R then
        JL      L2

        DEC     X               ; X=X-1
        MOV     AX,A            ; F=F+A
        ADD     F,AX
        INC     A               ; A=A+2
        INC     A

L2:     MOV     AX,X            ; Repeat until X<=0
        OR      AX,AX
        JNS     L0

        MOV     SP,BP           ; Return to caller
        POP     BP
        RET     8

CIRCLE  ENDP
CODE    ENDS
        END     CIRCLE

                                                 