Program Super_FLI_Viewer_By_Brian_Jensen;

Uses CRT,DOS,Timer,TwkUnit;

Label Again;
Const FLI_Color=11;
      FLI_256=   4;
      FLI_LC=   12;
      FLI_BLACK=13;
      FLI_BRUN= 15;
      FLI_COPY= 16;
      FLI_MINI= 18;
      FLI_DELTA= 7;
      BufSize=  64000;
TYPE FLIHead=Record
              flength:   LongInt;
              magic:     Word;
              frames:    Word;
              width:     Word;
              height:    Word;
              depth:     Word;
              flags:     Word;
              speed:     LongInt;
              reserved1: Word;
              created:   LongInt;
              creator:   LongInt;
              updated:   LongInt;
              updater:   LongInt;
              aspectx:   Word;
              aspecty:   Word;
              reserved2: Array[1..38] Of Byte;
              oframe1:   LongInt;
              oframe2:   LongInt;
              reserved3: Array[1..40] Of Byte;
             END;
     FrameHead=Record
                length: LongInt;
                magic:  Word;
                chunks: Word;
                expand: Array[1..8] Of Byte;
               END;
     ChunkHead=Record
                length: LongInt;
                tp:     Word;
               END;
     BufArray= Array[0..BufSize-1] Of Byte;

{$F+}
{$L TWK256.OBJ}
PROCEDURE TWEAK; external;
{$L mtest.obj}
FUNCTION Detect: Word; External;
{$L copy386.obj}
PROCEDURE CopyPage2_386; External;
{$F-}

Var flicfile: File;
    head:     FLIHead;
    fhead:    FrameHead;
    data:     ^BufArray;
    indpos:   Word;
    dpos:     LongInt;
    maxdpos:  LongInt;
    curpal:   Array[0..255,1..3] Of Byte;
    dataseg:  Word;
    code:     Integer;
    cpu386:   Boolean;

PROCEDURE Error(e: String);
BEGIN
 TextMode(co80);
 ClrScr;
 WriteLn(e);
 Halt;
END;

PROCEDURE InitFLIC(fn: String);
BEGIN
 GetMem(data,SizeOf(BufArray));
 dataseg:=Seg(data^);
 Assign(flicfile,fn);
 Reset(flicfile,1);
 If ioresult<>0 Then Error('File not found');
 BlockRead(flicfile,head,SizeOf(FLIHead));
 If (head.magic<>$AF11) And (head.magic<>$AF12) Then Error('FLIHead magic');
END;

PROCEDURE ReadColorMap(length: Word;
                       range:  Byte);
Var skip,packet: Byte;
    change:      Word;
    posi:        Word;
    curcol:      Byte;
    t:           Byte;
    packets:     Byte;
    shift:       Byte;
BEGIN
 If range = 63 Then shift:=0
 Else shift:=2;
 BlockRead(flicfile,data^,length);
 curcol:=0;
 posi:=2; packets:=data^[0]{+data^[1]?};
 For packet:=1 To packets Do
 BEGIN
  skip:=data^[posi];
  Inc(posi);
  change:=data^[posi];
  Inc(posi);
  If change=0 Then change:=256;
  curcol:=curcol+skip;
  For t:=curcol To curcol+change-1 Do
  BEGIN
   curpal[t,1]:=data^[posi] Shr shift; Inc(posi);
   curpal[t,2]:=data^[posi] Shr shift; Inc(posi);
   curpal[t,3]:=data^[posi] Shr shift; Inc(posi);
  END;
 END;
 ASM
  Mov ah,10h
  Mov al,12h
  Mov bx,ds
  Mov es,bx
  Lea dx,curpal
  Mov bx,0
  Mov cx,100h
  Int 10h
 END;
END;

PROCEDURE SetBlack;
BEGIN
 TwkClearpage2;
END;

PROCEDURE ReadLineCompressed(length: Word);
Var sy,y:     Word;
    posi:     Word;
    packet:   Byte;
    packets:  Byte;
    x:        Word;
    rep:      ShortInt;
    curline:  Word;
    curseg:   Word;
    curpixel: Word;
BEGIN
 BlockRead(flicfile,data^,length);
 sy:=data^[0]+data^[1] Shl 8;
 posi:=4;
 If sy>=200 Then
 BEGIN curseg:=s22seg; curline:=(sy-200)*320; END
 Else BEGIN curseg:=s21seg; curline:=sy*320; END;
 For y:=sy To sy+data^[2]+data^[3] Shl 8-1 Do
 BEGIN
  curpixel:=curline;
  packets:=data^[posi]; Inc(posi);
  ASM
   Mov dl,packets
   Test dl,255
   Jz @TheEnd
   Mov bx,ds
   Mov si,posi
   Mov di,curline
   Mov es,curseg
   Mov ds,dataseg
   Cld
   Mov ah,0
   Mov ch,0
   @NextPacket:
   Lodsb
   Add di,ax
   Mov cl,ds:[si]
   Inc si

   Cmp cl,0
   Jle @Single

   Rep Movsb
   Dec dl
   Jnz @NextPacket
   Jmp @Slut

   @Single:
   Lodsb
   Neg cl
   Rep Stosb
   Dec dl
   Jnz @NextPacket

   @Slut:
   Mov ds,bx
   Mov posi,si
   @TheEnd:
  END;
  If sy=199 Then BEGIN curseg:=s22seg; curline:=0; END
  Else curline:=curline+320;
 END;
END;

PROCEDURE ReadRunLength(length: Word);
Var sy,y:    Word;
    posi:    Word;
    packet:  Byte;
    packets: Byte;
    x:       Word;
    rep:     ShortInt;
    t:       Word;
    repb:    Byte;
BEGIN
 BlockRead(flicfile,data^,length);
 posi:=0;
 For y:=0 To head.height-1 Do
 BEGIN
  packets:=data^[posi]; Inc(posi); x:=0;
  For packet:=1 To packets Do
  BEGIN
   rep:=ShortInt(data^[posi]); Inc(posi);
   If rep>0 Then
   BEGIN
    repb:=data^[posi];
    Asm
     Mov es,s21seg
     Mov ax,y
     Cmp ax,200
     Jl  @AfterPlane
     Mov es,s22seg
     Sub ax,200
     @AfterPlane:
     Mov cx,320
     Mul cx
     Add ax,x
     Mov di,ax
     Mov ch,0
     Mov cl,rep
     Add x,cx
     Mov al,repb
     Rep Stosb
     Inc posi
    END;
   END Else BEGIN
    ASM
     Neg rep
     Push ds
     Mov es,s21seg
     Mov ax,y
     Cmp ax,200
     Jl  @AfterPlane
     Mov es,s22seg
     Sub ax,200
     @AfterPlane:
     Mov cx,320
     Mul cx
     Add ax,x
     Mov di,ax
     Mov ch,0
     Mov cl,rep
     Add x,cx
     Mov si,posi
     Add posi,cx
     Mov ds,dataseg
     Cld
     Rep Movsb
     Pop ds
    END;
   END;
  END;
 END;
END;

PROCEDURE ReadDeltaCompressed(length: Word);
Var sy:       Word;
    y:        Integer;
    posi:     Word;
    packet:   Word;
    packets:  Word;
    ipacks:   Integer;
    x:        Word;
    rep:      ShortInt;
    skip:     Byte;
    ldata:    Byte;
    ldata2:   Byte;
    t:        Byte;
    curline:  Word;
    curseg:   Word;
BEGIN
 BlockRead(flicfile,data^,length);
 sy:=data^[0]+data^[1] Shl 8;
 posi:=2;
 y:=0; curseg:=s21seg; curline:=0;
 While sy>0 Do
 BEGIN
  packets:=data^[posi]; Inc(posi);
  packets:=packets+data^[posi] Shl 8; Inc(posi);
  ipacks:=Integer(packets);
  If packets And $C000 = $C000 Then {Bit 15 and 14 set}
  BEGIN
   ipacks:=Abs(ipacks);
   y:=y+ipacks;
   If y>=200 Then
   BEGIN
    y:=y-200;
    curline:=y*320; curseg:=s22seg;
   END ELSE curline:=curline+ipacks*320;
  END Else
  If packets And $8000 = $8000 Then {Bit 15 set}
  BEGIN
   If y<=199 Then
    screen21^[y,319]:=Lo(packets)
   Else screen22^[y-200,319]:=Lo(packets)
  END
  Else BEGIN
   Dec(sy);
   ASM
    Cld
    Mov dx,ipacks
    Mov si,posi
    Mov es,curseg
    Mov di,curline
    Mov bx,ds
    Mov ds,dataseg
    Mov ch,0
    @NextPacket:
    Mov ah,0
    Lodsb
    Add di,ax
    Mov cl,ds:[si]
    Inc si
    Cmp cl,0
    Jl  @Single
    Je  @TheEnd

    {Copy words:}
    Rep Movsw
    Dec dx
    Jnz @NextPacket
    Jmp @TheEnd

    {Dublicate byte:}
    @Single:
    Neg cl
    Lodsw
    Rep Stosw
    Dec dx
    Jnz @NextPacket
    @TheEnd:
    Mov posi,si
    Mov ds,bx
   END;
   Inc(y);
   If y=200 Then
   BEGIN curline:=0; curseg:=s22seg; END
   Else curline:=curline+320;
  END;
 END;
END;

PROCEDURE ReadMiniOrInfo(length: Word);
BEGIN
 BlockRead(flicfile,data^,length);
END;

PROCEDURE CopyUncompressed;
BEGIN
 BlockRead(flicfile,screen21^,64000);
 If head.height = 400 Then
  BlockRead(flicfile,screen22^,64000);
END;

PROCEDURE CopyPage2; Assembler;
ASM
 Push ds
 {Set destination}
 Mov cx,0a000h
 Mov es,cx
 Mov di,0
 {Set source:}
 Mov si,0
 Mov ds,s21seg
 {Set number of words to move:}
 Mov cx,32000
 {Move:}
 Cld
 Rep Movsw
 Pop ds
END;

PROCEDURE ClearMCGAPage2; Assembler;
ASM
 Push ds
 Mov si,0
 Mov ds,s21seg
 Mov ax,0
 Mov cx,32000
 Cld
 Rep Stosw
 Pop ds
END;

PROCEDURE ReadChunk;
Var chead: ChunkHead;
BEGIN
 BlockRead(flicfile,chead,SizeOf(ChunkHead));
 Case chead.tp Of
  FLI_LC:    ReadLineCompressed(chead.length-6);
  FLI_DELTA: ReadDeltaCompressed(chead.length-6);
  FLI_BRUN:  ReadRunLength(chead.length-6);
  FLI_Color: ReadColorMap(chead.length-6,63);
  FLI_256:   ReadColorMap(chead.length-6,255);
  FLI_Copy:  CopyUncompressed;
  FLI_Black: SetBlack;
  FLI_Mini:  ReadMiniOrInfo(chead.length-6);
  Else       If fhead.magic=$00A1 Then ReadMiniOrInfo(chead.length-6)
             Else Error('Wrong type');
 END;
 WaitFor(head.speed);
 If head.height=400 Then
  TwkCopyPage2
 Else
  If cpu386 Then
  ASM
   Mov ax,s21seg
   Call CopyPage2_386
  END Else CopyPage2;
 StartTimer;
END;

PROCEDURE ReadFrames;
Var chunk: Word;
    t:     Word;
BEGIN
 For t:=1 To head.frames Do
 BEGIN
  BlockRead(flicfile,fhead,SizeOf(FrameHead));
  If (fhead.magic<>$F1FA) And (fhead.magic<>$00A1) Then Error('Framehead magic');
  For chunk:=1 To fhead.chunks Do
   ReadChunk;
  If keypressed Then Exit;
 END;
END;

PROCEDURE GoMCGA; Assembler;
ASM
 Mov   al,13h
 Mov   ah,0
 Int   10h
END;

BEGIN
 If Paramcount<1 Then
 BEGIN
  ClrScr;
  WriteLn('MCGA + Tweaked mode 320x400x256 Flic player V0.95 beta');
  WriteLn('Programming: Brian Jensen / Purple');
  WriteLn;
  WriteLn('Usage: TWEAKFLC <filename> [speed (0-256)]');
  Halt;
 END;
 InstallFastTimer;
 InitFlic(Paramstr(1));
 If Paramcount=2 Then
  Val(paramstr(2),head.speed,code);
 If head.magic=$AF11 Then
  head.speed:=14*head.speed;
 cpu386:=detect>=3;
 If head.height=200 Then
 BEGIN
  GoMCGA;
  GetMem(screen21,SizeOf(VirScreen));
  s21seg:=Seg(screen21^);
  ClearMCGAPage2;
  If cpu386 Then
  ASM
   Mov ax,s21seg
   Call CopyPage2_386
  END Else CopyPage2;
 END Else If head.height=400 Then
 BEGIN
  InitTweak;
  TwkClearPage2;
  TwkCopyPage2;
 END Else Error('Unsupported resolution');
 Seek(flicfile,head.oframe1);
 Again:
 StartTimer;
 ReadFrames;
 WaitFor(head.speed);
 If Not keypressed Then
 BEGIN
  Seek(flicfile,head.oframe1);
  Goto Again;
 END;
 RestoreTimer;
 TextMode(co80);
END.