//Programs For Calculating New Vectors By Combining Old Vectors.

//////////////
//LEGAL STUFF/
//////////////

//COPYRIGHT 1995 KEVIN HOFFMAN
//ALL RIGHTS RESERVED
//YOU MAY USE THIS FILE IN ANY COMMERCIAL OR NON-COMMERCIAL APPLICATION.
//I JUST ASK IF WHEN YOU DISTRIBUTE THIS SOURCE FILE YOU INCLUDE THIS
//COPYRIGHT NOTICE.
//THERE IS ABSLOLUTELY NO WARRANTY ON THIS FILE.
//USE AT YOUR OWN RISK. I'M NOT RESPONSIBLE FOR ANY DAMAGE OR HARM
//THIS FILE MAY CAUSE OR ANY MODIFICATIONS.

//////////////////////////////////////////////////////////////////////////////

//This File Was Created in about 30 min...Not.<G> Have Fun. :-)

#include <stdio.h>
#include <conio.h>
#include <graph.h>
#include <math.h>

//Maximum Number Of Vectors
#define MAXVECTORS 50

//Type For Vector
typedef struct vector_typ
{
    float magnitude;
    float angle;
}vector,*vector_ptr;

//Global Data For Vectors
vector vectors[MAXVECTORS];

int main()
{
    vector getvector,vector1,vector2,finalvector;
    float dx1,dy1,dx2,dy2,tx,ty,newangle,newmag;
    short numvectors;
    short index;
    //Set Video Mode To 640x480 16 color
    _setvideomode(_VRES16COLOR);
    getnumvectors:
    printf("How Many Vectors To Calculate(2..%d): ",MAXVECTORS);
    scanf("%d",&numvectors);
    //Make Sure We Don't Have Over Max Vectors or below 2.
    //If there are less then 2 vectors we wouldn't have anything to compare!
    //If They Entered An Invalid Response Let Them Try Again.
    if ((numvectors<2)||(numvectors>MAXVECTORS)) goto getnumvectors;
    //Enter A Loop And Get All The Data For The Vectors
    for (index=0; index<numvectors; index++)
    {
        printf("Enter Magnitude For Vector: ");
        scanf("%f",&getvector.magnitude);
        printf("Enter Angle For Vector(0..359): ");
        scanf("%f",&getvector.angle);
        vectors[index].magnitude=getvector.magnitude;
        vectors[index].angle=getvector.angle;
    }
    printf("Calculating...");
    //Set Final X And Y Values To 0
    tx=0;
    ty=0;
    //Add All The Vectors Together
    for (index=0; index<numvectors; index++)
    {
        //Get New Vectors Values
        vector1.magnitude=vectors[index].magnitude;
        vector1.angle=vectors[index].angle;
        //Make Sure We Have No Negative Magnitudes. If We Do
        //Flip the angle(i.e. add 180) and reverse the magnitude.
        //Do this to avoid math errors
        if (vector1.magnitude<0) 
        {
            vector1.magnitude=-vector1.magnitude;
            vector1.angle=vectors[index].angle+180;
            if (vector1.angle>359) vector1.angle-=360;
        }
        //Note:Looks Bad Because the Microsoft Sin And Cos Function Are
        //In Radians. Just Converts From Angles To Radians.
        //Here We Are Just Getting The Actual X And Y
        //For Both Vectors So We Can Add Them
        //Note:I invert the sin function because in math
        //the Y is going up while on the screen Y increases going down
        //This makes sure that 90 degrees is truly 90 degrees and not
        //180 degrees.
        //We will have to invert the angle back later
        dx1=cos(vector1.angle/57.32484)*vector1.magnitude;
        dy1=(-(sin(vector1.angle/57.32484)))*vector1.magnitude;
        //Add The Two Vectors Together
        tx+=dx1;
        ty+=dy1;
        //If We Are Combining More Than 2 Vectors We
        //Are First Calculating the first and second vectors.
        //Get The New Vector And Combine it with the 3'rd Vector and
        //So On Till There Are No More Vectors To Combine
    }
    //This May Look Kinda Cryptic
    //Here's and Example:
    //0,0
    //   
    //         vector 1
    //              12,1
    //    
    //    
    //     
    //     
    //      3,6
    //Combined Vectors
    //0,0
    //   
    //    
    //     
    //        
    //          
    //            
    //               
    //                  
    //                   15(12+3),7(1+6)
    //To Get The Angle We Can Calculate The cosin
    //And Then Use The Function acos to get the angle.
    //Calculating the cos
    //                  /|
    //               /   |
    //  side C    /      |
    //         /         | side B
    //      /            |
    //   /               |
    // /_________________|
    //       side A
    ///////////////////////////////
    //          A
    // Cosin Is -
    //          C
    ///////////////////////////////
    // That Was Simple!
    // It Gave Us The New Angle For The Vector
    ///////////////////////////////
    float temp1=sqrt((tx*tx)+(ty*ty));
    //Calc the Cosine
    newangle=acos(tx/temp1)*57.32484;
    if (ty>0) newangle=360-newangle;
    //Calculate the New Magnitude by getting the hyptonuse of the
    //right triangle that was formed.
    //Note: We Were Also Calculating The Hyptonuse for getting
    //the cosin so I just stored the value in a temp float
    //For both Calcs.
    newmag=temp1;
    finalvector.angle=newangle;
    finalvector.magnitude=newmag;
    //We're Done Calculating
    printf("Done!\n");
    //Print The Results
    printf("Final Vector Angle: %f\nFinal Vector Magnitude: %f\n",finalvector.angle,finalvector.magnitude);
    //Wait For Them To Press A Key
    printf("Press A Key...\n");
    //Wait for a Keypress
    getch();
    //Now We Are going To Graph The Info
    //Draw All Input Lines In Blue
    _setcolor(9);
    for (index=0; index<numvectors; index++)
    {
        //Get X coords of vector
        dx1=cos(vectors[index].angle/57.32484)*vectors[index].magnitude;
        //Get Y coords of vector
        dy1=(-(sin(vectors[index].angle/57.32484)))*vectors[index].magnitude;
        //Move To Center Of Screen
        _moveto(319,239);
        _lineto(319+dx1,239+dy1);
    }
    _setcolor(10);
    //Draw Output Line In Green
    //Get X coords of vector
    dx1=cos(finalvector.angle/57.32484)*finalvector.magnitude;
    //Get Y coords of vector
    dy1=-(sin(finalvector.angle/57.32484)*finalvector.magnitude);
    dy1=(-(sin(finalvector.angle/57.32484)))*finalvector.magnitude;
    //Move To Center Of Screen
    _moveto(319,239);
    _lineto(319+dx1,239+dy1);
    //Wait For Another Key
    getch();
    //Return Video Mode To Normal
    _setvideomode(_DEFAULTMODE);
    //Everything Went OK so return no error
    return 0;
}
