{$X+}
{$G+}  {must have this to use 286 instruction set}

{Program by Richard Griffiths, written for VGA-TUT by Barnaby Mercer}
{VGA-TUT Web page : http://zetnet.co.uk/users/bmercer/vgatut.htm}

{e-Mail: richard.griffiths@zetnet.co.uk}
{      :      barny.mercer@zetnet.co.uk}

program pixel (input, output);

uses Crt;

const VGA_SEGMENT = $A000;    {We didn't need this but it helps make the code
                               easier to read}

{------------------------------------------------------------------------}

procedure Set_Vid_mode_to_320x200;

Begin
    asm
       mov ax, 13h      {store 13h in AX}
       int 10h          {call interrupt }
    end;
end;


{------------------------------------------------------------------------}

procedure Return_Vid_Mode_To_Text;

begin
   asm
    mov ax, 03h      {store 03h in AX}
    int 10h          {call interrupt }
   end;
end;

{------------------------------------------------------------------------}

procedure interupt (X,Y : Integer; Colour : Byte);

   { This puts a pixel on the screen using interrupts. }

begin
  asm
     mov        ah,0Ch
     mov        al,[colour]
     mov        cx,[x]
     mov        dx,[y]
     mov        bx,[1]
     int        10h
  end;
end;

{------------------------------------------------------------------------}

procedure Direct_Memory_Access (X,Y : Integer; Colour : Byte; Offset 
: Integer);

{This procedure places pixels using DMA, which is a lot faster}

begin

    Offset := (Y * 320) + X;      {as mentioned before, the Offset when using
                                  the DMA method, must be calculated}
    mem [VGA_SEGMENT:Offset] := Colour;
   
end;

{------------------------------------------------------------------------}

procedure assembler (X, Y : Integer; Colour : Byte);

begin
    asm
      mov ax, 0a000h   { point AX to video memory   }
      mov es, ax       { move segment pointer to ES }
                       { (actual pointer)           }
      mov bx, [Y]
      mov ax, bx       { register to register is faster by 1 clock}

      mov ah, al       { ax=y*256 + y}
      mov al,  0       { ax=y*256    }

      shl bx, 6        { bx=y*64     }
      add bx, ax       { bx=y*320    }

      add bx, [X]      { ax=(y*320)+x}
      mov di, bx       { move video pointer to correct place}

      mov al, [Colour]
      mov es:[di], al  { move colour to memory }
   end;
end;

{------------------------------------------------------------------------}
procedure print_intro;

begin
    ClrScr;
    WriteLn ('This program aims to demonstrate 3 ways of writing 
pixels to the screen.' );
    WriteLn ;
    WriteLn ('1. Interrupt pixels - This routine uses Int. 10h to 
place a pixel (part ASM)' );
    WriteLn ;
    WriteLn ('2. DMA pixels       - These pixels are placed on screen 
by writing directly');
    WriteLn ('                      to memory.');
    WriteLn ;
    WriteLn ('3. ASM pixels       - This PutPixel routine was written 
in assembler for speed.');
    WriteLn ('');
    WriteLn ('Each time the pixels will be painted on the screen from l-r.');
    WriteLn ('Notice the differance in speed each time.');
    WriteLn ('');
    WriteLn ('Hit any key to continue..........');
    ReadKey;
end;

{------------------------------------------------------------------------}

procedure print_outro;

begin
    ClrScr;
    WriteLn ;
    WriteLn ;
    WriteLn ('Thats all for this issue..');
    WriteLn ;
    WriteLn ('Barny Mercer - 29/7/95 @ 12:39');
    WriteLn ('barny.mercer@zetnet.co.uk  ');
    WriteLn ;
    WriteLn ('Ported to pascal by Richard Griffiths.');
    WriteLn ('richard.griffiths@zetnet.co.uk');
    WriteLn ;
    WriteLn ('Thanks Richard - Barny');
    ReadKey;
end;


{------------------------------------------------------------------------}

procedure print_interupt_pixel;

var counter_X, counter_Y : Integer;

begin
  For counter_X:=0 to 319 do
    For counter_Y:=0 to 199 do
      interupt (counter_X, counter_Y, Random (256));
  Readkey;
end;

{------------------------------------------------------------------------}

procedure print_DMA_pixel;


var counter_X, counter_Y : Integer;

begin
  For counter_X:=0 to 319 do
    For counter_Y:=0 to 199 do
        Direct_Memory_Access (counter_X, counter_Y, Random (256));
    ReadKey;
end;


{------------------------------------------------------------------------}

procedure print_ASM_pixel;

var pixel_X, pixel_Y : Integer;

begin
  for pixel_x:=0 to 319 do
    for pixel_Y:=0 to 199 do
     assembler  (pixel_x, pixel_Y, Random (256));
  Readkey;
end;

{------------------------------------------------------------------------}

begin       {The main program}

     Print_intro;
     Set_Vid_mode_to_320x200;
     print_interupt_pixel;
     print_DMA_pixel;
     print_ASM_pixel;
     Return_Vid_Mode_to_Text;
     Print_outro;

end.
 



